<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Manager List'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="selon-add-btn pb-20">
                <a href="<?php echo e(setRoute('vendors.manager.create')); ?>" class="btn--base"><i class="las la-plus"></i>
                    <?php echo e(__('Add Manager')); ?></a>
            </div>
            <div class="my-salon parlour-list-area">
                <div class="table-responsive">
                    <table class="custom-table">
                        <thead>
                            <tr>
                                <th></th>
                                <th><?php echo e(__('Name')); ?></th>
                                <th><?php echo e(__('Email')); ?></th>
                                <th><?php echo e(__('Salon')); ?></th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__empty_1 = true; $__currentLoopData = $data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr data-item="<?php echo e(json_encode($item)); ?>" class="text-light">
                                    <td>
                                        <ul class="user-list">
                                            <li> <img class="avatar" src="<?php echo e(get_image($item->image, 'manager-profile')); ?>"
                                                    alt="client"></li>
                                        </ul>
                                    </td>
                                    <td>
                                        <?php echo e($item->firstname . ' ' . $item->lastname ?? ''); ?>

                                    </td>
                                    <td><?php echo e($item->email ?? ''); ?></td>
                                    <td>
                                        <?php if($item->parlourlist->isNotEmpty()): ?>
                                            <?php $__currentLoopData = $item->parlourlist; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $parlour): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if(!empty($parlour->name)): ?>
                                                    <?php echo e($parlour->name); ?>

                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <?php echo e(__('Not assign')); ?>

                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn--base edit-modal-button"><i
                                                    class="las la-pencil-alt"></i></button>
                                            <button class="btn btn--danger delete-btn"><i
                                                    class="las la-trash-alt"></i></button>
                                        </div>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <td colspan="7">
                                    <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                        <?php echo e(__('No Record Found!')); ?>

                                    </div>
                                </td>
                            <?php endif; ?>

                        </tbody>

                    </table>
                </div>
            </div>
        </div>
        <?php echo e(get_paginate($data)); ?>

    </div>

    
    <div id="manager-update" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header px-0">
                <h5 class="modal-title"><?php echo e(__('Update Manager')); ?></h5>
            </div>
            <div class="modal-form-data">
                <form class="modal-form" method="POST" action="<?php echo e(setRoute('vendors.manager.update')); ?>"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="target" value="<?php echo e(old('target')); ?>">

                    <div class="row mb-10-none mt-3">
                        <div class="col-xl-12 col-lg-12 form-group">
                            <?php echo $__env->make('admin.components.form.input', [
                                'label' => __('First Name'),
                                'label_after' => '*',
                                'name' => 'first_name_edit',
                                'value' => old('first_name_edit'),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group">
                            <?php echo $__env->make('admin.components.form.input', [
                                'label' => __('Last Name'),
                                'label_after' => '*',
                                'name' => 'last_name_edit',
                                'value' => old('last_name_edit'),
                            ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        </div>

                        <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                            <button type="button" class="btn btn--danger modal-close"><?php echo e(__('Cancel')); ?></button>
                            <button type="submit" class="btn btn--base"><?php echo e(__('Update')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        openModalWhenError("manager-update", "#manager-update");
        $(".edit-modal-button").click(function() {

            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            var editModal = $("#manager-update");

            editModal.find("form").first().find("input[name=target]").val(oldData.id);

            editModal.find("input[name=first_name_edit").val(oldData.firstname);
            editModal.find("input[name=last_name_edit").val(oldData.lastname);

            openModalBySelector("#manager-update");

        });
        $('.delete-btn').click(function() {
            var oldData = JSON.parse($(this).closest('[data-item]').attr('data-item')); // Corrected selector
            var actionRoute = "<?php echo e(setRoute('vendors.manager.delete')); ?>";
            var target = oldData.id;
            var message =
                `<?php echo e(__('Are you sure to')); ?> <strong><?php echo e(__('delete')); ?></strong> <?php echo e(__('this Manager?')); ?>`;

            openDeleteModal(actionRoute, target, message);
        });


        function openDeleteModal(URL, target, message, actionBtnText = "<?php echo e(__('Remove')); ?>", method = "DELETE") {
            if (URL == "" || target == "") {
                return false;
            }

            if (message == "") {
                message = "<?php echo e(__('Are you sure to delete ?')); ?>";
            }
            var method = `<input type="hidden" name="_method" value="${method}">`;
            openModalByContent({
                    content: `<div class="card modal-alert border-0">
                        <div class="card-body">
                            <form method="POST" action="${URL}">
                                <input type="hidden" name="_token" value="${laravelCsrf()}">
                                ${method}
                                <div class="head mb-3">
                                    ${message}
                                    <input type="hidden" name="target" value="${target}">
                                </div>
                                <div class="foot d-flex align-items-center justify-content-between">
                                    <button type="button" class="modal-close btn btn--info"><?php echo e(__('Close')); ?></button>
                                    <button type="submit" class="alert-submit-btn btn btn--danger btn-loading">${actionBtnText}</button>
                                </div>
                            </form>
                        </div>
                    </div>`,
                },

            );
        }

        function openModalByContent(data = {
            content: "",
            animation: "mfp-move-horizontal",
            size: "medium",
        }) {
            $.magnificPopup.open({
                removalDelay: 500,
                items: {
                    src: `<div class="white-popup mfp-with-anim ${data.size ?? "medium"}">${data.content}</div>`, // can be a HTML string, jQuery object, or CSS selector
                },
                callbacks: {
                    beforeOpen: function() {
                        this.st.mainClass = data.animation ?? "mfp-move-horizontal";
                    },
                    open: function() {
                        var modalCloseBtn = this.contentContainer.find(".modal-close");
                        $(modalCloseBtn).click(function() {
                            $.magnificPopup.close();
                        });
                    },
                },
                midClick: true,
            });
        }
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/manager/index.blade.php ENDPATH**/ ?>