<?php

    $app_local = get_default_language_code() ?? 'en';
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::BANNER_SECTION);
    $banner = App\Models\Admin\SiteSections::getData($slug)->first();

?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Banner Section
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<div class="banner-section bg-overlay-banner bg_img"
    data-background="<?php echo e(isset($banner->value->image) ? get_image($banner->value->image, 'site-section') : asset('path/to/default/image.jpg')); ?>">

    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="banner-content">
                    <h1 class="title">
                        <?php echo e($banner->value->language->$app_local->heading ?? ($banner->value->language->$default->heading ?? '')); ?>

                    </h1>
                    <p><?php echo e($banner->value->language->$app_local->sub_heading ?? ''); ?></p>
                    <div class="banner-btn">
                        <a href="<?php echo e(setRoute('frontend.find.parlour')); ?>"
                            class="btn--base btn"><?php echo e($banner->value->language->$app_local->left_button ?? ($banner->value->language->$default->left_button ?? '')); ?></a>
                        <a href="<?php echo e(setRoute('vendors.login')); ?>"
                            class="btn--base btn"><?php echo e($banner->value->language->$app_local->right_button ??
                                ($banner->value->language->$default->right_button ?? '')); ?>

                            <i class="fab fa-telegram-plane"></i></a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Banner Section
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/section/banner.blade.php ENDPATH**/ ?>