<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Booking Request'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $__empty_1 = true; $__currentLoopData = $booking_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="dashboard-list-wrapper mt-2" data-item="<?php echo e(json_encode($item)); ?>">
            <div class="dashboard-list-item-wrapper">
                <div class="dashboard-list-item sent">
                    <div class="dashboard-list-left">
                        <div class="dashboard-list-user-wrapper">
                            <div class="dashboard-list-user-icon">
                                <img src="<?php echo e(get_image($item->parlour->image ?? '', 'site-section') ?? ''); ?>" alt="img">
                            </div>
                            <div class="dashboard-list-user-content">
                                <h4 class="title"><?php echo e($item->user->username); ?></h4>
                                <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="dashboard-list-right">
                         <?php if($item->review == null): ?>
                                        <p><?php echo e(__('No review given')); ?></p>
                                    <?php else: ?>
                                        <div class="star-rating-display">
                                            <?php for($i = 1; $i <= 5; $i++): ?>
                                                <?php if($i <= $item->review): ?>
                                                    <span class="star-filled">★</span>
                                                <?php else: ?>
                                                    <span class="star-empty">☆</span>
                                                <?php endif; ?>
                                            <?php endfor; ?>
                                            <span class="rating-value">(<?php echo e($item->review); ?>/5)</span>
                                        </div>
                                    <?php endif; ?>
                        <h4 class="main-money text--base">
                            <?php echo e(\Carbon\Carbon::parse($item->date)->format('jS M Y')); ?>

                        </h4>
                        <h4 class="main-money text--base">
                            <?php echo e(\Carbon\Carbon::parse($item->schedule->from_time)->format('h:i A') . ' - ' . \Carbon\Carbon::parse($item->schedule->to_time)->format('h:i A')); ?>

                        </h4>
                    </div>
                </div>
                <div class="preview-list-wrapper">
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-user"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Name')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e($item->user->username); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-envelope"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Email')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e($item->user->email); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-hand-holding-heart"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Service Type')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(is_array($item->service) ? implode(', ', $item->service) : $item->service); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-history"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Schedule Date')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e($item->date); ?></span>

                        </div>

                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Charge')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e(getAmount($item->total_charge)); ?>

                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Total')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e(getAmount($item->payable_price)); ?>

                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-wallet"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Payment Type')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <?php if($item->payment_method == 'Cash Payment'): ?>
                                <span"><?php echo e('Cash Payment'); ?>

                                </span">
                            <?php else: ?>
                                <span"><?php echo e('Online Payment'); ?>

                                </span">
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Serial No')); ?>.</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e(getAmount($item->serial_number)); ?>

                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-smoking"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Status')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right text-center">

                            <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>

                        </div>
                    </div>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-users-cog"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Staff')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">

                            <?php if($item->stuff != null): ?>
                                <span><?php echo e($item->stuff->stuff_name); ?></span>
                            <?php else: ?>
                                <p> <?php echo e(__('Staff Not Assign')); ?></p>
                            <?php endif; ?>

                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-clock"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Schedule')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e($item->schedule->from_time . ' - ' . $item->schedule->to_time); ?>

                            </span">
                        </div>
                    </div>
                           <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-clock"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('User Comment')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e($item->comment ?? 'N/A'); ?>

                            </span">
                        </div>
                    </div>
                </div>
            </div>
        </div>

    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <td colspan="7">
            <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                <?php echo e(__('No Record Found!')); ?>

            </div>
        </td>
    <?php endif; ?>
    <?php echo e(get_paginate($booking_data)); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/booking-request/details.blade.php ENDPATH**/ ?>