<?php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::VENDOR_BANNER_SECTION);
    $banner = App\Models\Admin\SiteSections::getData($slug)->first();

?>

<section class="vendor-banner bg-overlay-vendor bg_img"
        data-background="<?php echo e(isset($banner->value->image) ? get_image($banner->value->image, 'site-section') : asset('path/to/default/image.jpg')); ?>">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-10 col-md-12">
                    <div class="vendor-banner-content">
                        <div class="banner-title">
                            <h1 class="title">
                                <?php echo e($banner->value->language->$app_local->heading ?? ($banner->value->language->$default->heading ?? '')); ?>

                            </h1>
                        </div>
                        <div class="banner-subtitle">
                            <p><?php echo e($banner->value->language->$app_local->sub_heading ?? ''); ?></p>
                        </div>
                        <div class="banner-btn">
                            <a href="<?php echo e(setRoute('vendors.login')); ?>"
                                class="btn--base"><?php echo e($banner->value->language->$app_local->button ?? ($banner->value->language->$default->button ?? '')); ?>

                                <i class="las la-cut"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/frontend/section/vendor-banner.blade.php ENDPATH**/ ?>