<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('manager.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Booking Request'),
                'url' => setRoute('manager.dashboard'),
            ],
        ],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <?php $__empty_1 = true; $__currentLoopData = $booking_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="dashboard-list-wrapper mt-2" data-item="<?php echo e(json_encode($item)); ?>">
            <div class="dashboard-list-item-wrapper">
                <div class="dashboard-list-item sent">
                    <div class="dashboard-list-left">
                        <div class="dashboard-list-user-wrapper">
                            <div class="dashboard-list-user-icon">
                                <img src="<?php echo e(get_image($item->parlour->image ?? '', 'site-section') ?? ''); ?>" alt="img">
                            </div>
                            <div class="dashboard-list-user-content">
                                <h4 class="title"><?php echo e($item->user->username); ?></h4>
                                <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                            </div>
                        </div>
                    </div>
                    <div class="dashboard-list-right">
                        <h4 class="main-money text--base">
                            <?php echo e(\Carbon\Carbon::parse($item->date)->format('jS M Y')); ?>

                        </h4>
                        <h4 class="main-money text--base">
                            <?php echo e(\Carbon\Carbon::parse($item->schedule->from_time)->format('h:i A') . ' - ' . \Carbon\Carbon::parse($item->schedule->to_time)->format('h:i A')); ?>

                        </h4>
                    </div>
                </div>
                <div class="preview-list-wrapper">
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-user"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Name')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e($item->user->username); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-envelope"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Email')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e($item->user->email); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-hand-holding-heart"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Service Type')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(is_array($item->service) ? implode(', ', $item->service) : $item->service); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-history"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Schedule Date')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e($item->date); ?></span>

                        </div>

                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Charge')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e(getAmount($item->total_charge)); ?>

                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Total')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e(getAmount($item->payable_price)); ?>

                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Serial No')); ?>.</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e(getAmount($item->serial_number)); ?>

                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-smoking"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Status')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right text-center">
                            <?php if($item->status == 2): ?>
                                <form action="<?php echo e(setRoute('manager.booking.request.status.update', $item->trx_id)); ?>"
                                    method="post">
                                    <?php echo csrf_field(); ?>
                                    <button type="submit" name="status" value="3"
                                        class="service-btn-1"><?php echo e(__('Reject')); ?></button>
                                    <button type="submit" name="status" value="1"
                                        class="service-btn"><?php echo e(__('Accept')); ?></button>
                                </form>
                            <?php else: ?>
                                <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Staff')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <?php if($item->status == 1): ?>
                                <?php if($item->stuff != null): ?>
                                    <span><?php echo e($item->stuff->stuff_name); ?></span>
                                <?php else: ?>
                                    <button type="submit" name="status" value="3"
                                        class="service-btn-1 edit-modal-button"><?php echo e(__('Assign Staff')); ?></button>
                                <?php endif; ?>
                            <?php else: ?>
                                <span class=""><?php echo e(__('Staff not Assigned')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Schedule')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span"><?php echo e($item->schedule->from_time . ' - ' . $item->schedule->to_time); ?>

                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Reminder (optional)')); ?></span>
                                </div>
                            </div>
                        </div>
                        <?php if($item->notes != null): ?>
                            <div class="preview-list-right">
                                <span"><?php echo e($item->notes); ?>

                                </span">
                            </div>
                        <?php else: ?>
                            <div class="preview-list-right">
                                <form action="<?php echo e(route('manager.booking.request.remarks', ['id' => $item->id])); ?>"
                                    method="POST" class="row g-2 align-items-center">
                                    <?php echo csrf_field(); ?>
                                    <div class="col-md-8">
                                        <input type="text" name="remarks" class="form-control"
                                            placeholder="<?php echo e(__('Enter remarks')); ?>" style="background-color: black">
                                    </div>
                                    <div class="col-md-4">
                                        <button type="submit" class="btn btn-primary w-100"><?php echo e(__('Add')); ?></button>
                                    </div>
                                </form>

                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <td colspan="7">
            <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                <?php echo e(__('No Record Found!')); ?>

            </div>
        </td>
    <?php endif; ?>

    
    <div id="manage-stuff" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header px-0">
                <h5 class="modal-title"><?php echo e(__('Manage Staff')); ?></h5>
            </div>
            <div class="modal-form-data">
                <form class="modal-form" method="POST" action="<?php echo e(setRoute('manager.assign.stuff.store.submit')); ?>"
                    enctype="multipart/form-data">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('POST'); ?>
                    <input type="hidden" name="target" value="<?php echo e(old('target')); ?>">
                    <div class="row mb-10-none">
                        <div class="card-inner-body">
                            <div class="stuff-result">
                                <div class="row">
                                    <input name="parlour_booking_id" hidden />
                                    <label><?php echo e(__('Select Staff')); ?>*</label>
                                    <select class="form--control select2-basic" name="stuff_name">
                                        <option disabled selected><?php echo e(__('Select Staff')); ?></option>
                                        <?php $__currentLoopData = $parlour_has_stuff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <option value="<?php echo e($item->id); ?>"><?php echo e($item->stuff_name); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                            <button type="button" class="btn btn--danger modal-close"><?php echo e(__('Cancel')); ?></button>
                            <button type="submit" class="btn btn--base"><?php echo e(__('Assign')); ?></button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        openModalWhenError("manage-stuff", "#manage-stuff");

        $(".edit-modal-button").click(function() {
            var data = JSON.parse($(this).parents("div.dashboard-list-wrapper").attr("data-item"));

            var modal = $("#manage-stuff");

            modal.find("form").first().find("input[name=parlour_booking_id]").val(data.id);

            openModalBySelector("#manage-stuff");
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('manager.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/manager/section/booking-request/index.blade.php ENDPATH**/ ?>