<?php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::DOWNLOAD_APP_SECTION);
    $download_app = App\Models\Admin\SiteSections::getData($slug)->first();

?>
<!-- app section -->
<section class="app-section ptb-80">
    <div class="container">
        <div class="app-section-title pb-40">
            <div class="row">
                <div class="col-lg-7">
                    <div class="app-title">
                        <h2 class="title">
                            <?php echo e($download_app->value->language->$app_local->heading ?? ($download_app->value->language->$default->heading ?? '')); ?>

                        </h2>
                    </div>
                    <p> <?php echo e($download_app->value->language->$app_local->sub_heading ?? ($download_app->value->language->$default->sub_heading ?? '')); ?>

                    </p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-5 pb-30">
                <div class="app-btn-wrapper">
                    <?php $__currentLoopData = $download_app->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a href="<?php echo e($item->link); ?>" class="app-btn">
                            <div class="app-icon">
                                <i class="<?php echo e($item->icon ?? ''); ?>"></i>
                            </div>
                            <div class="content">
                                <span><?php echo e($item->language->$app_local->item_title ?? ($item->language->$default->item_title ?? '')); ?></span>
                                <h5 class="title">
                                    <?php echo e($item->language->$app_local->item_heading ?? ($item->language->$default->item_heading ?? '')); ?>

                                </h5>
                            </div>
                            <div class="icon">
                                <img src="<?php echo e(get_image($item->image, 'site-section')); ?>" alt="element">
                            </div>
                            <div class="app-qr">
                                <img src="<?php echo e(get_image($item->image, 'site-section')); ?>" alt="element">
                            </div>
                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
            <div class="col-lg-7">
                <div class="app-img">
                    <img src="<?php echo e(get_image($download_app?->value?->image, 'site-section')); ?>" alt="img">
                </div>
            </div>
        </div>
    </div>
</section>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/frontend/section/download-app.blade.php ENDPATH**/ ?>