<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Salon List'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Salon List'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-body">
            <form class="card-form" action="<?php echo e(setRoute('vendors.parlour.list.update', $parlour_list->slug)); ?>" method="POST"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
       
                <?php
                    $minImages = 4; // Minimum required Salon Previews
                    $existingImages = $parlour_list->parlourImage;
                    $countExisting = $existingImages->count();
                    $extraNeeded = max(0, $minImages - $countExisting);
                ?>
                <div class="row justify-content-center">
                    <div class="col-xl-12 col-lg-12 col-12 form-group mb-5">
                        <div class="custom-inner-card input-field-generator" data-source="booking_file_input">
                            <div class="row align-items-end">
                                <div class="row justify-content-center">
                                    <div class="col-xl-4 col-lg-4 form-group mb-5">

                                        <?php echo $__env->make('admin.components.form.input-file', [
                                            'label' => __('Thumbnail Preview'),
                                            'name' => 'image',
                                            'class' => 'file-holder',
                                            'old_files_path' => files_asset_path('site-section'),
                                            'old_files' => old('old_image', $parlour_list->image),
                                            'attribute' => 'data-height=130',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                </div>
                                <?php $__currentLoopData = $existingImages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $previewImage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 form-group">
                                        <?php echo $__env->make('admin.components.form.input-file', [
                                            'label' => __('Salon Preview') . '<span>(optional)</span>',
                                            'name' => 'preview[]',
                                            'class' => 'file-holder',
                                            'old_files_path' => files_asset_path('site-section'),
                                            'old_files' => $previewImage->image_path,
                                            'attribute' => 'data-height=130',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                
                                <?php for($i = 0; $i < $extraNeeded; $i++): ?>
                                    <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 form-group">
                                        <?php echo $__env->make('admin.components.form.input-file', [
                                            'label' => __('Salon Preview') . '<span>(optional)</span>',
                                            'name' => 'preview[]',
                                            'class' => 'file-holder',
                                            'attribute' => 'data-height=130',
                                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                    </div>
                                <?php endfor; ?>

                            </div>
                        </div>
                    </div>

                </div>

                
                <div class="row justify-content-center mb-10-none">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__('Select Area')); ?>*</label>
                        <select class="form--control select2-basic" name="area">
                            <option disabled selected><?php echo e(__('Select Area')); ?></option>
                            <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>"
                                    <?php echo e($item->id == $parlour_list->area_id ? 'selected' : ''); ?>><?php echo e($item->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__('Select Manager')); ?>*</label>
                        <select class="form--control select2-basic" name="manager">
                            <option disabled selected><?php echo e(__('Select Manager')); ?></option>
                            <?php $__currentLoopData = $manager; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>"
                                    <?php echo e($item->id == $parlour_list->manager_id ? 'selected' : ''); ?>>
                                    <?php echo e($item->firstname); ?> <?php echo e($item->assign_status == 1 ? '(Assigned)' : ''); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Name') . '*',
                            'name' => 'name',
                            'placeholder' => __('Write Name') . '...',
                            'value' => old('name', $parlour_list->name),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Experience') . '*',
                            'name' => 'experience',
                            'placeholder' => __('Write Experience') . '...',
                            'value' => old('experience', $parlour_list->experience),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Speciality'),
                            'name' => 'speciality',
                            'placeholder' => __('Write Speciality') . '...',
                            'value' => old('speciality', $parlour_list->speciality),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Contact') . '*',
                            'name' => 'contact',
                            'placeholder' => __('Write Contact') . '...',
                            'value' => old('contact', $parlour_list->contact),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Address'),
                            'name' => 'address',
                            'placeholder' => __('Write Address') . '...',
                            'value' => old('address', $parlour_list->address),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <h3 class="title"><?php echo e(__('Off Days')); ?></h3>
                        <div class="card-inner-body">
                            <div class="stuff-result">
                                <div class="row">
                                    <?php $__currentLoopData = getWeekDays(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php
                                            $oldOffDays = old('off_days', $parlour_list->off_days);
                                            $oldOffDaysArray = is_array($oldOffDays)
                                                ? $oldOffDays
                                                : explode(',', $oldOffDays);
                                            $isChecked = in_array($day['value'], $oldOffDaysArray);
                                        ?>
                                        <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                            <div class="box-checkbox" style="flex: 0;">
                                                <input type="checkbox" class="form-check-input" name="off_days[]"
                                                    value="<?php echo e($day['value']); ?>" id="day-<?php echo e($loop->index); ?>"
                                                    <?php echo e($isChecked ? 'checked' : ''); ?>>
                                            </div>
                                            <div class="box-name mt-1">
                                                <label class="form-check-label ms-1" for="day-<?php echo e($loop->index); ?>">
                                                    <?php echo e($day['day_name']); ?>

                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>
                    </div>


                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Number Of Dates') . '*',
                            'name' => 'number_of_dates',
                            'placeholder' => __('Number Of Dates') . '...',
                            'value' => old('number_of_dates', $parlour_list->number_of_dates),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php
                            $currentDate = \Carbon\Carbon::now();
                            $schedule_date = $parlour_list->number_of_dates;
                        ?>
                        <label><?php echo e(__('Selected Days')); ?></label>
                        <select class="form--control select2-basic">
                            <?php for($i = 0; $i < $schedule_date; $i++): ?>
                                <option><?php echo e($currentDate->format('d F, Y')); ?></option>
                                <?php
                                    $currentDate->addDay();
                                ?>
                            <?php endfor; ?>
                        </select>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header pb-10 d-flex justify-content-between">
                                <h3 class="title"><?php echo e(__('Service')); ?></h6>
                                    <button type="button" class="btn--base add-service-btn"><i class="fas fa-plus"></i>
                                        <?php echo e(__('Add')); ?></button>
                            </div>
                            <div class="card-inner-body">
                                <div class="result">
                                    <?php echo $__env->make(
                                        'admin.components.parlour-list.service-item',
                                        compact('parlour_has_service'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header">
                                <h3 class="title"><?php echo e(__('Staff')); ?></h6>
                            </div>
                            <div class="card-inner-body">
                                <div class="stuff-result">
                                    <div class="row">
                                        <?php $__currentLoopData = $parlour_has_stuff ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php
                                                $isChecked = $parlour_list->id === $item->parlour_list_id;
                                            ?>
                                            <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                                <div class="box-checkbox" style="flex: 0;">
                                                    <input type="checkbox" name="stuff_name[]" class="stuff-name-checkbox"
                                                        id="stuff-name-list-<?php echo e($item->id); ?>"
                                                        <?php if($isChecked): ?> checked <?php endif; ?>
                                                        value="<?php echo e($item->id); ?>">
                                                </div>
                                                <div class="box-name mt-1">
                                                    <?php echo e($item->stuff_name); ?>

                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header pb-10 d-flex justify-content-between">
                                <h3 class="title"><?php echo e(__('Schedule')); ?></h6>
                                    <button type="button" class="btn--base add-schedule-btn"><i class="fas fa-plus"></i>
                                        <?php echo e(__('Add')); ?></button>
                            </div>
                            <div class="card-inner-body">
                                <div class="results">
                                    <?php echo $__env->make(
                                        'admin.components.parlour-list.schedule-item',
                                        compact('parlour_has_schedule'), \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <?php echo $__env->make('admin.components.button.form-btn', [
                            'class' => 'w-100 btn-loading',
                            'text' => 'Submit',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            var getDayURL = "<?php echo e(setRoute('vendors.parlour.list.get.days')); ?>";
            $('.add-schedule-btn').click(function() {
                $.get(getDayURL, function(data) {
                    $('.results').prepend(data);
                    $('.results').find('.row').first().find("select").select2();
                });
            });

            var getServiceURL = "<?php echo e(setRoute('vendors.parlour.list.get.service')); ?>";
            $('.add-service-btn').click(function() {
                $.get(getServiceURL, function(data) {
                    $('.result').prepend(data);
                    $('.result').find('.row').first().find("select").select2();
                });
            });

            var getStuffURL = "<?php echo e(setRoute('vendors.parlour.list.get.stuff')); ?>";
            $('.add-stuff-btn').click(function() {
                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
   
    <script>
        $(document).ready(function() {
            $(document).on('click', '.delete-image', function() {
                if (confirm('Are you sure you want to delete this image?')) {
                    const imageId = $(this).data('id');
                    const $imageCard = $(this).closest('.custom-inner-card');

                    $.ajax({
                        url: "<?php echo e(route('vendors.parlour.list.image.delete')); ?>",
                        type: 'POST',
                        data: {
                            _token: $('meta[name="csrf-token"]').attr('content'),
                            image_id: imageId
                        },
                        success: function(response) {
                            // Remove the image card from UI on success
                            $imageCard.remove();
                            console.log('Image deleted successfully', response);

                            // Optional: Show success message
                            alert('Image deleted successfully!');
                        },
                        error: function(xhr, status, error) {
                            console.error('Error deleting image:', error);

                            // Optional: Show error message
                            alert('Error deleting image. Please try again.');
                        }
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/parlour-list/edit.blade.php ENDPATH**/ ?>