<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('user.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('user.dashboard'),
            ],
        ],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="dashboard-card-area pt-3">
        <div class="row mb-20-none">
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 mb-20">
                <div class="dasboard-card-item bg-overlay bg_img">
                    <div class="card-title">
                        <span class="title"><?php echo e(__('Total Transactions')); ?></span>
                        <h4 class="sub-title text--base"><?php echo e($total_transactions ?? 0); ?></h4>
                    </div>
                    <div class="card-icon">
                        <i class="las la-dollar-sign"></i>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 mb-20">
                <div class="dasboard-card-item bg-overlay  bg_img">
                    <div class="card-title">
                        <span class="title"><?php echo e(__('Total Online Transactions')); ?></span>
                        <h4 class="sub-title text--base"><?php echo e($total_online_transactions ?? 0); ?></h4>
                    </div>
                    <div class="card-icon">
                        <i class="menu-icon las la-history"></i>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 mb-20">
                <div class="dasboard-card-item bg-overlay  bg_img">
                    <div class="card-title">
                        <span class="title"><?php echo e(__('Total Cash Payments')); ?></span>
                        <h4 class="sub-title text--base"><?php echo e($total_cash_transactions ?? 0); ?></h4>
                    </div>
                    <div class="card-icon">
                        <i class="las la-cloud-upload-alt"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="chart-container">
        <div class="chart-main" id="chart" class="chart" data-chart_one_data="<?php echo e(json_encode($data['chart_one_data'])); ?>"
            data-month_day="<?php echo e(json_encode($data['month_day'])); ?>">
        </div>
    </div>
    <div class="booking-history pt-60">
        <div class="title-header pb-20">
            <h3 class="title"><?php echo e(__('Recent Bookings')); ?></h3>
        </div>
        <div class="dashboard-list-wrapper">
            <?php $__empty_1 = true; $__currentLoopData = $booking_data ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="dashboard-list-item-wrapper show">
                    <div class="dashboard-list-item sent">
                        <div class="dashboard-list-left">
                            <div class="dashboard-list-user-wrapper">
                                <div class="dashboard-list-user-icon">
                                    <img src="<?php echo e(get_image($item->parlour->image, 'site-section')); ?>" alt="user">
                                </div>
                                <div class="dashboard-list-user-content">
                                    <h4 class="title"><?php echo e($item->parlour->name); ?></h4>
                                   <span
                                        class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="dashboard-list-right">
                            <h4 class="main-money text--base"> <?php echo e(\Carbon\Carbon::parse($item->date)->format('jS M Y')); ?></h4>
                        </div>
                    </div>
                    <div class="preview-list-wrapper">
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-user"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Name')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span><?php echo e($item->user->username); ?></span>
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-envelope"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Email')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span><?php echo e($item->user->email); ?></span>
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-hand-holding-heart"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Service Type')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span><?php echo e(is_array($item->service) ? implode(', ', $item->service) : $item->service); ?></span>
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-history"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Schedule Date')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span><?php echo e($item->date); ?></span>

                            </div>

                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-battery-half"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Charge')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span"><?php echo e(getAmount($item->total_charge)); ?>

                                </span">
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-battery-full"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Total')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span"><?php echo e(getAmount($item->payable_price)); ?>

                                </span">
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-battery-full"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Serial No')); ?>.</span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span"><?php echo e(getAmount($item->serial_number)); ?>

                                </span">
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-smoking"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Status')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right text-center">

                                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>

                            </div>
                        </div>

                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-users-cog"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Staff')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">

                                    <?php if($item->stuff != null): ?>
                                        <span><?php echo e($item->stuff->stuff_name); ?></span>
                                    <?php else: ?>
                                        <p> <?php echo e(__('Staff Not Assign')); ?></p>
                                    <?php endif; ?>

                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-clock"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Schedule')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span"><?php echo e($item->schedule->from_time . ' - ' . $item->schedule->to_time); ?>

                                </span">
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <td colspan="7">
                    <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                        <?php echo e(__('No Record Found!')); ?>

                    </div>
                </td>
            <?php endif; ?>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        // Retrieve the chart container and data
        const currentYear = new Date().getFullYear();
        var chart1 = $('#chart');
        var chart_one_data = chart1.data('chart_one_data'); // Get the data passed to the chart
        var month_day = chart1.data('month_day'); // Get the month_day data

        var formattedDates = month_day.map(date => {
            let d = new Date(date);
            return d.toLocaleDateString('en-US', {
                year: 'numeric',
                month: 'short',
                day: '2-digit'
            }).replace(',', '');
        });


        var options = {
            series: [{
                name: 'Completed Transactions',
                color: "#D860EC",
                data: chart_one_data.complete_data // Use the correct key
            }],
            chart: {
                type: 'bar',
                height: 350,
                stacked: true,
                toolbar: {
                    show: false
                },
                zoom: {
                    enabled: true
                }
            },
            plotOptions: {
                bar: {
                    horizontal: false,
                    borderRadius: 10
                },
            },
            xaxis: {
                type: 'categories', // Use categories instead of datetime
                categories: formattedDates,
            },
            legend: {
                position: 'bottom',
                offsetX: 40
            },
            title: {
                text: `Monthly Transactions, ${currentYear}`,
                floating: true,
                offsetY: 330,
                align: 'center',
                style: {
                    color: '#FFFFFF'
                }
            },
            fill: {
                opacity: 1
            }
        };

        // Render the chart
        var chart = new ApexCharts(document.querySelector("#chart"), options);
        chart.render();
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('user.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/user/dashboard.blade.php ENDPATH**/ ?>