<table class="custom-table booking-search-table">
    <thead>
        <tr>
            <th><?php echo e(__('Booking ID')); ?></th>
            <th><?php echo e(__('Salon Name')); ?></th>
            <th><?php echo e(__('Payment Type')); ?></th>
            <th><?php echo e(__('Service')); ?></th>
            <th><?php echo e(__('Schedule')); ?></th>
            <th><?php echo e(__('Price')); ?></th>
            <th><?php echo e(__('Review')); ?></th>
            <th><?php echo e(__('Status')); ?></th>
            <th></th>
        </tr>
    </thead>
    <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $transactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($item->trx_id ?? ''); ?></td>
                <td><?php echo e($item->parlour->name ?? ''); ?></td>
                <td><?php echo e($item->type ?? ''); ?></td>
                <td><?php echo e(is_array($item->service) ? implode(', ', $item->service) : $item->service); ?></td>
                <td><?php echo e($item->date ?? ''); ?> (<?php echo e($item->schedule->from_time); ?> -
                    <?php echo e($item->schedule->to_time); ?>)</td>
                <td><?php echo e(get_default_currency_symbol()); ?><?php echo e(get_amount($item->price)); ?></td>
                <td>
                    <?php if($item->review == null): ?>
                        <p><?php echo e(__('No review given')); ?></p>
                    <?php else: ?>
                        <div class="star-rating-display">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <?php if($i <= $item->review): ?>
                                    <span class="star-filled">★</span>
                                <?php else: ?>
                                    <span class="star-empty">☆</span>
                                <?php endif; ?>
                            <?php endfor; ?>
                            <span class="rating-value">(<?php echo e($item->review); ?>/5)</span>
                        </div>
                    <?php endif; ?>
                </td>
                <td>
                    <span class="<?php echo e($item->stringStatus->class); ?>"><?php echo e(__($item->stringStatus->value)); ?></span>
                </td>
                <td>
                    <a href="<?php echo e(route('user.my.booking.download.pdf', $item->slug)); ?>" class="btn btn-primary">
                        <i class="fas fa-download"></i> Download as PDF
                    </a>

                </td>
                <td><a href="<?php echo e(setRoute('user.my.booking.details', $item->slug)); ?>"
                        class="btn btn--base btn--primary"><i class="fas fa-eye"></i></a></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <td colspan="7">
                <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                    <?php echo e(__('No Record Found!')); ?>

                </div>
            </td>
        <?php endif; ?>
    </tbody>
</table>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/user/components/data-table/parlour-booking-table.blade.php ENDPATH**/ ?>