<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('manager.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('manager.dashboard'),
            ],
        ],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="dashboard-header-wrapper">
                <h4 class="title"><?php echo e(__('Manage Staff')); ?></h4>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th></th>
                            <th><?php echo e(__('Name')); ?></th>
                            <th><?php echo e(__('Status')); ?></th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $stuff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <tr data-item="<?php echo e(json_encode($item)); ?>">
                                <td><?php echo e($index + 1); ?></td>
                                <td><?php echo e($item->stuff_name); ?></td>
                                <td>
                                         <span class="badge <?php echo e($item->parlour_booking->count() > 0 ? 'badge--success' : 'badge--danger'); ?>"><?php echo e($item->parlour_booking->count() > 0 ? 'Assigned' : 'Not Assigned'); ?></span>
                                </td>
                                <td>
                                    <a href="<?php echo e(setRoute('manager.assign.stuff.details', ['stuff_id' => $item->id])); ?>"
                                        class="btn btn--base edit-modal-button">
                                        <i class="las la-eye"></i>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <td colspan="7">
                                <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                    <?php echo e(__('No Record Found!')); ?>

                                </div>
                            </td>
                        <?php endif; ?>

                    </tbody>
                </table>
            </div>
        </div>
        <?php echo e(get_paginate($stuff)); ?>

    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {
            var getStuffURL = "<?php echo e(setRoute('manager.assign.stuff.get.stuff')); ?>";
            $('.add-stuff-btn').click(function() {

                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            // Switcher
            switcherAjax("<?php echo e(setRoute('manager.assign.stuff.status.update')); ?>");
        })
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('manager.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/manager/section/assing-stuff/index.blade.php ENDPATH**/ ?>