<?php
    $app_local = get_default_language_code();
    $default = App\Constants\LanguageConst::NOT_REMOVABLE;

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::VENDOR_BANNER_SECTION);
    $banner = App\Models\Admin\SiteSections::getData($slug)->first();

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::VENDOR_FEATURES_SECTION);
    $features = App\Models\Admin\SiteSections::getData($slug)->first();

    $slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::VENDOR_REQUIREMENTS_SECTION);
    $requirements = App\Models\Admin\SiteSections::getData($slug)->first();

?>


<?php $__env->startSection('content'); ?>
    <!-- Vendor Landing page -->


    <section class="vendor-banner bg-overlay-vendor bg_img"
        data-background="<?php echo e(isset($banner->value->image) ? get_image($banner->value->image, 'site-section') : asset('path/to/default/image.jpg')); ?>">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-10 col-md-12">
                    <div class="vendor-banner-content">
                        <div class="banner-title">
                            <h1 class="title">
                                <?php echo e($banner->value->language->$app_local->heading ?? ($banner->value->language->$default->heading ?? '')); ?>

                            </h1>
                        </div>
                        <div class="banner-subtitle">
                            <p><?php echo e($banner->value->language->$app_local->sub_heading ?? ''); ?></p>
                        </div>
                        <div class="banner-btn">
                            <a href="<?php echo e(setRoute('vendors.login')); ?>"
                                class="btn--base"><?php echo e($banner->value->language->$app_local->button ?? ($banner->value->language->$default->button ?? '')); ?>

                                <i class="las la-cut"></i></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>


    <!-- Vendor Feature -->
    <section class="vendor-feature ptb-80">
        <div class="container">
            <div class="vendor-feature-title pb-30">
                <div class="row">
                    <div class="col-xl-8 col-lg-10">
                        <div class="feature-title">
                            <h4 class="titte text--base pb-20">
                                <?php echo e($features->value->language->$app_local->section_title ?? ($features->value->language->$default->section_title ?? '')); ?>

                            </h4>
                            <h2 class="title">
                                <?php echo e($features->value->language->$app_local->heading ?? ($features->value->language->$default->heading ?? '')); ?>

                            </h2>
                            <p><?php echo e($features->value->language->$app_local->sub_heading ??
                                ($features->value->language->$default->sub_heading ?? '')); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>

            <?php
                $items = $features->value->items ?? [];
                $item_data = (array) $items;

                $converted_data =
                    count($item_data) > 0 ? array_chunk($item_data, ceil(count($item_data) / 2)) : [[], []];

                $part1 = $converted_data[0] ?? [];

                $part2 = $converted_data[1] ?? [];

            ?>
            <div class="row mb-20-none">
                <div class="col-lg-6 mb-20">
                    <div class="feature-content">
                        <div class="feature-listing">
                            <div class="row mb-20-none">
                                <?php $__currentLoopData = $part1 ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-12 mb-20">
                                        <div class="feature">
                                            <h3 class="title">
                                                <?php echo e($item->language->$app_local->title ?? ($item->language->$default->title ?? '')); ?>

                                            </h3>
                                            <p><?php echo e($item->language->$app_local->description ?? ($item->language->$default->description ?? '')); ?>

                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-6 mb-20">
                    <div class="feature-content">
                        <div class="feature-listing">
                            <div class="row mb-20-none">
                                <?php $__currentLoopData = $part2 ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="col-lg-12 mb-20">
                                        <div class="feature">
                                            <h3 class="title">
                                                <?php echo e($item->language->$app_local->title ?? ($item->language->$default->title ?? '')); ?>

                                            </h3>
                                            <p><?php echo e($item->language->$app_local->description ?? ($item->language->$default->description ?? '')); ?>

                                            </p>
                                        </div>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Vendor Requirements -->
    <section class="vendor-requirements pb-80">
        <div class="container">
            <div class="required-title mb-30">
                <div class="row">
                    <div class="col-xl-8 col-lg-10">
                        <h4 class="title text--base pb-20">
                            <?php echo e($requirements->value->language->$app_local->title ?? ($requirements->value->language->$default->title ?? '')); ?>

                        </h4>
                        <h2 class="title">
                            <?php echo e($requirements->value->language->$app_local->heading ?? ($requirements->value->language->$default->heading ?? '')); ?>

                        </h2>
                    </div>
                </div>
            </div>
            <div class="row mb-20-none">
                <?php $__currentLoopData = $requirements->value->items ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-lg-6 mb-20">
                        <div class="required-content">
                            <h3 class="title">
                                <i class="<?php echo e($value->icon ?? ''); ?>"></i>  <?php echo e($value->language->$app_local->title ?? ($value->language->$default->title ?? '')); ?>

                            </h3>
                            <?php $__currentLoopData = $value->detailsItem ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <ul class="requirements-list">
                                    <li><?php echo e($value->language->$app_local->details ?? ($value->language->$default->details ?? '')); ?>

                                    </li>
                                </ul>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('frontend.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/frontend/pages/vendor.blade.php ENDPATH**/ ?>