<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Manager List'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="row mb-20-none">
        <div class="col-xl-7 col-lg-7 mb-20">
            <div class="custom-card mt-10">
                <div class="dashboard-header-wrapper">
                    <h4 class="title"><?php echo e(__('Withdraw Money')); ?></h4>
                </div>
                <div class="card-body">
                    <div class="exchange-area text-center">
                        <code class="text-center"><span><?php echo e(__('Exchange Rate')); ?></span><span class="rate-show"></span></code>
                    </div>
                    <form class="withdraw-form" action="<?php echo e(setRoute('vendors.withdraw.money.submit')); ?>" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="form-group">
                            <label><?php echo e(__('Withdraw Amount')); ?><span>*</span></label>
                            <div class="input-form">
                                <input type="float" name="amount" id="amount-input" class="form--control"
                                    placeholder="<?php echo e(__('Enter Amount')); ?>">
                            </div>
                        </div>
                        <div class="form-group">
                            <label><?php echo e(__('Receiving Gateway')); ?><span>*</span></label>
                            <select class="nice-select" name="gateway_currency">
                                <option selected disabled value="0"><?php echo e(__('Select Gateway Currency')); ?></option>
                                <?php $__empty_1 = true; $__currentLoopData = $payment_gateways ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $currency): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <option value="<?php echo e($currency->alias); ?>"
                                        data-item="<?php echo e(json_encode($currency->only(['currency_code', 'rate', 'min_limit', 'max_limit', 'percent_charge', 'fixed_charge', 'crypto']))); ?>">
                                        <?php echo e($currency->name); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <?php endif; ?>
                            </select>
                            <code class="d-block mt-10 text-end balance-show">--</code>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group">
                            <div class="note-area">
                                <code class="d-block limit-show">--</code>
                                <code class="d-block charge-show">--</code>
                            </div>
                        </div>
                        <div class="sending-btn pt-3">
                            <button type="submit" class="btn--base w-100"><?php echo e(__('Withdraw Money')); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
        <div class="col-xl-5 col-lg-5 mb-20">
            <div class="custom-card mt-10">
                <div class="dashboard-header-wrapper">
                    <h4 class="title"><?php echo e(__('Summary')); ?></h4>
                </div>
                <div class="card-body">
                    <div class="preview-list-wrapper">
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-receipt"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Entered Amount')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span class="text--success enter-amount">--</span>
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-battery-half"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Total Fees & Charges')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span class="text--warning fees">--</span>
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="lab la-get-pocket"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span><?php echo e(__('Will Get')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span class="text--danger will-get">--</span>
                            </div>
                        </div>
                        <div class="preview-list-item">
                            <div class="preview-list-left">
                                <div class="preview-list-user-wrapper">
                                    <div class="preview-list-user-icon">
                                        <i class="las la-money-check-alt"></i>
                                    </div>
                                    <div class="preview-list-user-content">
                                        <span class="last"><?php echo e(__('Total Payable Amount')); ?></span>
                                    </div>
                                </div>
                            </div>
                            <div class="preview-list-right">
                                <span class="text--info last payable">--</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="dashboard-list-area mt-60 mb-30">
        <div class="dashboard-header-wrapper">
            <h4 class="title"><?php echo e(__('Latest Withdraw Money')); ?></h4>
            <div class="dashboard-btn-wrapper">
                <div class="dashboard-btn">
                    <a href="<?php echo e(setRoute('vendors.withdraw.money.logs')); ?>" class="btn--base"><?php echo e(__('View More')); ?></a>
                </div>
            </div>
        </div>
    </div>
    <div class="dashboard-list-wrapper">
        <?php $__empty_1 = true; $__currentLoopData = $transactions ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <div class="dashboard-list-item-wrapper">
                <div class="dashboard-list-item sent">
                    <div class="dashboard-list-left">
                        <div class="dashboard-list-user-wrapper">
                            <div class="dashboard-list-user-icon">
                                <i class="las la-arrow-up"></i>
                            </div>
                            <div class="dashboard-list-user-content">
                                <h4 class="title"><?php echo e(__('Withdraw Money')); ?> <span
                                        class="text-info"><?php echo e($value->gateway_currency->gateway->name); ?></span></h4>
                                <?php if($value->status === payment_gateway_const()::STATUSSUCCESS): ?>
                                    <span class="badge badge--success ms-2"><?php echo e(__('Success')); ?></span>
                                <?php elseif($value->status === payment_gateway_const()::STATUSPENDING): ?>
                                    <span class="badge badge--warning ms-2"><?php echo e(__('Pending')); ?></span>
                                <?php elseif($value->status === payment_gateway_const()::STATUSREJECTED): ?>
                                    <span class="badge badge--danger ms-2"><?php echo e(__('Reject')); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="dashboard-list-right">
                        <h4 class="main-money text--base">
                            <?php echo e(get_amount($value->request_amount)); ?> <?php echo e($value->payment_currency); ?>

                        </h4>
                        <h5 class="exchange-money"><?php echo e($value->created_at->format('d-m-Y')); ?></h5>
                    </div>
                </div>
                <div class="preview-list-wrapper">
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-exchange-alt"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('TRX ID')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e($value->trx_id); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-share-square"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Amount')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($value->request_amount)); ?> <?php echo e($value->payment_currency); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-coins"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Gateway')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e($value->gateway_currency->gateway->name); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Fees & Charges')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($value->total_charge)); ?> <?php echo e(get_default_currency_code()); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-receipt"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Payable Amount')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span><?php echo e(get_amount($value->total_payable)); ?> <?php echo e($value->request_currency); ?></span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="lab la-artstation"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span><?php echo e(__('Status')); ?></span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <?php if($value->status === payment_gateway_const()::STATUSSUCCESS): ?>
                                <span class="badge badge--success ms-2"><?php echo e(__('Success')); ?></span>
                            <?php elseif($value->status === payment_gateway_const()::STATUSPENDING): ?>
                                <span class="badge badge--warning ms-2"><?php echo e(__('Pending')); ?></span>
                            <?php elseif($value->status === payment_gateway_const()::STATUSREJECTED): ?>
                                <span class="badge badge--danger ms-2"><?php echo e(__('Reject')); ?></span>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <div class="alert alert-primary text-center"><?php echo e(__('No Transactions Found!')); ?></div>
        <?php endif; ?>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        let default_currency_code = "<?php echo e(get_default_currency_code()); ?>";
        let userBalanceRoute = "<?php echo e(setRoute('vendors.wallets.balance')); ?>";

        let criptoPrecision = <?php echo e($basic_settings->crypto_precision_value ?? 8); ?>;
        let fiatPrecision = <?php echo e($basic_settings->fiat_precision_value ?? 2); ?>;

        $(document).ready(function() {
            let gatewayCurrency = getSelectedCurrency($("select[name=gateway_currency]"));
            if (gatewayCurrency != false) {
                run(gatewayCurrency, false);
            }
        });

        $("select[name=gateway_currency]").change(function() {

            let gatewayCurrency = getSelectedCurrency($("select[name=gateway_currency]"));
            if (gatewayCurrency != false) {
                run(gatewayCurrency);
            }

        });
        $("input[name=amount]").keyup(function() {
            let gatewayCurrency = getSelectedCurrency($("select[name=gateway_currency]"));
            if (gatewayCurrency != false) {
                run(gatewayCurrency, false);
            }
        });

        function getSelectedCurrency(selectElement) {
            var selectedItem = selectElement.find(":selected");
            if (selectedItem != null, selectedItem != undefined) {
                return JSON.parse(selectedItem.attr("data-item"));
            }

            return false;
        }

        function run(gatewayCurrency, userBalance = true) {

            if (gatewayCurrency == false) {
                return false;
            }
            if (gatewayCurrency.length == 0) {
                return false;
            }

            let gatewayPrecision = gatewayCurrency.crypto == true ? criptoPrecision : fiatPrecision;

            function acceptVar() {
                return {
                    gatewayCurrencyCode: gatewayCurrency.currency_code ?? "",
                    gatewayCurrencyRate: gatewayCurrency.rate ?? 0,
                    gatewayCurrencyMinLimit: gatewayCurrency.min_limit ?? 0,
                    gatewayCurrencyMaxLimit: gatewayCurrency.max_limit ?? 0,
                    gatewayCurrencyPercentCharge: gatewayCurrency.percent_charge ?? 0,
                    gatewayCurrencyFixedCharge: gatewayCurrency.fixed_charge ?? 0,
                };
            }

            function getExchangeRate() {
                let gatewayCurrencyCode = acceptVar().gatewayCurrencyCode;
                let gatewayCurrencyRate = acceptVar().gatewayCurrencyRate;

                let rate = parseFloat(gatewayCurrencyRate);
                $('.rate-show').html("1 USD" + " = " + parseFloat(rate).toFixed(gatewayPrecision) + " " +
                    gatewayCurrencyCode);
                return rate;

            }
            getExchangeRate();
            let exchangeRate = getExchangeRate();

            function getLimit() {
                let gatewayCurrencyCode = acceptVar().gatewayCurrencyCode;
                let gatewayCurrencyRate = acceptVar().gatewayCurrencyRate;
                let min_limit = acceptVar().gatewayCurrencyMinLimit;
                let max_limit = acceptVar().gatewayCurrencyMaxLimit
                if ($.isNumeric(min_limit) && $.isNumeric(max_limit)) {
                    let min_limit_calc = parseFloat(min_limit) / parseFloat(exchangeRate);
                    let max_limit_clac = parseFloat(max_limit) / parseFloat(exchangeRate);

                    $('.limit-show').html("<?php echo e(__('Limit')); ?> " + parseFloat(min_limit_calc) + " " + "USD" + " - " +
                        parseFloat(max_limit_clac) + " " + "USD");
                    return {
                        minLimit: min_limit_calc,
                        maxLimit: max_limit_clac,
                    };
                } else {
                    $('.limit-show').html("--");
                    return {
                        minLimit: 0,
                        maxLimit: 0,
                    };
                }
            }
            getLimit();

            function feesCalculation() {
                let gatewayCurrencyCode = acceptVar().gatewayCurrencyCode;
                let gatewayCurrencyRate = acceptVar().gatewayCurrencyRate;
                let amount = $("input[name=amount]").val();
                amount = $.isNumeric(amount) ? parseFloat(amount) : 0;
                let fixed_charge = acceptVar().gatewayCurrencyFixedCharge;
                let percent_charge = acceptVar().gatewayCurrencyPercentCharge;
                if ($.isNumeric(percent_charge) && $.isNumeric(fixed_charge) && $.isNumeric(amount)) {
                    // Process Calculation
                    let fixed_charge_calc = parseFloat(fixed_charge) * parseFloat(1 / exchangeRate);
                    let percent_charge_calc = (parseFloat(amount) * parseFloat(percent_charge) / 100);
                    let total_charge = parseFloat(fixed_charge_calc) + parseFloat(percent_charge_calc);
                    total_charge = parseFloat(total_charge).toFixed(2);
                    // return total_charge;
                    return {
                        total: total_charge,
                        fixed: fixed_charge_calc,
                        percent: percent_charge_calc,
                    };
                } else {
                    // return "--";
                    return false;
                }
            }

            function getFees() {
                let gatewayCurrencyCode = acceptVar().gatewayCurrencyCode;
                let percent = acceptVar().gatewayCurrencyPercentCharge;
                let charges = feesCalculation();
                if (charges == false) {
                    return false;
                }
                $('.charge-show').html("<?php echo e(__('Charge:')); ?> " + parseFloat(charges.fixed).toFixed(2) + " " + "USD" +
                    " + " + parseFloat(percent).toFixed(2) + "%");
            }
            getFees();

            function getPreview() {
                let amount = $("input[name=amount]").val();
                let gatewayCurrencyCode = acceptVar().gatewayCurrencyCode;
                amount == "" ? amount = 0 : amount = amount;

                // Sending Amount
                $('.enter-amount').text(parseFloat(amount).toFixed(2) + " " + "USD");

                // Fees
                let charges = feesCalculation();
                $('.fees').text(charges.total + " " + "USD");

                // will get amount
                let willGet = parseFloat(amount) * exchangeRate;
                $('.will-get').text(willGet.toFixed(gatewayPrecision) + " " + gatewayCurrencyCode);

                // Pay In Total
                let pay_in_total = parseFloat(charges.total) + parseFloat(amount);
                $('.payable').text(parseFloat(pay_in_total).toFixed(2) + " " + "USD");
            }
            getPreview();

            function getUserBalance() {

                let CSRF = $("meta[name=csrf-token]").attr("content");
                let data = {
                    _token: CSRF,
                    target: 'USD',
                };
                // Make AJAX request for getting user balance
                $.post(userBalanceRoute, data, function() {
                    // success
                }).done(function(response) {
                    let balance = response.data;
                    balance = parseFloat(balance).toFixed(2);
                    $(".balance-show").html("<?php echo e(__('Available Balance')); ?> " + balance + " " + 'USD');
                }).fail(function(response) {
                    var response = JSON.parse(response.responseText);
                    throwMessage(response.type, response.message.error);
                });
            }
            getUserBalance();
        }

        document.addEventListener("DOMContentLoaded", function() {
            const quantityInput = document.getElementById('amount-input');
            quantityInput.addEventListener('input', function(event) {
                let inputValue = event.target.value.trim();
                if (inputValue === '' || inputValue <= '0') {
                    inputValue = '';
                }
                event.target.value = inputValue;
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/money-out/index.blade.php ENDPATH**/ ?>