<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('manager.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('My Salon'),
                'url' => setRoute('manager.dashboard'),
            ],
        ],
        'active' => __('Details'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="salon-details-page">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="appointment-area">
                    <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i> <?php echo e(__('Salon Details')); ?></h3>
                    <div class="salon-thumb">
                        <img src="<?php echo e(get_image($data->image ?? '', 'site-section')); ?>" alt="img">
                    </div>
                    <div class="about-details mt-20">
                        <!-- Parlour Information -->
                        <div class="salon-title">
                            <h3 class="title"><i class="fas fa-user-alt"></i> <?php echo e(__('Salon Information')); ?></h3>
                        </div>
                        <div class="list-wrapper">
                            <div class="preview-area">
                                <div class="preview-item">
                                    <p><?php echo e(__('Salon Name')); ?>:</p>
                                </div>
                                <div class="preview-details">
                                    <p><?php echo e($data->name); ?></p>
                                </div>
                            </div>
                            <div class="preview-area">
                                <div class="preview-item">
                                <p><?php echo e(__("Manager Name")); ?> :</p>
                                </div>
                                <div class="preview-details">
                                    <p><?php echo e($data->manager->firstname . ' '. $data->manager->lastname ?? ''); ?></p>
                                </div>
                            </div>
                            <div class="preview-area">
                                <div class="preview-item">
                                    <p><?php echo e(__('Salon Address')); ?>:</p>
                                </div>
                                <div class="preview-details">
                                    <p><?php echo e($data->address); ?></p>
                                </div>
                            </div>
                            <div class="preview-area">
                                <div class="preview-item">
                                    <p><?php echo e(__('Experience')); ?>:</p>
                                </div>
                                <div class="preview-details">
                                    <p><?php echo e($data->experience); ?></p>
                                </div>
                            </div>
                        </div>

                        <!-- Schedules -->
                        <div class="parlour-seduel-stuff mt-30">
                            <div class="row mb-40-none">
                                <div class="col-lg-6 col-md-6 col-sm-6 mb-40">
                                    <div class="shedule-item">
                                        <h3 class="title"><i class="fas fa-history"> </i> <?php echo e(__('Schedules')); ?></h3>
                                        <div class="shedule-inner">
                                            <?php $__currentLoopData = $data->schedules; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                            <label  class="package--amount ">

                                                <strong class="${textClass}"><?php echo e($item->from_time ?? ''); ?> - </strong>
                                                <strong class="${textClass}"><?php echo e($item->to_time ?? ''); ?></strong>
                                            </label>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </div>
                                    </div>
                                </div>
                                <!-- Staff Section -->
                                <div class="col-lg-6 col-md-6 col-sm-6 mb-40">
                                    <div class="staf-section">
                                        <div class="stuff-title">
                                            <h3 class="title"><i class="fas fa-user-edit"></i> <?php echo e(__('Staff')); ?></h3>
                                        </div>
                                        <ul class="stuff-area mb-20-none">
                                            <?php if($data->stuff->count() > 0): ?>
                                                <?php $__currentLoopData = $data->stuff; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $staff): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <li class="stuff-details mb-20">
                                                        <div class="stuf-name">
                                                            <h5><?php echo e($staff->stuff_name); ?></h5>
                                                        </div>
                                                    </li>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            <?php else: ?>
                                                <li><?php echo e(__('No staff available.')); ?></li>
                                            <?php endif; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Services -->
                        <div class="service-provied mt-30">
                            <div class="shedule-title pt-4">
                                <h3 class="title"> <i class="fas fa-cut"></i> <?php echo e(__('Services')); ?></h3>
                            </div>
                            <div class="parlour-service-item">
                                <div class="row">
                                    <?php if($data->services->count() > 0): ?>
                                        <?php $__currentLoopData = $data->services->chunk(ceil($data->services->count() / 2)); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $services): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-6">
                                                <div class="item-price">
                                                    <div class="left-side">
                                                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $service): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <p class="item-name"><?php echo e($key+1); ?>  .  <?php echo e($service->service_name); ?> :
                                                                <span><?php echo e(get_amount($service->price)); ?></span>
                                                            </p>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </div>
                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <p><?php echo e(__('No services available.')); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php $__env->startPush('script'); ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('manager.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/manager/section/my-parlour/details.blade.php ENDPATH**/ ?>