<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Salon'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Salon Add'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
    <div class="custom-card">
        <div class="card-body">
            <form class="card-form" action="<?php echo e(setRoute('vendors.parlour.list.store')); ?>" method="POST"
                enctype="multipart/form-data">
                <?php echo csrf_field(); ?>
                <input type="text" name="vendor_id" value="<?php echo e($vendor_id); ?>" hidden>
                <div class="row justify-content-center">
                    <div class="col-xl-4 col-lg-4 form-group mb-5">
                        <?php echo $__env->make('admin.components.form.input-file', [
                            'label' => __('Image'),
                            'name' => 'image[]',
                            'class' => 'file-holder',
                            'old_files' => old('image'),
                            'attribute' => 'data-height=130',
                            'multiple' => true,  
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
                <div class="row justify-content-center mb-10-none">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__('Select Area')); ?>*</label>
                        <select class="form--control select2-basic" name="area">
                            <option disabled><?php echo e(__('Select Area')); ?></option>
                            <?php $__currentLoopData = $areas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>" <?php echo e(old('area') == $item->id ? 'selected' : ''); ?>>
                                    <?php echo e($item->name); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>

                    </div>

                    <div class="col-xl-6 col-lg-6 form-group">
                        <label><?php echo e(__('Select Manager')); ?>*</label>
                        <select class="form--control select2-basic" name="manager">
                            <option disabled selected><?php echo e(__('Select Manager')); ?></option>
                            <?php $__currentLoopData = $manager; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($item->id); ?>"><?php echo e($item->fullname); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Name') . '*',
                            'name' => 'name',
                            'placeholder' => __('Write Name') . '...',
                            'value' => old('name'),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Experience') . '*',
                            'name' => 'experience',
                            'placeholder' => __('Write Experience') . '...',
                            'value' => old('experience'),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Speciality'),
                            'name' => 'speciality',
                            'placeholder' => __('Write Speciality') . '...',
                            'value' => old('speciality'),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Contact') . '*',
                            'name' => 'contact',
                            'placeholder' => __('Write Contact') . '...',
                            'value' => old('contact'),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Address'),
                            'name' => 'address',
                            'placeholder' => __('Write Address') . '...',
                            'value' => old('address'),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Number Of Service Dates') . '*',
                            'name' => 'number_of_dates',
                            'placeholder' => __('Number Of Service Dates') . '...',
                            'value' => old('number_of_dates'),
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        <?php echo $__env->make('admin.components.form.input', [
                            'label' => __('Todays Date') . '*',
                            'attribute' => 'readonly',
                            'value' => $todayDate,
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <h3 class="title"><?php echo e(__('Off Days')); ?></h6>
                        <div class="card-inner-body">
                            <div class="stuff-result">
                                <div class="row">
                                    <?php $__currentLoopData = getWeekDays(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $day): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                            <div class="box-checkbox" style="flex: 0;">
                                                <input type="checkbox" class="form-check-input" name="off_days[]"
                                                value="<?php echo e($day['value']); ?>" id="day-<?php echo e($loop->index); ?>"
                                                <?php echo e(collect(old('off_days', []))->contains($day['value']) ? 'checked' : ''); ?>>

                                            </div>
                                            <div class="box-name mt-1">
                                                <label class="form-check-label ms-1" for="day-<?php echo e($loop->index); ?>">
                                                    <?php echo e($day['day_name']); ?>

                                                </label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group ptb-20">
                        <div class="custom-inner-card">
                            <div class="card-inner-header pb-10 d-flex justify-content-between">
                                <h3 class="title"><?php echo e(__('Service')); ?></h6>
                                    <button type="button" class="btn--base add-service-btn"><i class="fas fa-plus"></i>
                                        <?php echo e(__('Add')); ?></button>
                            </div>
                            <div class="card-inner-body">
                                <div class="result">
                                    <?php echo $__env->make('admin.components.parlour-list.service-item', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header">
                                <h3 class="title"><?php echo e(__('Staff')); ?> (<?php echo e(__("Min")); ?> : <?php echo e($basic_settings->min_stuff); ?>)</h6>
                            </div>
                            <div class="card-inner-body">
                                <div class="stuff-result">
                                    <div class="row">
                                        <?php $__currentLoopData = $parlour_has_stuff ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                                <div class="box-checkbox" style="flex: 0;">
                                                    <input type="checkbox" name="stuff_name[]" class="form-check-input"
                                                    id="stuff-name-list-<?php echo e($item->id); ?>" value="<?php echo e($item->id); ?>"
                                                    <?php echo e(collect(old('stuff_name', []))->contains($item->id) ? 'checked' : ''); ?>>

                                                </div>
                                                <div class="box-name">
                                                    <?php echo e($item->stuff_name); ?>

                                                </div>
                                            </div>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header pb-10 d-flex justify-content-between">
                                <h3 class="title"><?php echo e(__('Schedule')); ?></h6>
                                    <button type="button" class="btn--base add-schedule-btn"><i class="fas fa-plus"></i>
                                        <?php echo e(__('Add')); ?></button>
                            </div>
                            <div class="card-inner-body">
                                <div class="results">
                                    <?php echo $__env->make('admin.components.parlour-list.schedule-item', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <?php echo $__env->make('admin.components.button.form-btn', [
                            'class' => 'w-100 btn-loading',
                            'text' => 'Submit',
                        ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('script'); ?>
    <script>
        $(document).ready(function() {

            var getDayURL = "<?php echo e(setRoute('vendors.parlour.list.get.days')); ?>";
            $('.add-schedule-btn').click(function() {
                $.get(getDayURL, function(data) {
                    $('.results').prepend(data);
                    $('.results').find('.row').first().find("select").select2();
                });
            });
            var getServiceURL = "<?php echo e(setRoute('vendors.parlour.list.get.service')); ?>";
            $('.add-service-btn').click(function() {

                $.get(getServiceURL, function(data) {
                    $('.result').prepend(data);
                    $('.result').find('.row').first().find("select").select2();
                });
            });

            var getStuffURL = "<?php echo e(setRoute('vendors.parlour.list.get.stuff')); ?>";
            $('.add-stuff-btn').click(function() {

                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/vendor/sections/parlour-list/create.blade.php ENDPATH**/ ?>