<?php
    $menues = DB::table('setup_pages')->where('status', 1)->get();
    $language = App\Models\Admin\Language::where('status', 1)->first();
?>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    Start Header
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
<header class="header-section position-relative">
    <div class="header">
        <div class="header-bottom-area">
            <div class="container custom-container">
                <div class="header-menu-content">
                    <nav class="navbar navbar-expand-xxl p-0">
                        <a class="site-logo site-title" href="<?php echo e(setroute('frontend.index')); ?>"><img
                                src="<?php echo e(get_logo($basic_settings)); ?>" alt="site-logo"></a>
                        <button class="navbar-toggler ms-auto" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                            aria-expanded="false" aria-label="Toggle navigation">
                            <span class="fas fa-bars"></span>
                        </button>
                        <?php
                            $current_url = URL::current();
                        ?>
                        <div class="collapse navbar-collapse" id="navbarSupportedContent">
                            <ul class="navbar-nav main-menu ms-auto">
                                <?php $__currentLoopData = $menues; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <?php
                                        $title = $item->title ?? '';
                                    ?>
                                    <li><a href="<?php echo e(url($item->url)); ?>"
                                            class=" <?php if($current_url == url($item->url)): ?> active <?php endif; ?> "><?php echo e(__($title)); ?>

                                        </a></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                            <div class="language-select">
                                <?php
                                    $session_lan = session('local') ?? get_default_language_code();

                                ?>
                                <select class="form--control langSel nice-select" name="lang_switcher">
                                    <?php $__currentLoopData = $__languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($item->code); ?>"
                                            <?php if($session_lan == $item->code): ?> selected <?php endif; ?>><?php echo e(__($item->name)); ?>

                                        </option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
                            <div class="header-action">
                                <?php if(Auth::guard('vendor')->check()): ?>
                                    <a class="btn--base"
                                        href="<?php echo e(setRoute('vendors.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                                <?php elseif(Auth::guard('web')->check()): ?>
                                    <a class="btn--base"
                                        href="<?php echo e(setRoute('user.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                                <?php elseif(Auth::guard('manager')->check()): ?>
                                    <a class="btn--base"
                                        href="<?php echo e(setRoute('manager.dashboard')); ?>"><?php echo e(__('Dashboard')); ?></a>
                                <?php else: ?>
                                    <a href="<?php echo e(setRoute('user.login')); ?>" class="btn--base"><?php echo e(__('Login Now')); ?></a>
                                <?php endif; ?>
                            </div>
                        </div>
                    </nav>
                </div>
            </div>
        </div>
    </div>
</header>


<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
    End Header
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->

<?php $__env->startPush('script'); ?>
<script>
    $("select[name=lang_switcher]").change(function(){
        var selected_value = $(this).val();
        var submitForm = `<form action="<?php echo e(setRoute('frontend.languages.switch')); ?>" id="local_submit" method="POST"> <?php echo csrf_field(); ?> <input type="hidden" name="target" value="${$(this).val()}" ></form>`;
        $("body").append(submitForm);
        $("#local_submit").submit();
    });

</script>
<?php $__env->stopPush(); ?>

<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub-web-v2.0.0\resources\views/frontend/partials/header.blade.php ENDPATH**/ ?>