<div class="sidebar">
    <div class="sidebar-inner">
        <div class="sidebar-menu-wrapper">
            <div class="sidebar-logo">
                <a href="<?php echo e(setRoute('frontend.index')); ?>" class="sidebar-main-logo">
                    <img src="<?php echo e(get_logo_vendor($basic_settings)); ?>"
                        data-white_img="<?php echo e(get_logo_vendor($basic_settings, 'dark')); ?>"
                        data-dark_img="<?php echo e(get_logo_vendor($basic_settings)); ?>" alt="logo">
                </a>
                <button class="sidebar-menu-bar">
                    <i class="fas fa-exchange-alt"></i>
                </button>
            </div>
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.dashboard')); ?>">
                        <i class="menu-icon las la-palette"></i>
                        <span class="menu-title"><?php echo e(__('Dashboard')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.withdraw.money.index')); ?>">
                        <i class="menu-icon las la-money-bill-wave"></i>
                        <span class="menu-title"><?php echo e(__('Withdraw Money')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.admin.charges.index')); ?>">
                        <i class="menu-icon las la-receipt"></i>
                        <span class="menu-title"><?php echo e(__('Pay Charges')); ?></span>
                    </a>
                </li>
                <?php
                    use App\Models\ParlourBooking;

                    $parlour = ParlourBooking::auth()->orderByDesc('id')->get();
                    $count = $parlour->count();
                ?>

                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.booking.request.index')); ?>">
                        <i class="menu-icon las la-calendar-check"></i>
                        <span class="menu-title"><?php echo e(__('Booking Request')); ?></span>
                        <div class="sidebar-item-badge">
                            <span class="badge"><?php echo e($count); ?></span>
                        </div>
                    </a>
                </li>

                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.manager.index')); ?>">
                        <i class="menu-icon las la-user-tie"></i>
                        <span class="menu-title"><?php echo e(__('Manager Section')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.stuff.index')); ?>">
                        <i class="menu-icon las la-users-cog"></i>
                        <span class="menu-title"><?php echo e(__('Manage Staff')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.service.section.index')); ?>">
                        <i class="menu-icon las la-cut"></i>
                        <span class="menu-title"><?php echo e(__('Service Section')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.parlour.list.index')); ?>">
                        <i class="menu-icon las la-cut"></i>
                        <span class="menu-title"><?php echo e(__('My Salon')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(route('vendors.authorize.kyc')); ?>">
                        <i class="fas fa-user-shield menu-icon"></i>
                        <span class="menu-title"><?php echo e(__('KYC Verification')); ?></span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="<?php echo e(setRoute('vendors.security.google.2fa')); ?>">
                        <i class="menu-icon las la-lock-open"></i>
                        <span class="menu-title"><?php echo e(__('2FA')); ?></span>
                    </a>
                </li>

                <li class="sidebar-menu-item">
                    <a href="javascript:void(0)" class="logout-btn-vendor">
                        <i class="menu-icon las la-sign-out-alt"></i>
                        <span class="menu-title"><?php echo e(__('Logout')); ?></span>
                    </a>
                </li>
            </ul>
        </div>
        <div class="sidebar-doc-box bg_img"
            data-background="<?php echo e(asset('public/frontend/images/element/sidebar.webp')); ?>">
            <div class="sidebar-doc-icon">
                <i class="las la-headphones-alt"></i>
            </div>
            <div class="sidebar-doc-content">
                <h4 class="title"><?php echo e(__('Need Help')); ?>?</h4>
                <p><?php echo e(__('Please check our docs')); ?></p>
                <div class="sidebar-doc-btn">
                    <a href="<?php echo e(route('vendors.support.ticket.index')); ?>"
                        class="btn--base w-100"><?php echo e(__('Get Support')); ?></a>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->startPush('script'); ?>
    <script>
        $(".logout-btn-vendor").click(function() {
            var actionRoute = "<?php echo e(setRoute('vendors.logout')); ?>";
            var target = 1;
            var message = `<?php echo e(__('Are you sure to')); ?> <strong><?php echo e(__('Logout')); ?></strong>?`;

            openAlertModal(actionRoute, target, message, "<?php echo e(__('Logout')); ?>", "POST");
            /**
             * Function for open delete modal with method DELETE
             * @param {string} URL
             * @param {string} target
             * @param {string} message
             * @returns
             */
            function openAlertModal(URL, target, message, actionBtnText = "<?php echo e(__('Remove')); ?>", method =
                "DELETE") {
                if (URL == "" || target == "") {
                    return false;
                }

                if (message == "") {
                    message = "Are you sure to delete ?";
                }
                var method = `<input type="hidden" name="_method" value="${method}">`;
                openModalByContent({
                        content: `<div class="card modal-alert border-0">
              <div class="card-body">
                  <form method="POST" action="${URL}">
                      <input type="hidden" name="_token" value="${laravelCsrf()}">
                      ${method}
                      <div class="head mb-3">
                          ${message}
                          <input type="hidden" name="target" value="${target}">
                      </div>
                      <div class="foot d-flex align-items-center justify-content-between">
                          <button type="button" class="modal-close btn--base btn-for-modal"><?php echo e(__('Close')); ?></button>
                          <button type="submit" class="alert-submit-btn btn--danger btn-loading btn-for-modal">${actionBtnText}</button>
                      </div>
                  </form>
              </div>
          </div>`,
                    },

                );
            }
        });
    </script>
<?php $__env->stopPush(); ?>
<?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_project\salonhub\resources\views/vendor/partials/side-nav.blade.php ENDPATH**/ ?>