<?php if(isset($support_tickets)): ?>
    <div class="dashboard-area">
        <div class="dashboard-item-area">
            <div class="row">
                <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Pending Tickets")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e($pending_ticket = $support_tickets->where("status",support_ticket_const()::PENDING)->count()); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <a href="<?php echo e(setRoute('admin.support.ticket.pending')); ?>" class="view-btn bg--warning"><?php echo e(__("View All")); ?></a>
                                </div>
                            </div>
                            <div class="right">
                                <?php
                                    $percent_count = get_percentage_from_two_number($support_tickets->count(),$pending_ticket);
                                ?>
                                <div class="chart" id="chart6" data-percent="<?php echo e($percent_count); ?>"><span><?php echo e($percent_count); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Active Tickets")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e($active_ticket = $support_tickets->where("status",support_ticket_const()::ACTIVE)->count()); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <a href="<?php echo e(setRoute('admin.support.ticket.active')); ?>" class="view-btn bg--info"><?php echo e(__("View All")); ?></a>
                                </div>
                            </div>
                            <div class="right">
                                <?php
                                    $percent_count = get_percentage_from_two_number($support_tickets->count(),$active_ticket);
                                ?>
                                <div class="chart" id="chart7" data-percent="<?php echo e($percent_count); ?>"><span><?php echo e($percent_count); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("Solved Tickets")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e($solved_ticket = $support_tickets->where("status",support_ticket_const()::SOLVED)->count()); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <a href="<?php echo e(setRoute('admin.support.ticket.solved')); ?>" class="view-btn bg--success"><?php echo e(__("View All")); ?></a>
                                </div>
                            </div>
                            <div class="right">
                                <?php
                                    $percent_count = get_percentage_from_two_number($support_tickets->count(),$solved_ticket);
                                ?>
                                <div class="chart" id="chart8" data-percent="<?php echo e($percent_count); ?>"><span><?php echo e($percent_count); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xxl-3 col-xl-3 col-lg-6 col-md-6 col-sm-12 mb-15">
                    <div class="dashbord-item">
                        <div class="dashboard-content">
                            <div class="left">
                                <h6 class="title"><?php echo e(__("All Tickets")); ?></h6>
                                <div class="user-info">
                                    <h2 class="user-count"><?php echo e($all_ticket = $support_tickets->count()); ?></h2>
                                </div>
                                <div class="user-badge">
                                    <a href="<?php echo e(setRoute('admin.support.ticket.index')); ?>" class="view-btn bg--base"><?php echo e(__("View All")); ?></a>
                                </div>
                            </div>
                            <div class="right">
                                <?php
                                    $percent_count = get_percentage_from_two_number($support_tickets->count(),$all_ticket);
                                ?>
                                <div class="chart" id="chart9" data-percent="<?php echo e($percent_count); ?>"><span><?php echo e($percent_count); ?>%</span></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/admin/components/support-ticket/counter-card.blade.php ENDPATH**/ ?>