<?php
    $vendor_id = auth()->user()->id;
    $kyc_data = \App\Models\Vendor\VendorKycData::where('vendor_id', $vendor_id)->first();
?>


<?php $__env->startSection('breadcrumb'); ?>
    <?php echo $__env->make('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('KYC  Verification'),
    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>


<?php $__env->startSection('content'); ?>
    <div class="row mb-20-none">
        <div class="col-xl-12 col-lg-12 mb-20">
            <div class="custom-card mt-10">
                <div class="dashboard-header-wrapper">
                    <h4 class="title"><?php echo e(__('KYC Verification')); ?></h4>
                </div>


                <?php if(auth()->user()->kyc_verified == global_const()::APPROVED): ?>
                    <div class="row justify-content-center mb-20-none">
                        <div class="col-xl-8 col-lg-10 mb-20">
                            <div class="kyc-preview mt-10">
                                <div class="kyc-title">
                                    <i class="las la-exclamation-circle"></i>
                                    <h3 class="title"><?php echo e(_('KYC-Status')); ?></h3>
                                </div>
                                <div class="kyc-preview-area">
                                    <p>Status:
                                        <span><?php echo e(__('Verified')); ?></span>
                                    </p>

                                    <div class="card-body">
                                        <?php if($users->kyc != null && $users->kyc->data != null): ?>
                                            <?php
                                                $kycData = $users->kyc->data;
                                            ?>
                                            <?php $__currentLoopData = $kycData ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php if($item->type == 'file'): ?>
                                                    <?php
                                                        $file_link = get_file_link('kyc-files', $item->value);
                                                    ?>
                                                    <div class="submit-img">
                                                        <div class="row mb-20-none">
                                                            <?php if($file_link == false): ?>
                                                                <span><?php echo e(__('File not found!')); ?></span>
                                                                <?php continue; ?>
                                                            <?php endif; ?>

                                                            <?php if(its_image($item->value)): ?>

                                                            <div class="col-lg-6 col-md-6 col-sm-12 mb-40">
                                                                <label><?php echo e($item->label); ?></label>
                                                                <div class="kyc-img">
                                                                    <img src="<?php echo e($file_link); ?>"
                                                                    alt="<?php echo e($item->label); ?>">
                                                                </div>
                                                            </div>
                                                            <?php else: ?>
                                                                <span class="text--danger">
                                                                    <?php
                                                                        $file_info = get_file_basename_ext_from_link(
                                                                            $file_link,
                                                                        );
                                                                    ?>
                                                                    <a
                                                                        href="<?php echo e(setRoute('file.download', ['kyc-files', $item->value])); ?>">
                                                                        <?php echo e(Str::substr($file_info->base_name ?? '', 0, 20) . '...' . ($file_info->extension ?? '')); ?>

                                                                    </a>
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="submit-img" >
                                                        <span class="kyc-title"><?php echo e($item->label); ?>:</span>
                                                        <span><?php echo e($item->value); ?></span>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php elseif(auth()->user()->kyc_verified == global_const()::PENDING): ?>
                    <div class="row justify-content-center mb-20-none">
                        <div class="col-xl-8 col-lg-10 mb-20">
                            <div class="kyc-preview mt-10">
                                <div class="kyc-title">
                                    <i class="las la-exclamation-circle"></i>
                                    <h3 class="title"><?php echo e(_('KYC-Status')); ?></h3>
                                </div>
                                <div class="kyc-preview-area">
                                    <p><?php echo e(__('Status')); ?>:
                                        <span><?php echo e(__('Pending')); ?></span>
                                    </p>
                                    <div class="card-body">
                                        <?php if($users->kyc != null && $users->kyc->data != null): ?>
                                            <?php
                                                $kycData = $users->kyc->data;
                                            ?>
                                            <?php $__currentLoopData = $kycData ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php if($item->type == 'file'): ?>
                                                    <?php
                                                        $file_link = get_file_link('kyc-files', $item->value);
                                                    ?>
                                                    <div class="submit-img">
                                                        <div class="row mb-20-none">
                                                            <?php if($file_link == false): ?>
                                                                <span><?php echo e(__('File not found!')); ?></span>
                                                                <?php continue; ?>
                                                            <?php endif; ?>

                                                            <?php if(its_image($item->value)): ?>

                                                            <div class="col-lg-6 col-md-6 col-sm-12 mb-40">
                                                                <label><?php echo e($item->label); ?></label>
                                                                <div class="kyc-img">
                                                                    <img src="<?php echo e($file_link); ?>"
                                                                    alt="<?php echo e($item->label); ?>">
                                                                </div>
                                                            </div>
                                                            <?php else: ?>
                                                                <span class="text--danger">
                                                                    <?php
                                                                        $file_info = get_file_basename_ext_from_link(
                                                                            $file_link,
                                                                        );
                                                                    ?>
                                                                    <a
                                                                        href="<?php echo e(setRoute('file.download', ['kyc-files', $item->value])); ?>">
                                                                        <?php echo e(Str::substr($file_info->base_name ?? '', 0, 20) . '...' . ($file_info->extension ?? '')); ?>

                                                                    </a>
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="submit-img" >
                                                        <span class="kyc-title"><?php echo e($item->label); ?>:</span>
                                                        <span><?php echo e($item->value); ?></span>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                <?php elseif(auth()->user()->kyc_verified == global_const()::REJECTED): ?>
                    <div class="row justify-content-center mb-20-none">
                        <div class="col-xl-8 col-lg-10 mb-20">
                            <div class="kyc-preview mt-10">
                                <div class="kyc-title">
                                    <i class="las la-exclamation-circle"></i>
                                    <h3 class="title"><?php echo e(_('KYC-Status')); ?></h3>
                                </div>
                                <div class="kyc-preview-area">
                                    <p><?php echo e(__('Status')); ?>:
                                        <span class="text-danger"><?php echo e(__('Rejected')); ?></span>
                                    </p>
                                    <p><?php echo e(__('Reject Reason')); ?>:
                                        <span><?php echo e($users->kyc->reject_reason); ?> </span>
                                    </p>
                                    <div class="card-body">
                                        <?php if($users->kyc != null && $users->kyc->data != null): ?>
                                            <?php
                                                $kycData = $users->kyc->data;
                                            ?>
                                            <?php $__currentLoopData = $kycData ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                                                <?php if($item->type == 'file'): ?>
                                                    <?php
                                                        $file_link = get_file_link('kyc-files', $item->value);
                                                    ?>
                                                    <div class="submit-img">
                                                        <div class="row mb-20-none">
                                                            <?php if($file_link == false): ?>
                                                                <span><?php echo e(__('File not found!')); ?></span>
                                                                <?php continue; ?>
                                                            <?php endif; ?>

                                                            <?php if(its_image($item->value)): ?>

                                                            <div class="col-lg-6 col-md-6 col-sm-12 mb-40">
                                                                <label><?php echo e($item->label); ?></label>
                                                                <div class="kyc-img">
                                                                    <img src="<?php echo e($file_link); ?>"
                                                                    alt="<?php echo e($item->label); ?>">
                                                                </div>
                                                            </div>
                                                            <?php else: ?>
                                                                <span class="text--danger">
                                                                    <?php
                                                                        $file_info = get_file_basename_ext_from_link(
                                                                            $file_link,
                                                                        );
                                                                    ?>
                                                                    <a
                                                                        href="<?php echo e(setRoute('file.download', ['kyc-files', $item->value])); ?>">
                                                                        <?php echo e(Str::substr($file_info->base_name ?? '', 0, 20) . '...' . ($file_info->extension ?? '')); ?>

                                                                    </a>
                                                                </span>
                                                            <?php endif; ?>
                                                        </div>
                                                    </div>
                                                <?php else: ?>
                                                    <div class="submit-img" >
                                                        <span class="kyc-title"><?php echo e($item->label); ?>:</span>
                                                        <span><?php echo e($item->value); ?></span>
                                                    </div>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php endif; ?>
                                    </div>

                                </div>

                                <div class="kyc-area">
                                    <div class="card-body">
                                        <form action="<?php echo e(setRoute('vendors.authorize.kyc.submit')); ?>" class="account-form"
                                            method="POST" enctype="multipart/form-data">
                                            <?php echo csrf_field(); ?>
                                            <div class="row">
                                                <?php echo $__env->make('vendor.components.generate-kyc-fields', [
                                                    'fields' => $kyc_fields,
                                                ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                            </div>
                                            <div class="col-xl-12 col-lg-12 pt-5">
                                                <button type="submit" class="btn--base w-100"><?php echo e(__('Resubmit')); ?></button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php else: ?>
                    <div class="kyc-area">
                        <div class="card-body">
                            <form action="<?php echo e(setRoute('vendors.authorize.kyc.submit')); ?>" class="account-form"
                                method="POST" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <?php echo $__env->make('vendor.components.generate-kyc-fields', [
                                        'fields' => $kyc_fields,
                                    ], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                                </div>
                                <div class="col-xl-12 col-lg-12 pt-5">
                                    <button type="submit" class="btn--base w-100"><?php echo e(__('Verify')); ?></button>
                                </div>
                            </form>
                        </div>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('vendor.layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\cc_projects_files\salonhub_v1.2.0\salonhub\resources\views/vendor/sections/verify-kyc.blade.php ENDPATH**/ ?>