<?php

use App\Http\Controllers\Vendor\AdminChargesController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Vendor\DashboardController;
use App\Http\Controllers\Vendor\ProfileController;
use App\Http\Controllers\Vendor\SupportTicketController;
use App\Http\Controllers\Vendor\SecurityController;
use App\Http\Controllers\Vendor\ParlourListController;
use App\Http\Controllers\Vendor\BookingRequestController;
use App\Http\Controllers\Vendor\ManagerController;
use App\Http\Controllers\Vendor\ServiceSectionController;
use App\Http\Controllers\Vendor\StuffController;
use App\Http\Controllers\Vendor\WalletController;
use App\Http\Controllers\Vendor\WithdrawalController;

Route::prefix("vendors")->name("vendors.")->group(function () {
    //dashboard
    Route::controller(DashboardController::class)->group(function () {
        Route::get('dashboard', 'index')->name('dashboard');
        Route::post('logout', 'logout')->name('logout');
        Route::delete('delete/account', 'deleteAccount')->name('delete.account')->middleware('app.mode');
    });
    //profile
    Route::controller(ProfileController::class)->prefix("profile")->name("profile.")->group(function () {
        Route::get('/', 'index')->name('index');
        Route::put('password/update', 'passwordUpdate')->name('password.update')->middleware('app.mode');
        Route::put('update', 'update')->name('update')->middleware('app.mode')->middleware('app.mode');
    });

    //support ticket
    Route::controller(SupportTicketController::class)->prefix("support-ticket")->name("support.ticket.")->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('create', 'create')->name('create');
        Route::post('store', 'store')->name('store');
        Route::get('conversation/{encrypt_id}', 'conversation')->name('conversation');
        Route::post('message/send', 'messageSend')->name('message.send');
    });

    // parlour list section
    Route::controller(ParlourListController::class)->prefix('parlour-list')->name('parlour.list.')->group(function () {
        Route::get('index', 'index')->name('index');
        Route::get('create', 'create')->name('create')->middleware('vendor.kyc.verify');
        Route::get('get/days', 'getScheduleDays')->name('get.days');
        Route::get('get/stuff', 'getStuff')->name('get.stuff');
        Route::get('get/service', 'getService')->name('get.service');
        Route::post('store', 'store')->name('store');
        Route::get('edit/{slug}', 'edit')->name('edit');
        Route::put('update/{slug}', 'update')->name('update');
        Route::put('status/update', 'statusUpdate')->name('status.update');
        Route::delete('delete', 'delete')->name('delete');
        Route::post('/parlour-image-delete',  'deleteImage')->name('image.delete');
    });

    //security
    Route::controller(SecurityController::class)->prefix("security")->name('security.')->group(function () {
        Route::get('google/2fa', 'google2FA')->name('google.2fa');
        Route::post('google/2fa/status/update', 'google2FAStatusUpdate')->name('google.2fa.status.update')->middleware('app.mode');
    });

    //manager request
    Route::controller(ManagerController::class)->prefix("manager")->name('manager.')->group(function () {
        Route::get('manager/add', 'index')->name('index');
        Route::get('create', 'showForm')->name('create');
        Route::post('manager/update', 'update')->name('update');
        Route::post('manager/register', 'register')->name('register.submit');
        Route::delete('manager/delete', 'delete')->name('delete');
    });
    //stuff section
    Route::controller(StuffController::class)->prefix("stuff")->name('stuff.')->group(function () {
        Route::get('/','index')->name('index');
        Route::get('stuff/create','create')->name('create');
        Route::get('get/stuff','getStuff')->name('get.stuff');
        Route::post('store','store')->name('store.submit');
        Route::post('update', 'update')->name('update');
        Route::delete('delete', 'delete')->name('delete');
        Route::get('assign/stuff', 'showAssignForm')->name('assign.stuff');
        Route::post('assign/store','storeAssign')->name('assign.submit');
        Route::get('details/{id}','details')->name('parlour.details');
    });
      //Withdraw Money
      Route::controller(WithdrawalController::class)->prefix('withdraw-money')->name('withdraw.money.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('submit', 'submit')->name('submit');
        Route::get('instruction/{token}', 'instruction')->name('instruction');
        Route::post('instruction/submit/{token}', 'instructionSubmit')->name('instruction.submit');
        Route::get('/logs', 'withdrawLogs')->name('logs');
    });

    Route::controller(WalletController::class)->prefix("wallets")->name("wallets.")->group(function () {
        Route::post("balance", "balance")->name("balance");
    });

    //booking request
    Route::controller(BookingRequestController::class)->prefix('booking-request')->name('booking.request.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('/booking/details/{booking_id}','bookingDetails')->name('details');
    });
    //parlour service section
    Route::controller(ServiceSectionController::class)->prefix('service-section')->name('service.section.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('/service/details/{parlour_id}','serviceDetails')->name('details');
    });
    //admin pay charge by add money section
    Route::controller(AdminChargesController::class)->prefix('admin-charges')->name('admin.charges.')->group(function () {
        Route::get('/', 'index')->name('index');
        Route::get('/booking/details/{booking_id}','BookingDetails')->name('details');

        Route::post('submit','submit')->name('submit');

        Route::get('success/response/{gateway}','success')->name('payment.success');
        Route::get("cancel/response/{gateway}",'cancel')->name('payment.cancel');

        Route::post("callback/response/{gateway}",'callback')->name('payment.callback')->withoutMiddleware(['web', 'auth:vendor', 'vendor.verification.guard', 'vendor.google.two.factor']);

        // POST Route For Unauthenticated Request
        Route::post('success/response/{gateway}', 'postSuccess')->name('payment.success')->withoutMiddleware(['auth:vendor', 'vendor.verification.guard', 'vendor.google.two.factor']);
        Route::post('cancel/response/{gateway}', 'postCancel')->name('payment.cancel')->withoutMiddleware(['auth:vendor', 'vendor.verification.guard', 'vendor.google.two.factor']);

        // redirect with HTML form route
        Route::get('redirect/form/{gateway}', 'redirectUsingHTMLForm')->name('payment.redirect.form');

        //redirect with Btn Pay
        Route::get('redirect/btn/checkout/{gateway}', 'redirectBtnPay')->name('payment.btn.pay');

        Route::get('manual/{token}','showManualForm')->name('manual.form');
        Route::post('manual/submit/{token}','manualSubmit')->name('manual.submit');

        Route::get('paystack/pay/callback','paystackPayCallBack')->name('paystack.pay.callback');

        Route::prefix('payment')->name('payment.')->group(function() {
            Route::get('crypto/address/{trx_id}','cryptoPaymentAddress')->name('crypto.address');
            Route::post('crypto/confirm/{trx_id}','cryptoPaymentConfirm')->name('crypto.confirm');
        });
    });
});
