<?php

use App\Http\Controllers\Api\V1\Vendor\AddMoneyController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\Vendor\Auth\AuthController;
use App\Http\Controllers\Api\V1\Vendor\Auth\AuthorizationController;
use App\Http\Controllers\Api\V1\Vendor\Auth\ForgotPasswordController;
use App\Http\Controllers\Api\V1\Vendor\BookingRequestController;
use App\Http\Controllers\Api\V1\Vendor\ParlourAddController;
use App\Http\Controllers\Api\V1\Vendor\ProfileController;
use App\Http\Controllers\Api\V1\Vendor\DashboardController;
use App\Http\Controllers\Api\V1\Vendor\ManagerController;
use App\Http\Controllers\Api\V1\Vendor\StuffController;
use App\Http\Controllers\Api\V1\Vendor\WithdrawController;

Route::name('api.v1.')->group(function () {

    // User
    Route::group(['prefix' => 'vendors', 'as' => 'vendors.'], function () {
        Route::post('login', [AuthController::class, 'login']);
        Route::post('register', [AuthController::class, 'register'])->middleware('register.check');

        Route::group(['prefix' => 'forgot/password'], function () {
            Route::post('send/otp', [ForgotPasswordController::class, 'sendCode']);
            Route::post('verify',  [ForgotPasswordController::class, 'verifyCode']);
            Route::post('resend/code',  [ForgotPasswordController::class, 'resendCode']);
            Route::post('reset', [ForgotPasswordController::class, 'resetPassword']);
        });

        Route::middleware('vendor.api')->group(function () {
            Route::get('logout', [AuthorizationController::class, 'logout']);
            Route::get('kyc', [AuthorizationController::class, 'getKycInputFields']);
            Route::post('kyc/submit', [AuthorizationController::class, 'kycSubmit']);
            Route::post('email/otp/verify', [AuthorizationController::class, 'verifyEmailCode']);
            Route::post('email/resend/code', [AuthorizationController::class, 'emailResendCode']);
            Route::post('google-2fa/otp/verify', [AuthorizationController::class, 'verify2FACode']);
            Route::get('google-2fa/otp/status', [AuthorizationController::class, 'get2FaStatus']);
            Route::post('google-2fa/status/update', [AuthorizationController::class, 'google2FAStatusUpdate'])->middleware('app.mode');
            Route::get('dashboard', [DashboardController::class, 'dashboard']);
            Route::get('notification', [DashboardController::class, 'notification']);


            // Vendor Profile
            Route::controller(ProfileController::class)->prefix('profile')->group(function () {
                Route::get('/', 'profile');
                Route::post('update', 'profileUpdate')->middleware('app.mode');
                Route::post('delete', 'deleteAccount')->middleware('app.mode');
                Route::post('password/update', 'passwordUpdate')->middleware('app.mode');

                Route::controller(AuthorizationController::class)->prefix('kyc')->group(function () {
                    Route::get('input-fields', 'getKycInputFields');
                    Route::post('submit', 'KycSubmit');
                });
            });

            // vendor parlour
            Route::controller(ParlourAddController::class)->prefix('parlour')->group(function () {
                Route::get('/', 'index');
                Route::get('area', 'area');
                Route::post('add', 'store');
                Route::post('update/{slug}', 'update')->middleware('app.mode');
                Route::post('delete/parlour', 'delete')->middleware('app.mode');
                Route::post('status/update', 'statusUpdate');
            });

            // vendor manager
            Route::controller(ManagerController::class)->prefix('manager')->group(function () {
                Route::get('/', 'index')->name('manager.list');
                Route::post('store', 'store');
                Route::post('update/{id}', 'update')->middleware('app.mode');
                Route::post('delete/{slug}', 'delete')->middleware('app.mode');
            });

            // booking request
            Route::controller(BookingRequestController::class)->prefix('booking-request')->group(function () {
                Route::get('/', 'index')->name('index');
            });

            // vendor stuff
            Route::controller(StuffController::class)->prefix('stuff')->group(function () {
                Route::get('/', 'index')->name('stuff.list');
                Route::post('store', 'store');
                Route::post('update/{id}', 'update')->middleware('app.mode');
                Route::post('delete/{slug}', 'delete')->middleware('app.mode');
                Route::post('assign', 'stuffAssign')->middleware('app.mode');
            });

            //Withdraw Money Routes
            Route::controller(WithdrawController::class)->prefix("withdraw")->name('withdraw.')->group(function () {
                Route::get("wallet-gateways", "walletGateways");
                Route::get("gateway/input-fields", "gatewayInputFields");
                Route::post("submit", "submit");
            });

            // // Add Money Routes
            Route::controller(AddMoneyController::class)->prefix("add-money")->name('add.money.')->group(function () {
                Route::get("payment-gateways", "getPaymentGateways");

                // Submit with automatic gateway
                Route::post("automatic/submit", "automaticSubmit");

                // Automatic Gateway Response Routes
                Route::get('success/response/{gateway}', 'success')->withoutMiddleware(['vendor.api', 'auth:api'])->name("payment.success");
                Route::get("cancel/response/{gateway}", 'cancel')->withoutMiddleware(['vendor.api', 'auth:api'])->name("payment.cancel");

                // POST Route For Unauthenticated Request
                Route::post('success/response/{gateway}', 'postSuccess')->name('payment.success')->withoutMiddleware(['vendor.api', 'auth:api']);
                Route::post('cancel/response/{gateway}', 'postCancel')->name('payment.cancel')->withoutMiddleware(['vendor.api', 'auth:api']);

                //redirect with Btn Pay
                Route::get('redirect/btn/checkout/{gateway}', 'redirectBtnPay')->name('payment.btn.pay')->withoutMiddleware(['vendor.api', 'auth:api']);

                Route::get('manual/input-fields', 'manualInputFields');

                // Submit with manual gateway
                Route::post("manual/submit", "manualSubmit");

                // Automatic gateway additional fields
                Route::get('payment-gateway/additional-fields', 'gatewayAdditionalFields');

                Route::prefix('payment')->name('payment.')->group(function () {
                    Route::post('crypto/confirm/{trx_id}', 'cryptoPaymentConfirm')->name('crypto.confirm');
                });
            });
        });
    });
});
