<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\User\ProfileController;
use App\Http\Controllers\Api\V1\User\ParlourBookingController;
use App\Http\Controllers\Api\V1\User\DashboardController;
use App\Http\Controllers\Api\V1\User\FavoriteSalonController;
use App\Http\Controllers\Api\V1\User\MyBookingController;
use App\Http\Controllers\Api\V1\User\TransactionController;

Route::prefix("user")->name("api.user.")->group(function () {

      Route::controller(FavoriteSalonController::class)->prefix("favorite-salon")->group(function () {
        Route::get('/', 'index')->name('index');
        Route::post('store', 'store');
        Route::post('delete', 'delete');
    });

    Route::controller(ProfileController::class)->prefix('profile')->group(function () {
        Route::get('info', 'profileInfo');
        Route::post('info/update', 'profileInfoUpdate')->middleware('app.mode');
        Route::post('password/update', 'profilePasswordUpdate')->middleware('app.mode');
        Route::post('delete', 'deleteAccount')->middleware('app.mode');
    });

    // Logout Route
    Route::post('logout', [ProfileController::class, 'logout']);

    // // parlour booking  Routes
    Route::controller(ParlourBookingController::class)->prefix("payment-method")->name('payment.method.')->group(function () {
        Route::get("payment-gateways", "getPaymentGateways");
        Route::post('checkout', 'checkout');
        Route::post('cashPayment/submit/{slug}', 'cashPayment');
        // Submit with automatic gateway
        Route::post("automatic/submit/{slug}", "automaticSubmit");

        // Automatic Gateway Response Routes
        Route::get('success/response/{gateway}', 'success')->withoutMiddleware(['auth:api'])->name("payment.success");
        Route::get("cancel/response/{gateway}", 'cancel')->withoutMiddleware(['auth:api'])->name("payment.cancel");

        // POST Route For Unauthenticated Request
        Route::post('success/response/{gateway}', 'postSuccess')->name('payment.success')->withoutMiddleware(['auth:api']);
        Route::post('cancel/response/{gateway}', 'postCancel')->name('payment.cancel')->withoutMiddleware(['auth:api']);

        //redirect with Btn Pay
        Route::get('redirect/btn/checkout/{gateway}', 'redirectBtnPay')->name('payment.btn.pay')->withoutMiddleware(['auth:api']);

        // Automatic gateway additional fields
        Route::get('payment-gateway/additional-fields', 'gatewayAdditionalFields');


        Route::prefix('payment')->name('payment.')->group(function () {
            Route::post('crypto/confirm/{trx_id}', 'cryptoPaymentConfirm')->name('crypto.confirm');
        });

         Route::post('authorize-payment-submit','authorizePaymentSubmit')->name('authorize.payment.submit');
        // Route::get('api/paystack/pay/callback','paystackPayCallBack')->name('paystack.pay.callback');
    });

     // Dashboard,
    Route::controller(DashboardController::class)->group(function () {
        Route::get("dashboard", "dashboard");
        Route::get("notifications", "notifications");
    });

     // Transaction
    Route::controller(TransactionController::class)->prefix("transaction")->group(function () {
        Route::get("history", "bookingHistory");
        Route::get("booking/details/{slug}", "details");
        Route::get("log", "log");
          Route::post("review", "review");
         Route::post('download/{slug}', 'downloadPdf');
            Route::get('booking/details/download/{slug}', 'responsePdf')->name('download.pdf');
    });
});
