<?php

use App\Http\Controllers\Api\V1\Manager\Auth\AuthController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\Manager\DashboardController;
use App\Http\Controllers\Api\V1\Manager\ProfileController;
use App\Http\Controllers\Api\V1\Manager\BookingRequestController;
use App\Http\Controllers\Api\V1\Manager\ForgotPasswordController;

Route::name('api.v1.')->group(function () {
    Route::group(['prefix' => 'manager', 'as' => 'manager.'], function () {

           // Forget password routes
    Route::controller(ForgotPasswordController::class)->prefix("password/forgot")->group(function(){
        Route::post('find/user','findManagerSendCode');
        Route::post('verify/code','verifyCode');
        Route::get('resend/code','resendCode');
        Route::post('reset','resetPassword');
    });

        Route::post('login', [AuthController::class, 'login']);

        Route::middleware('manager.api')->group(function () {
            //dashboard
            Route::controller(DashboardController::class)->group(function () {
                Route::get('dashboard', 'index')->name('dashboard');
                Route::post('logout', 'logout');
            });
            //booking request
            Route::controller(BookingRequestController::class)->name('booking.request.')->group(function () {
                Route::get('booking/request', 'index')->name('index');
                Route::post('status/update', 'statusUpdate')->name('status.update');
                Route::post('assign/stuff', 'assignTempStuff');
                Route::get('my-parlour', 'myParlour');
                Route::get('stuff', 'stuff');
            Route::post('remarks','remarkAdd');
            });

            Route::controller(ProfileController::class)->prefix('profile')->group(function () {
                Route::get('info', 'profileInfo');
                Route::post('info/update', 'profileInfoUpdate')->middleware('app.mode');
                Route::post('password/update', 'profilePasswordUpdate')->middleware('app.mode');
                Route::post('delete', 'deleteAccount')->middleware('app.mode');
            });
        });
    });
});
