<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\User\SettingController;
use App\Http\Controllers\Api\V1\IndexController;

// Settings
Route::controller(SettingController::class)->prefix("settings")->group(function () {
    Route::get("basic-settings", "basicSettings");
    Route::get("splash-screen", "splashScreen");
    Route::get("onboard-screens", "onboardScreens");
    Route::get("languages", "getLanguages");
    Route::get("parlour-list", "parlourList");
    Route::get("schedule-service/{id}", "scheduleService");
    Route::post("search-parlour", "searchParlour");
    Route::get("country-list", "countryList");
    Route::post('check-schedule', 'checkSchedule');
});


// index
Route::controller(IndexController::class)->prefix("frontend")->group(function () {
    Route::get("/", "index");

});
