@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Add Staff'),
    ])
@endsection

@section('content')
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title">{{ __($page_title) }}</h6>
        </div>
        <div class="card-body">
            <form class="card-form" action="{{ setRoute('vendors.stuff.store.submit') }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <input type="text" name="vendor_id" value="{{ $vendor_id }}" hidden/>
                <div class="row  mb-10-none">
                    <div class="row justify-content-center">
                        <div class="col-xl-4 col-lg-4 form-group mb-5">
                            @include('admin.components.form.input-file',[
                                'label'             => __("Image").'*',
                                'name'              => "image",
                                'class'             => "file-holder",
                                'old_files'         => old("image"),
                                'attribute'         => 'data-height=130'
                            ])
                        </div>
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Name') . '*',
                            'name' => 'stuff_name',
                            'placeholder' => __('Write Name') . '...',
                            'value' => old('name'),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input',[
                            'label'             => __("Address")."*",
                            'name'              => "address",
                            'placeholder'       => __("Write Address")."...",
                            'value'             => old("address"),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input',[
                            'label'             => __("Mobile")."*",
                            'name'              => "mobile",
                            'placeholder'       => __("Write Mobile")."...",
                            'value'             => old("mobile"),
                        ])
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        @include('admin.components.button.form-btn', [
                            'class' => 'w-100 btn-loading',
                            'text' => 'Submit',
                        ])
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
    <script>
        $(document).ready(function() {
            var getStuffURL = "{{ setRoute('vendors.stuff.get.stuff') }}";
            $('.add-stuff-btn').click(function() {

                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
@endpush
