@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Booking Request'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ])
@endsection

@section('content')

    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="my-salon parlour-list-area">
                <div class="table-responsive">
                    <table class="custom-table">
                        <thead>
                            <tr>
                                <th></th>

                                <th>{{ __('Service Name') }}</th>
                                <th>{{ __('Price') }}</th>

                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($service_data ?? [] as $index => $item)
                                <tr  class="text-light">
                                    <td>
 
                                    </td>
                                    <td>
                                        {{ $item->service_name }}
                                    </td>
                                    <td>{{getAmount( $item->price) . " " .get_default_currency_code() }}</td>

                                </tr>
                            @empty
                                <td colspan="7">
                                    <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                        {{ __('No Record Found!') }}
                                    </div>
                                </td>
                            @endforelse

                        </tbody>

                    </table>
                </div>
            </div>
        </div>
        {{ get_paginate($service_data) }}
    </div>
@endsection
@push('script')
@endpush
