@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Salon'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Salon Add'),
    ])
@endsection

@section('content')
    <div class="custom-card">
        <div class="card-body">
            <form class="card-form" action="{{ setRoute('vendors.parlour.list.store') }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <input type="text" name="vendor_id" value="{{ $vendor_id }}" hidden>
                {{-- <div class="row justify-content-center">
                    <div class="col-xl-4 col-lg-4 form-group mb-5">
                       
                        @include('admin.components.form.input-file', [
                            'label' => __('Image'),
                            'name' => 'image',
                            'class' => 'file-holder',
                            'old_files' => old('image'),
                            'attribute' => 'data-height=130',
                        ])
                    </div>
                </div> --}}
                <div class="row justify-content-center">
                    <div class="col-xl-12 col-lg-12 col-12 form-group mb-5">
                        <div class="custom-inner-card input-field-generator" data-source="booking_file_input">
                            <div class="row align-items-end">
                                <div class="row justify-content-center">
                                    <div class="col-xl-4 col-lg-4 form-group mb-5">

                                        @include('admin.components.form.input-file', [
                                            'label' => __('Thumbnail Preview'),
                                            'name' => 'image',
                                            'class' => 'file-holder',
                                            'old_files' => old('image'),
                                            'attribute' => 'data-height=130',
                                        ])
                                    </div>
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 form-group">
                                    {{-- <input class="" type="file" name="image[]" multiple> --}}
                                    @include('admin.components.form.input-file', [
                                        'label' => __('Salon Preview') . '<span>(optional)</span>',
                                        'name' => 'preview[]',
                                        'class' => 'file-holder',
                                    
                                        'attribute' => 'data-height=130',
                                    ])
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 form-group">
                                    {{-- <input class="" type="file" name="image[]" multiple> --}}
                                    @include('admin.components.form.input-file', [
                                        'label' => __('Salon Preview') . '<span>(optional)</span>',
                                        'name' => 'preview[]',
                                        'class' => 'file-holder',
                                    
                                        'attribute' => 'data-height=130',
                                    ])
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 form-group">
                                    {{-- <input class="" type="file" name="image[]" multiple> --}}
                                    @include('admin.components.form.input-file', [
                                        'label' => __('Salon Preview') . '<span>(optional)</span>',
                                        'name' => 'preview[]',
                                        'class' => 'file-holder',
                                    
                                        'attribute' => 'data-height=130',
                                    ])
                                </div>
                                <div class="col-xl-6 col-lg-6 col-md-6 col-sm-6 form-group">
                                    {{-- <input class="" type="file" name="image[]" multiple> --}}
                                    @include('admin.components.form.input-file', [
                                        'label' => __('Salon Preview') . '<span>(optional)</span>',
                                        'name' => 'preview[]',
                                        'class' => 'file-holder',
                                    
                                        'attribute' => 'data-height=130',
                                    ])
                                </div>

                            </div>
                        </div>
                    </div>

                </div>


                <div class="row justify-content-center mb-10-none">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Select Area') }}*</label>
                        <select class="form--control select2-basic" name="area">
                            <option disabled>{{ __('Select Area') }}</option>
                            @foreach ($areas as $item)
                                <option value="{{ $item->id }}" {{ old('area') == $item->id ? 'selected' : '' }}>
                                    {{ $item->name }}
                                </option>
                            @endforeach
                        </select>

                    </div>

                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Select Manager') }}*</label>
                        <select class="form--control select2-basic" name="manager">
                            <option disabled selected>{{ __('Select Manager') }}</option>
                            @foreach ($manager as $item)
                                <option value="{{ $item->id }}">{{ $item->fullname }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Name') . '*',
                            'name' => 'name',
                            'placeholder' => __('Write Name') . '...',
                            'value' => old('name'),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Experience') . '*',
                            'name' => 'experience',
                            'placeholder' => __('Write Experience') . '...',
                            'value' => old('experience'),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Speciality'),
                            'name' => 'speciality',
                            'placeholder' => __('Write Speciality') . '...',
                            'value' => old('speciality'),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Contact') . '*',
                            'name' => 'contact',
                            'placeholder' => __('Write Contact') . '...',
                            'value' => old('contact'),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Address'),
                            'name' => 'address',
                            'placeholder' => __('Write Address') . '...',
                            'value' => old('address'),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Number Of Service Dates') . '*',
                            'name' => 'number_of_dates',
                            'placeholder' => __('Number Of Service Dates') . '...',
                            'value' => old('number_of_dates'),
                        ])
                    </div>
                    <div class="col-xl-6 col-lg-6 form-group">
                        @include('admin.components.form.input', [
                            'label' => __('Todays Date') . '*',
                            'attribute' => 'readonly',
                            'value' => $todayDate,
                        ])
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <h3 class="title">{{ __('Off Days') }}</h6>
                            <div class="card-inner-body">
                                <div class="stuff-result">
                                    <div class="row">
                                        @foreach (getWeekDays() as $day)
                                            <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                                <div class="box-checkbox" style="flex: 0;">
                                                    <input type="checkbox" class="form-check-input" name="off_days[]"
                                                        value="{{ $day['value'] }}" id="day-{{ $loop->index }}"
                                                        {{ collect(old('off_days', []))->contains($day['value']) ? 'checked' : '' }}>

                                                </div>
                                                <div class="box-name mt-1">
                                                    <label class="form-check-label ms-1" for="day-{{ $loop->index }}">
                                                        {{ $day['day_name'] }}
                                                    </label>
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                </div>
                            </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group ptb-20">
                        <div class="custom-inner-card">
                            <div class="card-inner-header pb-10 d-flex justify-content-between">
                                <h3 class="title">{{ __('Service') }}</h6>
                                    <button type="button" class="btn--base add-service-btn"><i class="fas fa-plus"></i>
                                        {{ __('Add') }}</button>
                            </div>
                            <div class="card-inner-body">
                                <div class="result">
                                    @include('admin.components.parlour-list.service-item')
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header">
                                <h3 class="title">{{ __('Staff') }} ({{ __('Min') }} :
                                    {{ $basic_settings->min_stuff }})</h6>
                            </div>
                            <div class="card-inner-body">
                                <div class="stuff-result">
                                    <div class="row">
                                        @foreach ($parlour_has_stuff ?? [] as $item)
                                            <div class="col-lg-4 col-md-4 col-sm-6 d-flex mb-3">
                                                <div class="box-checkbox" style="flex: 0;">
                                                    <input type="checkbox" name="stuff_name[]" class="form-check-input"
                                                        id="stuff-name-list-{{ $item->id }}"
                                                        value="{{ $item->id }}"
                                                        {{ collect(old('stuff_name', []))->contains($item->id) ? 'checked' : '' }}>

                                                </div>
                                                <div class="box-name">
                                                    {{ $item->stuff_name }}
                                                </div>
                                            </div>
                                        @endforeach
                                    </div>

                                </div>
                            </div>
                        </div>

                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header pb-10 d-flex justify-content-between">
                                <h3 class="title">{{ __('Schedule') }}</h6>
                                    <button type="button" class="btn--base add-schedule-btn"><i class="fas fa-plus"></i>
                                        {{ __('Add') }}</button>
                            </div>
                            <div class="card-inner-body">
                                <div class="results">
                                    @include('admin.components.parlour-list.schedule-item')
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        @include('admin.components.button.form-btn', [
                            'class' => 'w-100 btn-loading',
                            'text' => 'Submit',
                        ])
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
@push('script')
    <script>
        $(document).ready(function() {

            var getDayURL = "{{ setRoute('vendors.parlour.list.get.days') }}";
            $('.add-schedule-btn').click(function() {
                $.get(getDayURL, function(data) {
                    $('.results').prepend(data);
                    $('.results').find('.row').first().find("select").select2();
                });
            });
            var getServiceURL = "{{ setRoute('vendors.parlour.list.get.service') }}";
            $('.add-service-btn').click(function() {

                $.get(getServiceURL, function(data) {
                    $('.result').prepend(data);
                    $('.result').find('.row').first().find("select").select2();
                });
            });

            var getStuffURL = "{{ setRoute('vendors.parlour.list.get.stuff') }}";
            $('.add-stuff-btn').click(function() {

                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            // Add row button click handler
            $(document).on('click', '.add-row-btn', function() {
                const newRow = $(this).closest('.row').clone();

                // Reset all file inputs in the cloned row
                newRow.find('input[type="file"]').each(function() {
                    $(this).val(''); // Clear value
                    $(this).siblings('.fileholder-single-file-view').remove(); // Remove preview
                    $(this).siblings('.fileholder-instructions')
                        .show(); // Show default instruction again
                });

                // Change add button to remove button
                newRow.find('.add-row-btn')
                    .html('<i class="fas fa-minus"></i> {{ __('Remove') }}')
                    .removeClass('add-row-btn')
                    .addClass('remove-row-btn btn--danger');

                // Insert after current row
                $(this).closest('.row').after(newRow);
            });

            // Remove row button click handler
            $(document).on('click', '.remove-row-btn', function() {
                $(this).closest('.row').remove();
            });
        });
    </script>
@endpush
