@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Manager List'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ])
@endsection

@section('content')
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="selon-add-btn pb-20">
                <a href="{{ setRoute('vendors.manager.create') }}" class="btn--base"><i class="las la-plus"></i>
                    {{ __('Add Manager') }}</a>
            </div>
            <div class="my-salon parlour-list-area">
                <div class="table-responsive">
                    <table class="custom-table">
                        <thead>
                            <tr>
                                <th></th>
                                <th>{{ __('Name') }}</th>
                                <th>{{ __('Email') }}</th>
                                <th>{{ __('Salon') }}</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($data ?? [] as $index => $item)
                                <tr data-item="{{ json_encode($item) }}" class="text-light">
                                    <td>
                                        <ul class="user-list">
                                            <li> <img class="avatar" src="{{ get_image($item->image, 'manager-profile') }}"
                                                    alt="client"></li>
                                        </ul>
                                    </td>
                                    <td>
                                        {{ $item->firstname . ' ' . $item->lastname ?? '' }}
                                    </td>
                                    <td>{{ $item->email ?? '' }}</td>
                                    <td>
                                        @if ($item->parlourlist->isNotEmpty())
                                            @foreach ($item->parlourlist as $parlour)
                                                @if (!empty($parlour->name))
                                                    {{ $parlour->name }}
                                                @endif
                                            @endforeach
                                        @else
                                            {{ __('Not assign') }}
                                        @endif
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <button class="btn btn--base edit-modal-button"><i
                                                    class="las la-pencil-alt"></i></button>
                                            <button class="btn btn--danger delete-btn"><i
                                                    class="las la-trash-alt"></i></button>
                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <td colspan="7">
                                    <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                        {{ __('No Record Found!') }}
                                    </div>
                                </td>
                            @endforelse

                        </tbody>

                    </table>
                </div>
            </div>
        </div>
        {{ get_paginate($data) }}
    </div>

    {{-- manager Update --}}
    <div id="manager-update" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header px-0">
                <h5 class="modal-title">{{ __('Update Manager') }}</h5>
            </div>
            <div class="modal-form-data">
                <form class="modal-form" method="POST" action="{{ setRoute('vendors.manager.update') }}"
                    enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="target" value="{{ old('target') }}">

                    <div class="row mb-10-none mt-3">
                        <div class="col-xl-12 col-lg-12 form-group">
                            @include('admin.components.form.input', [
                                'label' => __('First Name'),
                                'label_after' => '*',
                                'name' => 'first_name_edit',
                                'value' => old('first_name_edit'),
                            ])
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group">
                            @include('admin.components.form.input', [
                                'label' => __('Last Name'),
                                'label_after' => '*',
                                'name' => 'last_name_edit',
                                'value' => old('last_name_edit'),
                            ])
                        </div>

                        <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                            <button type="button" class="btn btn--danger modal-close">{{ __('Cancel') }}</button>
                            <button type="submit" class="btn btn--base">{{ __('Update') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>



@endsection
@push('script')
    <script>
        openModalWhenError("manager-update", "#manager-update");
        $(".edit-modal-button").click(function() {

            var oldData = JSON.parse($(this).parents("tr").attr("data-item"));
            var editModal = $("#manager-update");

            editModal.find("form").first().find("input[name=target]").val(oldData.id);

            editModal.find("input[name=first_name_edit").val(oldData.firstname);
            editModal.find("input[name=last_name_edit").val(oldData.lastname);

            openModalBySelector("#manager-update");

        });
        $('.delete-btn').click(function() {
            var oldData = JSON.parse($(this).closest('[data-item]').attr('data-item')); // Corrected selector
            var actionRoute = "{{ setRoute('vendors.manager.delete') }}";
            var target = oldData.id;
            var message =
                `{{ __('Are you sure to') }} <strong>{{ __('delete') }}</strong> {{ __('this Manager?') }}`;

            openDeleteModal(actionRoute, target, message);
        });


        function openDeleteModal(URL, target, message, actionBtnText = "{{ __('Remove') }}", method = "DELETE") {
            if (URL == "" || target == "") {
                return false;
            }

            if (message == "") {
                message = "{{ __('Are you sure to delete ?') }}";
            }
            var method = `<input type="hidden" name="_method" value="${method}">`;
            openModalByContent({
                    content: `<div class="card modal-alert border-0">
                        <div class="card-body">
                            <form method="POST" action="${URL}">
                                <input type="hidden" name="_token" value="${laravelCsrf()}">
                                ${method}
                                <div class="head mb-3">
                                    ${message}
                                    <input type="hidden" name="target" value="${target}">
                                </div>
                                <div class="foot d-flex align-items-center justify-content-between">
                                    <button type="button" class="modal-close btn btn--info">{{ __('Close') }}</button>
                                    <button type="submit" class="alert-submit-btn btn btn--danger btn-loading">${actionBtnText}</button>
                                </div>
                            </form>
                        </div>
                    </div>`,
                },

            );
        }

        function openModalByContent(data = {
            content: "",
            animation: "mfp-move-horizontal",
            size: "medium",
        }) {
            $.magnificPopup.open({
                removalDelay: 500,
                items: {
                    src: `<div class="white-popup mfp-with-anim ${data.size ?? "medium"}">${data.content}</div>`, // can be a HTML string, jQuery object, or CSS selector
                },
                callbacks: {
                    beforeOpen: function() {
                        this.st.mainClass = data.animation ?? "mfp-move-horizontal";
                    },
                    open: function() {
                        var modalCloseBtn = this.contentContainer.find(".modal-close");
                        $(modalCloseBtn).click(function() {
                            $.magnificPopup.close();
                        });
                    },
                },
                midClick: true,
            });
        }
    </script>
@endpush
