@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Salon List'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Salon List'),
    ])
@endsection

@section('content')
    @forelse ($booking_data ?? [] as $item)

        <div class="dashboard-list-wrapper mt-2">
            <div class="dashboard-list-item-wrapper">
                <div class="dashboard-list-item sent">
                    <div class="dashboard-list-left">
                        <div class="dashboard-list-user-wrapper">
                            <div class="dashboard-list-user-icon">
                                <img src="{{ get_image($item->parlour->image ?? '', 'site-section') ?? '' }}" alt="img">
                            </div>
                            <div class="dashboard-list-user-content">
                                <h4 class="title">{{ $item->user->username }}</h4>
                                <span class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="dashboard-list-right">
                        <h4 class="main-money text--base">{{ $item->date }}</h4>
                    </div>
                </div>
                <div class="preview-list-wrapper">
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-user"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>Name</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->user->username }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-envelope"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>Email</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->user->email }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-hand-holding-heart"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>Service Type</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ is_array($item->service) ? implode(', ', $item->service) : $item->service }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-history"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>Schedule Date</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->date }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>Charge</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{getAmount($item->total_charge)}}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>Total</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ getAmount($item->payable_price) }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>Serial No.</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ getAmount($item->serial_number) }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-smoking"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>status</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right text-center">
                             <span class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    @empty
        @include('admin.components.alerts.empty', ['colspan' => 5])
    @endforelse
@endsection
@push('script')
@endpush
