@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Booking Request'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ])
@endsection

@section('content')
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="my-salon parlour-list-area">
                <div class="table-responsive">
                    <table class="custom-table">
                        <thead>
                            <tr>
                                <th></th>
                                <th>{{ __('Salon Name') }}</th>
                                <th></th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($data ?? [] as $index => $item)
                                <tr data-item="{{ json_encode($item) }}" class="text-light">

                                    <td>
                                        <ul class="user-list">
                                            <li>  <img src="{{ get_image($item->image ?? '', 'site-section') ?? '' }}" alt="img"></li>
                                        </ul>
                                    </td>
                                    <td>
                                        {{ $item->name ?? '' }}
                                    </td>
                                    <td>
                                        <div class="btn-group" role="group">
                                            <a href="{{ route('vendors.booking.request.details', ['booking_id' => $item->id]) }}"
                                                class="btn btn--base edit-modal-button">
                                                <i class="las la-eye"></i>
                                            </a>

                                        </div>
                                    </td>
                                </tr>
                            @empty
                                <td colspan="7">
                                    <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                        {{ __('No Record Found!') }}
                                    </div>
                                </td>
                            @endforelse

                        </tbody>

                    </table>
                </div>
            </div>
        </div>
        {{ get_paginate($data) }}
    </div>
@endsection
@push('script')
@endpush
