@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Booking Request'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
    ])
@endsection

@section('content')
    @forelse ($booking_data ?? [] as $item)
        <div class="dashboard-list-wrapper mt-2" data-item="{{ json_encode($item) }}">
            <div class="dashboard-list-item-wrapper">
                <div class="dashboard-list-item sent">
                    <div class="dashboard-list-left">
                        <div class="dashboard-list-user-wrapper">
                            <div class="dashboard-list-user-icon">
                                <img src="{{ get_image($item->parlour->image ?? '', 'site-section') ?? '' }}" alt="img">
                            </div>
                            <div class="dashboard-list-user-content">
                                <h4 class="title">{{ $item->user->username }}</h4>
                                <span class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="dashboard-list-right">
                         @if ($item->review == null)
                                        <p>{{ __('No review given') }}</p>
                                    @else
                                        <div class="star-rating-display">
                                            @for ($i = 1; $i <= 5; $i++)
                                                @if ($i <= $item->review)
                                                    <span class="star-filled">★</span>
                                                @else
                                                    <span class="star-empty">☆</span>
                                                @endif
                                            @endfor
                                            <span class="rating-value">({{ $item->review }}/5)</span>
                                        </div>
                                    @endif
                        <h4 class="main-money text--base">
                            {{ \Carbon\Carbon::parse($item->date)->format('jS M Y') }}
                        </h4>
                        <h4 class="main-money text--base">
                            {{ \Carbon\Carbon::parse($item->schedule->from_time)->format('h:i A') . ' - ' . \Carbon\Carbon::parse($item->schedule->to_time)->format('h:i A') }}
                        </h4>
                    </div>
                </div>
                <div class="preview-list-wrapper">
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-user"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Name') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->user->username }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-envelope"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Email') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->user->email }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-hand-holding-heart"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Service Type') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ is_array($item->service) ? implode(', ', $item->service) : $item->service }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-history"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Schedule Date') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->date }}</span>

                        </div>

                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Charge') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ getAmount($item->total_charge) }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Total') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ getAmount($item->payable_price) }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-wallet"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Payment Type') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            @if ($item->payment_method == 'Cash Payment')
                                <span">{{ 'Cash Payment' }}
                                </span">
                            @else
                                <span">{{ 'Online Payment' }}
                                </span">
                            @endif
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Serial No') }}.</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ getAmount($item->serial_number) }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-smoking"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Status') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right text-center">

                            <span class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>

                        </div>
                    </div>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-users-cog"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Staff') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">

                            @if ($item->stuff != null)
                                <span>{{ $item->stuff->stuff_name }}</span>
                            @else
                                <p> {{ __('Staff Not Assign') }}</p>
                            @endif

                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-clock"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Schedule') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ $item->schedule->from_time . ' - ' . $item->schedule->to_time }}
                            </span">
                        </div>
                    </div>
                           <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-clock"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('User Comment') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ $item->comment ?? 'N/A' }}
                            </span">
                        </div>
                    </div>
                </div>
            </div>
        </div>

    @empty
        <td colspan="7">
            <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                {{ __('No Record Found!') }}
            </div>
        </td>
    @endforelse
    {{ get_paginate($booking_data) }}
@endsection
@push('script')
@endpush
