@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Staff'),
    ])
@endsection

@section('content')
    <div class="selon-add-btn pb-20">
        <a href="{{ setRoute('vendors.stuff.create') }}" class="btn--base"><i class="las la-plus"></i>
            {{ __('Add Staff') }}</a>
    </div>
    <div class="table-responsive">
        <table class="custom-table">
            <thead>
                <tr>
                    <th>{{ __('Name') }}</th>
                    <th>{{ __('Action') }}</th>
                    <th></th>
                </tr>
            </thead>
            <tbody>
                @forelse ($stuff as $item)
                    <tr>
                        <td>{{ $item->name }}</td>
                        <td>
                            <span class="{{ $item->stringStatus->class }}">{{ $item->stringStatus->value }}</span>
                        </td>
                        <td>{{ $item->created_at->format('Y-m-d H:i A') }}</td>
                        <td>
                            <a href="{{ route('user.support.ticket.conversation', encrypt($item->id)) }}"
                                class="btn btn--base"><i class="las la-comment"></i></a>
                        </td>
                    </tr>
                @empty
                    <td colspan="7">
                        <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                            {{ __('No Record Found!') }}
                        </div>
                    </td>
                @endforelse

            </tbody>
        </table>
    </div>
@endsection

@push('script')
    <script></script>
@endpush
