@extends('vendor.layouts.master')

@section('breadcrumb')
    @include('vendor.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('vendors.dashboard'),
            ],
        ],
        'active' => __('Staff'),
    ])
@endsection

@section('content')
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title">{{ __($page_title) }}</h6>
        </div>
        <div class="card-body">
            <form class="card-form" action="{{ setRoute('vendors.stuff.store.submit') }}" method="POST"
                enctype="multipart/form-data">
                @csrf
                <div class="row  mb-10-none">
                    <div class="col-xl-6 col-lg-6 form-group">
                        <label>{{ __('Select Salon') }}*</label>
                        <select class="form--control select2-basic" name="parlour_list_id">
                            <option disabled selected>{{ __('Select Salon') }}</option>
                            @foreach ($parlour_list as $item)
                                <option value="{{ $item->id }}">{{ $item->name }}</option>
                            @endforeach
                        </select>
                    </div>

                    <div class="col-xl-12 col-lg-12 form-group">
                        <div class="custom-inner-card">
                            <div class="card-inner-header">
                                <h6 class="title">{{ __('Staff') }}</h6>
                                <button type="button" class="btn--base add-stuff-btn"><i class="fas fa-plus"></i>
                                    {{ __('Add') }}</button>
                            </div>
                            <div class="card-inner-body">
                                <div class="stuff-result">
                                    @include('admin.components.parlour-list.stuff-item')
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        @include('admin.components.button.form-btn', [
                            'class' => 'w-100 btn-loading',
                            'text' => 'Submit',
                        ])
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
<script>

    $(document).ready(function(){
        var getStuffURL = "{{ setRoute('vendors.stuff.get.stuff') }}";
        $('.add-stuff-btn').click(function(){

            $.get(getStuffURL,function(data){
                $('.stuff-result').prepend(data);
                $('.stuff-result').find('.row').first().find("select").select2();
            });
        });
    });
</script>
@endpush
