<div class="sidebar">
    <div class="sidebar-inner">
        <div class="sidebar-menu-wrapper">
            <div class="sidebar-logo">
                <a href="{{ setRoute('frontend.index') }}" class="sidebar-main-logo">
                    <img src="{{ get_logo_vendor($basic_settings) }}"
                        data-white_img="{{ get_logo_vendor($basic_settings, 'dark') }}"
                        data-dark_img="{{ get_logo_vendor($basic_settings) }}" alt="logo">
                </a>
                <button class="sidebar-menu-bar">
                    <i class="fas fa-exchange-alt"></i>
                </button>
            </div>
            <ul class="sidebar-menu">
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.dashboard') }}">
                        <i class="menu-icon las la-palette"></i>
                        <span class="menu-title">{{ __('Dashboard') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.withdraw.money.index') }}">
                        <i class="menu-icon las la-money-bill-wave"></i>
                        <span class="menu-title">{{ __('Withdraw Money') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.admin.charges.index') }}">
                        <i class="menu-icon las la-receipt"></i>
                        <span class="menu-title">{{ __('Pay Charges') }}</span>
                    </a>
                </li>
                @php
                    use App\Models\ParlourBooking;

                    $parlour = ParlourBooking::auth()->orderByDesc('id')->get();
                    $count = $parlour->count();
                @endphp

                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.booking.request.index') }}">
                        <i class="menu-icon las la-calendar-check"></i>
                        <span class="menu-title">{{ __('Booking Request') }}</span>
                        <div class="sidebar-item-badge">
                            <span class="badge">{{ $count }}</span>
                        </div>
                    </a>
                </li>

                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.manager.index') }}">
                        <i class="menu-icon las la-user-tie"></i>
                        <span class="menu-title">{{ __('Manager Section') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.stuff.index') }}">
                        <i class="menu-icon las la-users-cog"></i>
                        <span class="menu-title">{{ __('Manage Staff') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.service.section.index') }}">
                        <i class="menu-icon las la-cut"></i>
                        <span class="menu-title">{{ __('Service Section') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.parlour.list.index') }}">
                        <i class="menu-icon las la-cut"></i>
                        <span class="menu-title">{{ __('My Salon') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ route('vendors.authorize.kyc') }}">
                        <i class="fas fa-user-shield menu-icon"></i>
                        <span class="menu-title">{{ __('KYC Verification') }}</span>
                    </a>
                </li>
                <li class="sidebar-menu-item">
                    <a href="{{ setRoute('vendors.security.google.2fa') }}">
                        <i class="menu-icon las la-lock-open"></i>
                        <span class="menu-title">{{ __('2FA') }}</span>
                    </a>
                </li>

                <li class="sidebar-menu-item">
                    <a href="javascript:void(0)" class="logout-btn-vendor">
                        <i class="menu-icon las la-sign-out-alt"></i>
                        <span class="menu-title">{{ __('Logout') }}</span>
                    </a>
                </li>
            </ul>
        </div>
        <div class="sidebar-doc-box bg_img"
            data-background="{{ asset('public/frontend/images/element/sidebar.webp') }}">
            <div class="sidebar-doc-icon">
                <i class="las la-headphones-alt"></i>
            </div>
            <div class="sidebar-doc-content">
                <h4 class="title">{{ __('Need Help') }}?</h4>
                <p>{{ __('Please check our docs') }}</p>
                <div class="sidebar-doc-btn">
                    <a href="{{ route('vendors.support.ticket.index') }}"
                        class="btn--base w-100">{{ __('Get Support') }}</a>
                </div>
            </div>
        </div>
    </div>
</div>

@push('script')
    <script>
        $(".logout-btn-vendor").click(function() {
            var actionRoute = "{{ setRoute('vendors.logout') }}";
            var target = 1;
            var message = `{{ __('Are you sure to') }} <strong>{{ __('Logout') }}</strong>?`;

            openAlertModal(actionRoute, target, message, "{{ __('Logout') }}", "POST");
            /**
             * Function for open delete modal with method DELETE
             * @param {string} URL
             * @param {string} target
             * @param {string} message
             * @returns
             */
            function openAlertModal(URL, target, message, actionBtnText = "{{ __('Remove') }}", method =
                "DELETE") {
                if (URL == "" || target == "") {
                    return false;
                }

                if (message == "") {
                    message = "Are you sure to delete ?";
                }
                var method = `<input type="hidden" name="_method" value="${method}">`;
                openModalByContent({
                        content: `<div class="card modal-alert border-0">
              <div class="card-body">
                  <form method="POST" action="${URL}">
                      <input type="hidden" name="_token" value="${laravelCsrf()}">
                      ${method}
                      <div class="head mb-3">
                          ${message}
                          <input type="hidden" name="target" value="${target}">
                      </div>
                      <div class="foot d-flex align-items-center justify-content-between">
                          <button type="button" class="modal-close btn--base btn-for-modal">{{ __('Close') }}</button>
                          <button type="submit" class="alert-submit-btn btn--danger btn-loading btn-for-modal">${actionBtnText}</button>
                      </div>
                  </form>
              </div>
          </div>`,
                    },

                );
            }
        });
    </script>
@endpush
