<!DOCTYPE html>
<html>

<head>
    <title>{{ $page_title }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
        }

        .header {
            text-align: center;
            margin-bottom: 20px;
        }

        .details {
            margin-bottom: 15px;
        }

        .detail-label {
            font-weight: bold;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        table,
        th,
        td {
            border: 1px solid #ddd;
        }

        th,
        td {
            padding: 8px;
            text-align: left;
        }
    </style>
</head>

<body>
    <div class="header">
        <h1>{{ $page_title }}</h1>
        <p>Booking Reference: {{ $data->trx_id }}</p>
    </div>

    <div class="details">
        <h2>Booking Information</h2>
        <table>
            <tr>
                <td class="detail-label">Date:</td>
                <td>{{ $data->date }}</td>
            </tr>
            <tr>
                <td class="detail-label">Serial Number:</td>
                <td>{{ $data->serial_number }}</td>
            </tr>
            <tr>
                <td class="detail-label">Status:</td>
                <td>
                    <span class="{{ $data->stringStatus->class }}">{{ __($data->stringStatus->value) }}</span>
                </td>
            </tr>
            <tr>
                <td class="detail-label">Payment Method:</td>
                <td>{{ $data->payment_method }}</td>
            </tr>
        </table>
    </div>

    <div class="details">
        <h2>Services</h2>
        <ul>
            @foreach ($data->service as $service)
                <li>{{ $service }}</li>
            @endforeach
        </ul>
    </div>

    <div class="details">
        <h2>Pricing</h2>
        <table>
            <tr>
                <td class="detail-label">Base Price:</td>
                <td>{{ number_format((float) $data->price, 2) }} {{ $data->payment_currency ?? 'USD' }}</td>
            </tr>
            <tr>
                <td class="detail-label">Additional Charges:</td>
                <td>{{ number_format((float) $data->total_charge, 2) }} {{ $data->payment_currency ?? 'USD' }}</td>
            </tr>
            <tr>
                <td class="detail-label">Total Payable:</td>
                <td>{{ number_format((float) $data->payable_price, 2) }} {{ $data->payment_currency ?? 'USD' }}</td>
            </tr>
        </table>
    </div>
</body>

</html>
