@extends('user.layouts.master')

@push('css')
@endpush
@section('breadcrumb')
    @include('user.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Profile'),
                'url' => setRoute('user.profile.index'),
            ],
        ],
        'active' => __('My History'),
    ])
@endsection
@section('content')
    <div class="row justify-content-center">
        <div class="col-lg-10">
            <div class="appointment-area">
                <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i> {{ __('Booking Details') }}</h3>
                <div class="salon-thumb">
                    <img src="{{ get_image($data->parlour->image, 'site-section') }}" alt="img">
                </div>
                <div class="about-details">
                    <div class="salon-title">
                        <h3 class="title"><i class="las la-user-alt"></i> {{ __('Salon Information') }}</h3>
                    </div>
                    <div class="list-wrapper">
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Salon Name') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ $data->parlour->name ?? '' }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Contact') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ $data->parlour->contact ?? '' }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Salon Address') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ $data->parlour->address ?? '' }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="salon-title pt-4">
                        <h3 class="title"><i class="las la-street-view"></i> {{ __('Service Information') }}</h3>
                    </div>
                    <div class="list-wrapper">
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Service Name') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ implode(', ', $data->service) ?? '' }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="shedule-title pt-4">
                        <h3 class="title"><i class="fas fa-history"> </i> {{ __('Schedule Information') }}</h3>
                    </div>
                    <div class="list-wrapper">
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Date') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ $data->date }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Time') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ $data->schedule->from_time ?? '' }} - {{ $data->schedule->to_time ?? '' }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Serial Number') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ $data->serial_number ?? '' }}</p>
                            </div>
                        </div>
                    </div>
                    <div class="shedule-title pt-4">
                        <h3 class="title"><i class="las la-comment-dollar"></i> {{ __('Payment Information') }}</h3>
                    </div>
                    <div class="list-wrapper">
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('MTCN Number') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ $data->trx_id ?? '' }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Payment Method') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ $data->payment_method ?? '' }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Total Service Price') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ get_default_currency_symbol() }}{{ get_amount($data->price) }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Fees & Charges') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ get_default_currency_symbol() }}{{ get_amount($data->total_charge) }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Total Payable Price') }} :</p>
                            </div>
                            <div class="preview-details">
                                <p>{{ get_default_currency_symbol() }}{{ get_amount($data->payable_price) }}</p>
                            </div>
                        </div>
                        <div class="preview-area">
                            <div class="preview-item">
                                <p>{{ __('Status') }} :</p>
                            </div>
                            <div class="preview-details">
                                <span class="{{ $data->stringStatus->class }}">{{ __($data->stringStatus->value) }}</span>
                            </div>
                        </div>
                        @if ($data->status == global_const()::STATUSSUCCESS && !$data->review)
                            <div class="shedule-title pt-4">
                                <h3 class="title"><i class="las la-star"></i> {{ __('Add Review') }}</h3>
                            </div>
                            <div class="list-wrapper">
                                <form action="{{ setRoute('user.my.booking.review', $data->id) }}" method="POST">
                                    @csrf
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p>{{ __('Your Rating') }} :</p>
                                        </div>
                                        <div class="preview-details">
                                            <div class="rating-wrapper">
                                                <input type="radio" id="star5" name="rating" value="5"
                                                    required />
                                                <label for="star5" title="5 stars">☆</label>
                                                <input type="radio" id="star4" name="rating" value="4" />
                                                <label for="star4" title="4 stars">☆</label>
                                                <input type="radio" id="star3" name="rating" value="3" />
                                                <label for="star3" title="3 stars">☆</label>
                                                <input type="radio" id="star2" name="rating" value="2" />
                                                <label for="star2" title="2 stars">☆</label>
                                                <input type="radio" id="star1" name="rating" value="1" />
                                                <label for="star1" title="1 star">☆</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="preview-area">
                                        <div class="preview-item">
                                            <p>{{ __('Your Review') }} :</p>
                                        </div>
                                        <div class="preview-details">
                                            <textarea name="comment" class="form--control" rows="3" placeholder="{{ __('Write your review here...') }}"></textarea>
                                        </div>
                                    </div>
                                    <div class="text-end mt-3">
                                        <button type="submit" class="btn--base">{{ __('Submit Review') }}</button>
                                    </div>
                                </form>
                            </div>
                        @elseif($data->review)
                            <div class="shedule-title pt-4">
                                <h3 class="title"><i class="las la-star"></i> {{ __('Your Review') }}</h3>
                            </div>
                            <div class="list-wrapper">
                                <div class="preview-area">
                                    <div class="preview-item">
                                        <p>{{ __('Rating') }} :</p>
                                    </div>
                                    <div class="preview-details">
                                        <div class="rating-display">
                                            @for ($i = 1; $i <= 5; $i++)
                                                @if ($i <= $data->review)
                                                    <span class="star-filled">★</span>
                                                @else
                                                    <span class="star-empty">☆</span>
                                                @endif
                                            @endfor
                                        </div>
                                    </div>
                                </div>
                                <div class="preview-area">
                                    <div class="preview-item">
                                        <p>{{ __('Review') }} :</p>
                                    </div>
                                    <div class="preview-details">
                                        <p>{{ $data->comment }}</p>
                                    </div>
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
