@extends('manager.layouts.master')

@section('breadcrumb')
    @include('manager.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('My Salon'),
                'url' => setRoute('manager.dashboard'),
            ],
        ],
        'active' => __('Details'),
    ])
@endsection

@section('content')
    <div class="salon-details-page">
        <div class="row justify-content-center">
            <div class="col-lg-10">
                <div class="appointment-area">
                    <h3 class="title"><i class="fas fa-info-circle text--base mb-20"></i> {{ __('Salon Details') }}</h3>
                    <div class="salon-thumb">
                        <img src="{{ get_image($data->image ?? '', 'site-section') }}" alt="img">
                    </div>
                    <div class="about-details mt-20">
                        <!-- Parlour Information -->
                        <div class="salon-title">
                            <h3 class="title"><i class="fas fa-user-alt"></i> {{ __('Salon Information') }}</h3>
                        </div>
                        <div class="list-wrapper">
                            <div class="preview-area">
                                <div class="preview-item">
                                    <p>{{ __('Salon Name') }}:</p>
                                </div>
                                <div class="preview-details">
                                    <p>{{ $data->name }}</p>
                                </div>
                            </div>
                            <div class="preview-area">
                                <div class="preview-item">
                                <p>{{ __("Manager Name") }} :</p>
                                </div>
                                <div class="preview-details">
                                    <p>{{ $data->manager->firstname . ' '. $data->manager->lastname ?? '' }}</p>
                                </div>
                            </div>
                            <div class="preview-area">
                                <div class="preview-item">
                                    <p>{{ __('Salon Address') }}:</p>
                                </div>
                                <div class="preview-details">
                                    <p>{{ $data->address }}</p>
                                </div>
                            </div>
                            <div class="preview-area">
                                <div class="preview-item">
                                    <p>{{ __('Experience') }}:</p>
                                </div>
                                <div class="preview-details">
                                    <p>{{ $data->experience }}</p>
                                </div>
                            </div>
                        </div>

                        <!-- Schedules -->
                        <div class="parlour-seduel-stuff mt-30">
                            <div class="row mb-40-none">
                                <div class="col-lg-6 col-md-6 col-sm-6 mb-40">
                                    <div class="shedule-item">
                                        <h3 class="title"><i class="fas fa-history"> </i> {{ __('Schedules') }}</h3>
                                        <div class="shedule-inner">
                                            @foreach ($data->schedules as $item )

                                            <label  class="package--amount ">

                                                <strong class="${textClass}">{{ $item->from_time ?? '' }} - </strong>
                                                <strong class="${textClass}">{{ $item->to_time ?? '' }}</strong>
                                            </label>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                                <!-- Staff Section -->
                                <div class="col-lg-6 col-md-6 col-sm-6 mb-40">
                                    <div class="staf-section">
                                        <div class="stuff-title">
                                            <h3 class="title"><i class="fas fa-user-edit"></i> {{ __('Staff') }}</h3>
                                        </div>
                                        <ul class="stuff-area mb-20-none">
                                            @if ($data->stuff->count() > 0)
                                                @foreach ($data->stuff as $staff)
                                                    <li class="stuff-details mb-20">
                                                        <div class="stuf-name">
                                                            <h5>{{ $staff->stuff_name }}</h5>
                                                        </div>
                                                    </li>
                                                @endforeach
                                            @else
                                                <li>{{ __('No staff available.') }}</li>
                                            @endif
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Services -->
                        <div class="service-provied mt-30">
                            <div class="shedule-title pt-4">
                                <h3 class="title"> <i class="fas fa-cut"></i> {{ __('Services') }}</h3>
                            </div>
                            <div class="parlour-service-item">
                                <div class="row">
                                    @if ($data->services->count() > 0)
                                        @foreach ($data->services->chunk(ceil($data->services->count() / 2)) as $services)
                                            <div class="col-lg-6">
                                                <div class="item-price">
                                                    <div class="left-side">
                                                        @foreach ($services as $key=> $service)
                                                            <p class="item-name">{{ $key+1 }}  .  {{ $service->service_name }} :
                                                                <span>{{ get_amount($service->price) }}</span>
                                                            </p>
                                                        @endforeach
                                                    </div>
                                                </div>
                                            </div>
                                        @endforeach
                                    @else
                                        <p>{{ __('No services available.') }}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@push('script')
@endpush
