@extends('manager.layouts.master')

@section('breadcrumb')
    @include('manager.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Booking Request'),
                'url' => setRoute('manager.dashboard'),
            ],
        ],
    ])
@endsection

@section('content')
    @forelse ($booking_data ?? [] as $item)
        <div class="dashboard-list-wrapper mt-2" data-item="{{ json_encode($item) }}">
            <div class="dashboard-list-item-wrapper">
                <div class="dashboard-list-item sent">
                    <div class="dashboard-list-left">
                        <div class="dashboard-list-user-wrapper">
                            <div class="dashboard-list-user-icon">
                                <img src="{{ get_image($item->parlour->image ?? '', 'site-section') ?? '' }}" alt="img">
                            </div>
                            <div class="dashboard-list-user-content">
                                <h4 class="title">{{ $item->user->username }}</h4>
                                <span class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="dashboard-list-right">
                        <h4 class="main-money text--base">
                            {{ \Carbon\Carbon::parse($item->date)->format('jS M Y') }}
                        </h4>
                        <h4 class="main-money text--base">
                            {{ \Carbon\Carbon::parse($item->schedule->from_time)->format('h:i A') . ' - ' . \Carbon\Carbon::parse($item->schedule->to_time)->format('h:i A') }}
                        </h4>
                    </div>
                </div>
                <div class="preview-list-wrapper">
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-user"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Name') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->user->username }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-envelope"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Email') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->user->email }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-hand-holding-heart"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Service Type') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ is_array($item->service) ? implode(', ', $item->service) : $item->service }}</span>
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-history"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Schedule Date') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span>{{ $item->date }}</span>

                        </div>

                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-half"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Charge') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ getAmount($item->total_charge) }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Total') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ getAmount($item->payable_price) }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Serial No') }}.</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ getAmount($item->serial_number) }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-smoking"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Status') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right text-center">
                            @if ($item->status == 2)
                                <form action="{{ setRoute('manager.booking.request.status.update', $item->trx_id) }}"
                                    method="post">
                                    @csrf
                                    <button type="submit" name="status" value="3"
                                        class="service-btn-1">{{ __('Reject') }}</button>
                                    <button type="submit" name="status" value="1"
                                        class="service-btn">{{ __('Accept') }}</button>
                                </form>
                            @else
                                <span class="{{ $item->stringStatus->class }}">{{ __($item->stringStatus->value) }}</span>
                            @endif
                        </div>
                    </div>

                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Staff') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            @if ($item->status == 1)
                                @if ($item->stuff != null)
                                    <span>{{ $item->stuff->stuff_name }}</span>
                                @else
                                    <button type="submit" name="status" value="3"
                                        class="service-btn-1 edit-modal-button">{{ __('Assign Staff') }}</button>
                                @endif
                            @else
                                <span class="">{{ __('Staff not Assigned') }}</span>
                            @endif
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Schedule') }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="preview-list-right">
                            <span">{{ $item->schedule->from_time . ' - ' . $item->schedule->to_time }}
                            </span">
                        </div>
                    </div>
                    <div class="preview-list-item">
                        <div class="preview-list-left">
                            <div class="preview-list-user-wrapper">
                                <div class="preview-list-user-icon">
                                    <i class="las la-battery-full"></i>
                                </div>
                                <div class="preview-list-user-content">
                                    <span>{{ __('Reminder (optional)') }}</span>
                                </div>
                            </div>
                        </div>
                        @if ($item->notes != null)
                            <div class="preview-list-right">
                                <span">{{ $item->notes }}
                                </span">
                            </div>
                        @else
                            <div class="preview-list-right">
                                <form action="{{ route('manager.booking.request.remarks', ['id' => $item->id]) }}"
                                    method="POST" class="row g-2 align-items-center">
                                    @csrf
                                    <div class="col-md-8">
                                        <input type="text" name="remarks" class="form-control"
                                            placeholder="{{ __('Enter remarks') }}" style="background-color: black">
                                    </div>
                                    <div class="col-md-4">
                                        <button type="submit" class="btn btn-primary w-100">{{ __('Add') }}</button>
                                    </div>
                                </form>

                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    @empty
        <td colspan="7">
            <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                {{ __('No Record Found!') }}
            </div>
        </td>
    @endforelse

    {{-- model start here --}}
    <div id="manage-stuff" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header px-0">
                <h5 class="modal-title">{{ __('Manage Staff') }}</h5>
            </div>
            <div class="modal-form-data">
                <form class="modal-form" method="POST" action="{{ setRoute('manager.assign.stuff.store.submit') }}"
                    enctype="multipart/form-data">
                    @csrf
                    @method('POST')
                    <input type="hidden" name="target" value="{{ old('target') }}">
                    <div class="row mb-10-none">
                        <div class="card-inner-body">
                            <div class="stuff-result">
                                <div class="row">
                                    <input name="parlour_booking_id" hidden />
                                    <label>{{ __('Select Staff') }}*</label>
                                    <select class="form--control select2-basic" name="stuff_name">
                                        <option disabled selected>{{ __('Select Staff') }}</option>
                                        @foreach ($parlour_has_stuff as $item)
                                            <option value="{{ $item->id }}">{{ $item->stuff_name }}</option>
                                        @endforeach
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                            <button type="button" class="btn btn--danger modal-close">{{ __('Cancel') }}</button>
                            <button type="submit" class="btn btn--base">{{ __('Assign') }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endsection
@push('script')
    <script>
        openModalWhenError("manage-stuff", "#manage-stuff");

        $(".edit-modal-button").click(function() {
            var data = JSON.parse($(this).parents("div.dashboard-list-wrapper").attr("data-item"));

            var modal = $("#manage-stuff");

            modal.find("form").first().find("input[name=parlour_booking_id]").val(data.id);

            openModalBySelector("#manage-stuff");
        });
    </script>
@endpush
