@extends('manager.layouts.master')

@section('breadcrumb')
    @include('manager.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('manager.dashboard'),
            ],
        ],
    ])
@endsection

@section('content')
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="dashboard-header-wrapper">
                <h4 class="title">{{ __('Manage Staff') }}</h4>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th></th>
                            <th>{{ __('Name') }}</th>
                            <th>{{ __('Status') }}</th>
                            <th></th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($stuff as $index => $item)
                            <tr data-item="{{ json_encode($item) }}">
                                <td>{{ $index + 1 }}</td>
                                <td>{{ $item->stuff_name }}</td>
                                <td>
                                         <span class="badge {{ $item->parlour_booking->count() > 0 ? 'badge--success' : 'badge--danger' }}">{{ $item->parlour_booking->count() > 0 ? 'Assigned' : 'Not Assigned' }}</span>
                                </td>
                                <td>
                                    <a href="{{ setRoute('manager.assign.stuff.details', ['stuff_id' => $item->id]) }}"
                                        class="btn btn--base edit-modal-button">
                                        <i class="las la-eye"></i>
                                </td>
                            </tr>
                        @empty
                            <td colspan="7">
                                <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                    {{ __('No Record Found!') }}
                                </div>
                            </td>
                        @endforelse

                    </tbody>
                </table>
            </div>
        </div>
        {{ get_paginate($stuff) }}
    </div>
@endsection

@push('script')
    <script>
        $(document).ready(function() {
            var getStuffURL = "{{ setRoute('manager.assign.stuff.get.stuff') }}";
            $('.add-stuff-btn').click(function() {

                $.get(getStuffURL, function(data) {
                    $('.stuff-result').prepend(data);
                    $('.stuff-result').find('.row').first().find("select").select2();
                });
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            // Switcher
            switcherAjax("{{ setRoute('manager.assign.stuff.status.update') }}");
        })
    </script>
@endpush
