@extends('manager.layouts.master')

@section('breadcrumb')
    @include('manager.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Staff'),
                'url' => setRoute('manager.dashboard'),
            ],
        ],
        'active' => __('Staff'),
    ])
@endsection

@section('content')
    <div class="table-area mt-10">
        <div class="table-wrapper">
            <div class="dashboard-header-wrapper">
                <h4 class="title">{{ __('Staff Schedule Details') }}</h4>
            </div>
            <div class="table-responsive">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th></th>
                            <th>{{ __('Salon') }}</th>
                            <th>{{ __('From') }}</th>
                            <th>{{ __('To') }}</th>

                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($data ?? [] as $index => $item)
                            <tr data-item="{{ json_encode($item) }}">

                                <td>{{ $index + 1 }}</td>
                                <td>{{ $item->parlour->name }}</td>
                                <td>
                                    {{ $item->from_time }}
                                </td>
                                <td>
                                    {{ $item->to_time }}
                                </td>

                            </tr>
                        @empty
                            <td colspan="7">
                                <div style="margin-top: 37.5px" class="alert alert-primary w-100 text-center">
                                    {{ __('No Record Found!') }}
                                </div>
                            </td>
                        @endforelse

                    </tbody>
                </table>
            </div>
        </div>
        {{ get_paginate($data) }}
    </div>

@endsection

@push('script')

@endpush
