@extends('manager.layouts.master')

@section('breadcrumb')
    @include('manager.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('manager.dashboard'),
            ],
        ],
    ])
@endsection

@section('content')
@section('content')
  
    <div class="dashboard-card-area pt-3">
        <div class="row mb-20-none">
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 mb-20">
                <div class="dasboard-card-item bg-overlay  bg_img" data-background="assets/images/element/card-bg.webp"
                    style="background-image: url(&quot;assets/images/element/card-bg.webp&quot;);">
                    <div class="card-title">
                        <span class="title">{{ __('Total Salon') }}</span>
                        <h4 class="sub-title text--base">{{ $total_salon }}</h4>
                    </div>
                    <div class="card-icon">
                        <i class="las la-dollar-sign"></i>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 mb-20">
                <div class="dasboard-card-item bg-overlay  bg_img" data-background="assets/images/element/card-bg.webp"
                    style="background-image: url(&quot;assets/images/element/card-bg.webp&quot;);">
                    <div class="card-title">
                        <span class="title">{{ __('Total Service') }}</span>
                        <h4 class="sub-title text--base">{{ $total_service }}</h4>
                    </div>
                    <div class="card-icon">
                        <i class="menu-icon las la-history"></i>
                    </div>
                </div>
            </div>
            <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 mb-20">
                <div class="dasboard-card-item bg-overlay  bg_img" data-background="assets/images/element/card-bg.webp"
                    style="background-image: url(&quot;assets/images/element/card-bg.webp&quot;);">
                    <div class="card-title">
                        <span class="title">{{ __('Total Online Transactions') }}</span>
                        <h4 class="sub-title text--base">{{ $online_payment }}</h4>
                    </div>
                    <div class="card-icon">
                        <i class="las la-cloud-upload-alt"></i>
                    </div>
                </div>
            </div>
              <div class="col-xxl-3 col-xl-4 col-lg-4 col-md-4 col-sm-6 mb-20">
                
                <div class="dasboard-card-item bg-overlay  bg_img" data-background="assets/images/element/card-bg.webp"
                    style="background-image: url(&quot;assets/images/element/card-bg.webp&quot;);">
                    <div class="card-title">
                        <span class="title">{{ __('Stuff assigned') }}</span>
                        <h4 class="sub-title text--base">{{ $count_assign_stuff }}</h4>
                    </div>
                    <div class="card-icon">
                        <i class="las la-dollar-sign"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="chart-container">
        <div id="chart" class="chart chart-main" data-chart_one_data="{{ json_encode($data['chart_one_data']) }}"
            data-month_day="{{ json_encode($data['month_day']) }}">
        </div>
    </div>
    <br>
      <div class="card pt-3">
        <div class="card-body pt-3">
      
            <div id="calendar" style="width: 100%; height: 100vh;"></div>


        </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/fullcalendar@6.1.8/index.global.min.js"></script>
@endsection
@endsection

@push('script')
<script>
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('calendar');

    // Pass PHP events to JavaScript
    const events = @json($events);

    // Transform events to FullCalendar format
    const formattedEvents = events.map(event => ({
        title: event.title,
        start: event.date + 'T' + event.start_time,
        end: event.date + 'T' + event.end_time,
        allDay: false
    }));

    const calendar = new FullCalendar.Calendar(calendarEl, {
        initialView: 'dayGridMonth', // 👈 set month view as default
        headerToolbar: {
            left: 'prev,next today',
            center: 'title',
            right: 'dayGridMonth,timeGridWeek,timeGridDay'
        },
        events: formattedEvents,
        initialDate: events.length > 0 ? events[0].date : new Date(),
        slotMinTime: '00:00:00',
        slotMaxTime: '24:00:00',
        slotDuration: '00:30:00',
        height: 'auto',

        // 👇 Use AM/PM time format
        eventTimeFormat: {
            hour: 'numeric',
            minute: '2-digit',
            meridiem: 'short' // shows AM/PM
        }
    });

    calendar.render();
});

    //
    const currentYear = new Date().getFullYear();
    var chart1 = $('#chart');
    var chart_one_data = chart1.data('chart_one_data');
    var month_day = chart1.data('month_day');

    var formattedDates = month_day.map(date => {
        let d = new Date(date);
        return d.toLocaleDateString('en-US', {
            year: 'numeric',
            month: 'short',
            day: '2-digit'
        }).replace(',', '');
    });

    var options = {
        series: [{
            name: 'Completed Transactions',
            color: "#D860EC",
            data: chart_one_data.complete_data // Use the correct key
        }],
        chart: {
            type: 'bar',
            height: 350,
            stacked: true,
            toolbar: {
                show: false
            },
            zoom: {
                enabled: true
            }
        },
        plotOptions: {
            bar: {
                horizontal: false,
                borderRadius: 10
            },
        },
        xaxis: {
            type: 'categories', // Use categories instead of datetime
            categories: formattedDates,
        },
        legend: {
            position: 'bottom',
            offsetX: 40
        },
        title: {
            text: `Monthly Transactions, ${currentYear}`,
            floating: true,
            offsetY: 330,
            align: 'center',
            style: {
                color: '#FFFFFF'
            }
        },
        fill: {
            opacity: 1
        }
    };

    // Render the chart
    var chart = new ApexCharts(document.querySelector("#chart"), options);
    chart.render();
</script>
@endpush
