<!-- Features -->
@php

$app_local = get_default_language_code() ?? 'en';
$default =  App\Constants\LanguageConst::NOT_REMOVABLE;

$slug = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::FEATURES_SECTION);
$features = App\Models\Admin\SiteSections::getData($slug)->first();

@endphp
<section class="reature-section pt-80">
    <div class="container">
        <div class="row">
            <div class="col-xl-8 col-lg-10">
                <div class="how-its-work-title">
                    <h4 class="titte text--base pb-20">{{ $features->value->language->$app_local->section_title ?? $features->value->language->$default->section_title ?? '' }}</h4>
                    <h2 class="titte d-flex align-items-center">{{ $features->value->language->$app_local->heading ??
                    $features->value->language->$default->heading ?? '' }} <i class="las la-arrow-right"></i></h2>
                    <p>{{ $features->value->language->$app_local->sub_heading ??
                    $features->value->language->$default->sub_heading ?? '' }}</p>
                </div>
            </div>
        </div>
        <div class="feature-details pt-40">
            <div class="row">
                <div class="col-lg-12">
                    <div class="featuare-content-area align-items-center">
                        <ul class="feature-list">
                            @foreach ($features->value->items ?? [] as $key => $item)
                            <li>
                                <i class="las la-arrow-right"></i> {{ $item->language->$app_local->title ?? $item->language->$default->title ?? ''}}
                            </li>
                            @endforeach

                        </ul>
                        <div class="key-deatils">
                            <h3 class="title">{{ $features->value->language->$app_local->description_title
                            ?? $features->value->language->$default->description_title  ?? '' }}</h3>
                            <p>{{ $features->value->language->$app_local->description_details ??
                            $features->value->language->$default->description_details ??'' }}</p>
                            <div class="contact-btn">
                                <a href="{{ setRoute('frontend.contact') }}" class="btn--base">{{$features->value->language->$app_local->description_button ?? $features->value->language->$default->description_button ?? ''}} <i class="las la-chevron-right"></i></a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
