@php
    $app_local      = get_default_language_code();
    $default        = App\Constants\LanguageConst::NOT_REMOVABLE;
    $slug           = Illuminate\Support\Str::slug(App\Constants\SiteSectionConst::FOOTER_SECTION);
    $footer         = App\Models\Admin\SiteSections::getData($slug)->first();

    $usefull_links  = App\Models\Admin\UsefulLink::where('status',true)->get();
@endphp
 <!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
        Start Footer
 ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->
 <footer class="footer-section">
    <div class="container mx-auto">
       <div class="footer-content pt-80">
               <div class="row">
                   <div class="col-xl-4 col-lg-4 mb-50">
                       <div class="footer-widget">
                           <div class="footer-text">
                                 <img src="{{ get_logo($basic_settings) }}" alt="logo">
                                 <p>{{ $footer->value->contact->language->$app_local->contact_desc ?? $footer->value->contact->language->$default->contact_desc ?? '' }}</p>
                           </div>
                           <div class="footer-social-icon">
                            <span>{{ __("Follow us") }}:</span>
                            @foreach ($footer->value->contact->social_links ?? [] as $item)

                                <a href="{{ $item->link ?? '' }}"><i class="{{ $item->icon ?? '' }}"></i></a>
                            @endforeach
                        </div>
                       </div>
                   </div>
                   <div class="col-xl-4 col-lg-4 col-md-6 mb-30">
                       <div class="footer-widget">
                           <div class="footer-widget-heading">
                            <h3 class="title">{{ __("Useful Links") }}</h3>
                           </div>
                           <ul>
                            @if(isset($usefull_links))
                            @foreach ($usefull_links as $item)
                                <li><a href="{{ setRoute('frontend.link',$item->slug)}}">{{ $item->title->language->$app_local->title ?? $item->title->language->$default->title ?? "" }}</a></li>
                            @endforeach
                        @endif
                           </ul>
                       </div>
                   </div>
                   <div class="col-xl-4 col-lg-4 col-md-6 mb-50">
                       <div class="footer-widget">
                           <div class="footer-widget-heading">
                               <h3>{{ __('Subscribe') }}</h3>
                           </div>
                           <div class="footer-text mb-25">
                               <p>{{ __('Don’t miss to subscribe to our new feeds, kindly fill the form below') }}</p>
                           </div>
                           <div class="subscribe-form">
                            <form action="{{ setRoute('frontend.subscribe') }}" method="POST">
                                @csrf
                                <input type="email" class="form--control" placeholder={{ __('Email Address') }} name="email">
                                <button type="submit">
                                    <i class="fab fa-telegram-plane"></i>
                                </button>
                            </form>

                           </div>
                       </div>
                   </div>
               </div>
       </div>
   </div>
   <div class="copyright-area">
       <div class="container">
           <div class="row">
               <div class="col-12 text-center text-lg-left">
                   <div class="copyright-text">
                          <p>{{ __("Copyright") }} &copy; {{ date('Y') }}, {{ __("All Right Reserved") }} <a href="#">{{ $basic_settings->site_name }}</a></p>
                    </div>
               </div>
            </div>
       </div>
   </div>
</footer>
<!--~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
       End Footer
~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~-->


