@extends('admin.layouts.master')

@push('css')
    <style>
        .fileholder {
            min-height: 448px !important;
        }

        .fileholder-files-view-wrp.accept-single-file .fileholder-single-file-view,
        .fileholder-files-view-wrp.fileholder-perview-single .fileholder-single-file-view {
            height: 404px !important;
        }
    </style>
@endpush

@section('page-title')
    @include('admin.components.page-title', ['title' => __($page_title)])
@endsection

@section('breadcrumb')
    @include('admin.components.breadcrumb', [
        'breadcrumbs' => [
            [
                'name' => __('Dashboard'),
                'url' => setRoute('admin.dashboard'),
            ],
        ],
        'active' => __('App Settings'),
    ])
@endsection

@section('content')
    <div class="custom-card">
        <div class="card-header">
            <h6 class="title">{{ __('Splash Screen') }}</h6>
        </div>
        <div class="card-body">
            <form class="card-form" method="POST" action="{{ setRoute('admin.app.settings.splash.screen.update') }}"
                enctype="multipart/form-data">
                @csrf
                @method('PUT')
                <div class="row mb-10-none">
                    <div class="col-xl-4">
                        <div class="row">
                            <div class="col-xl-6 col-lg-2 col-md-3 col-sm-4 form-group">
                                @include('admin.components.form.input-file', [
                                    'label' =>
                                        __('Image (User)') . ': <span class="text--danger">(414*896)</span>',
                                    'class' => 'file-holder',
                                    'name' => 'image',
                                    'old_files_path' => files_asset_path('splash-images'),
                                    'old_files' => $app_settings->splash_screen_image,
                                ])
                            </div>
                            <div class="col-xl-6 col-lg-10 col-md-9 col-sm-8">
                                <div class="form-group">
                                    @include('admin.components.form.input', [
                                        'label' => __('App Version* (User)'),
                                        'name' => 'version',
                                        'attribute' => 'data-limit=15',
                                        'value' => old('version', $app_settings->version),
                                        'placeholder' => __('Write Here..'),
                                    ])
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="row">
                            <div class="col-xl-6 col-lg-2 col-md-3 col-sm-4 form-group">
                                @include('admin.components.form.input-file', [
                                    'label' =>
                                        __('Image (Manager):') . ' <span class="text--danger">(414*896)</span>',
                                    'class' => 'file-holder',
                                    'name' => 'manager_image',
                                    'old_files_path' => files_asset_path('splash-images'),
                                    'old_files' => $app_settings->manager_splash_screen_image,
                                ])
                            </div>
                            <div class="col-xl-6 col-lg-10 col-md-9 col-sm-8">
                                <div class="form-group">
                                    @include('admin.components.form.input', [
                                        'label' => __('App Version* (Manager)'),
                                        'name' => 'manager_version',
                                        'attribute' => 'data-limit=15',
                                        'value' => old('manager_version', $app_settings->manager_version),
                                        'placeholder' => __('Write Here..'),
                                    ])
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="row">
                            <div class="col-xl-6 col-lg-2 col-md-3 col-sm-4 form-group">
                                @include('admin.components.form.input-file', [
                                    'label' =>
                                        __('Image (Vendor)') . ': <span class="text--danger">(414*896)</span>',
                                    'class' => 'file-holder',
                                    'name' => 'vendor_image',
                                    'old_files_path' => files_asset_path('splash-images'),
                                    'old_files' => $app_settings->vendor_splash_screen_image,
                                ])
                            </div>
                            <div class="col-xl-6 col-lg-10 col-md-9 col-sm-8">
                                <div class="form-group">
                                    @include('admin.components.form.input', [
                                        'label' => __('App Version* (Vendor)'),
                                        'name' => 'vendor_version',
                                        'attribute' => 'data-limit=15',
                                        'value' => old('vendor_version', $app_settings->vendor_version),
                                        'placeholder' => __('Write Here..'),
                                    ])
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 form-group">
                        <button type="submit" class="btn--base w-100 btn-loading">{{ __('update') }}</button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection

@push('script')
@endpush
