@if (admin_permission_by_name("admin.app.settings.onboard.screen.update"))
    <div id="onboard-screen-edit" class="mfp-hide large">
        <div class="modal-data">
            <div class="modal-header">
                <h5 class="modal-title">{{ __("Edit Screen") }}</h5>
            </div>
            <div class="modal-form-data">
                <form class="modal-form" method="POST" action="{{ setRoute('admin.app.settings.onboard.screen.update') }}" enctype="multipart/form-data">
                    @csrf
                    @method("PUT")
                    @include('admin.components.form.hidden-input',[
                        'name'      => 'target',
                    ])
                    <div class="row mb-10-none">
                        <div class="card-body">
                            <div class="row mb-10-none">
                                <div class="col-xl-4 col-lg-4 col-md-6 col-sm-12 form-group">
                                    @include('admin.components.form.input-file',[
                                        'label'             => __('Image').': <span class="text--danger">(375*812)</span>',
                                        'class'             => "file-holder",
                                        'name'              => "screen_image",
                                        'old_files_path'    => files_asset_path('app-images'),
                                        'old_files'         => old('old_image'),
                                    ])
                                </div>
                                <div class="col-xl-8 col-lg-8 col-md-6 col-sm-12 form-group">
                                    <div class="language-tab">
                                        <nav>
                                            <div class="nav nav-tabs" id="nav-tab" role="tablist">
                                                @foreach ($languages as $item)
                                                    <button class="nav-link @if (get_default_language_code() == $item->code) active @endif" id="modal-{{$item->name}}-tab" data-bs-toggle="tab" data-bs-target="#modal-{{$item->name}}" type="button" role="tab" aria-controls="modal-{{ $item->name }}" aria-selected="true">{{ $item->name }}</button>
                                                @endforeach
                                            </div>
                                        </nav>
                                        <div class="tab-content" id="nav-tabContent">
                                            @foreach ($languages as $item)
                                                @php
                                                    $lang_code = $item->code;
                                                @endphp
                                                <div class="tab-pane @if (get_default_language_code() == $item->code) fade show active @endif" id="modal-{{ $item->name }}" role="tabpanel" aria-labelledby="modal-{{$item->name}}-tab">
                                                    <div class="form-group">
                                                        @include('admin.components.form.input',[
                                                            'label'     => __("Title"),
                                                            'name'      => $lang_code . "_title",
                                                            'attribute' => "data-limit=120",
                                                            'value'     => old($lang_code.'_title'),
                                                            'placeholder'   => __( "Write Here.."),
                                                        ])
                                                    </div>
                                                </div>
                                            @endforeach
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-xl-12 col-lg-12 form-group d-flex align-items-center justify-content-between mt-4">
                            <button type="button" class="btn btn--danger modal-close">{{ __("Cancel") }}</button>
                            <button type="submit" class="btn btn--base">{{ __("Update") }}</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
@endif
