<?php

namespace Database\Seeders\Admin;

use App\Models\Admin\SiteSections;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Constants\SiteSectionConst;
use Illuminate\Support\Str;

class SiteSectionsSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            array('id' => '1','key' => 'site_cookie','value' => '{"status":true,"link":"privacy-policy","desc":"We may use cookies or any other tracking technologies when you visit our website, including any other media form, mobile website, or mobile application related or connected to help customize the Site and improve your experience"}','status' => '1','serialize' => NULL,'created_at' => '2024-11-07 11:32:14','updated_at' => '2024-11-07 11:32:14'),
            array('id' => '3','key' => 'banner-section','value' => '{"image":"8802cbdc-b255-421c-8198-3209490d586a.webp","language":{"en":{"heading":"Transform Your Beauty Journey with SalonHub!","sub_heading":"Discover top-rated salons and spas, book seamlessly, and elevate your beauty routine. Your journey to style, relaxation, and self-care starts here!","left_button":"Book Now","right_button":"Join as a Vendor"},"fr":{"heading":"Transformez votre parcours beaut\\u00e9 avec SalonHub\\u00a0!","sub_heading":"D\\u00e9couvrez les salons et spas les mieux not\\u00e9s, r\\u00e9servez en toute simplicit\\u00e9 et am\\u00e9liorez votre routine beaut\\u00e9. Votre voyage vers le style, la d\\u00e9tente et les soins personnels commence ici\\u00a0!","left_button":"R\\u00e9servez maintenant","right_button":"Rejoignez-nous en tant que vendeur"},"es":{"heading":"\\u00a1Transforme su viaje de belleza con SalonHub!","sub_heading":"Descubra salones y spas de primer nivel, reserve sin problemas y mejore su rutina de belleza. \\u00a1Tu viaje hacia el estilo, la relajaci\\u00f3n y el cuidado personal comienza aqu\\u00ed!","left_button":"Reserva ahora","right_button":"\\u00danase como vendedor"},"ar":{"heading":"\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0648\\u064a\\u0644 \\u0631\\u062d\\u0644\\u0629 \\u062c\\u0645\\u0627\\u0644\\u0643 \\u0645\\u0639 SalonHub!","sub_heading":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639\\u0627\\u062a \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0630\\u0627\\u062a \\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0641 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a\\u060c \\u0648\\u0627\\u062d\\u062c\\u0632 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629\\u060c \\u0648\\u0627\\u0631\\u0641\\u0639 \\u0645\\u0633\\u062a\\u0648\\u0649 \\u0631\\u0648\\u062a\\u064a\\u0646 \\u062c\\u0645\\u0627\\u0644\\u0643. \\u0631\\u062d\\u0644\\u062a\\u0643 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0623\\u0646\\u0627\\u0642\\u0629 \\u0648\\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062e\\u0627\\u0621 \\u0648\\u0627\\u0644\\u0631\\u0639\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0630\\u0627\\u062a\\u064a\\u0629 \\u062a\\u0628\\u062f\\u0623 \\u0647\\u0646\\u0627!","left_button":"\\u0627\\u062d\\u062c\\u0632 \\u0627\\u0644\\u0622\\u0646","right_button":"\\u0627\\u0646\\u0636\\u0645 \\u0643\\u0628\\u0627\\u0626\\u0639"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-07 12:45:20','updated_at' => '2025-01-06 15:06:03'),
            array('id' => '4','key' => 'features-section','value' => '{"language":{"en":{"section_title":"Our Key Features","heading":"Experience Our Outstanding Features","sub_heading":"Managing beauty has never been this easy. Four simple, powerful features to streamline your experience.","description_title":"Why Choose SalonHub?","description_details":"SalonHub redefines salon and spa management by combining convenience with advanced functionality. With cutting-edge encryption and seamless navigation, our platform ensures your data is secure while delivering a hassle-free experience. Whether it\\u2019s 24\\/7 accessibility, simplified booking, or seamless staff and service management, SalonHub equips you with the tools to manage your beauty needs effortlessly.","description_button":"Learn More"},"fr":{"section_title":"Nos principales fonctionnalit\\u00e9s","heading":"D\\u00e9couvrez nos fonctionnalit\\u00e9s exceptionnelles","sub_heading":"G\\u00e9rer la beaut\\u00e9 n\\u2019a jamais \\u00e9t\\u00e9 aussi simple. Quatre fonctionnalit\\u00e9s simples et puissantes pour rationaliser votre exp\\u00e9rience.","description_title":"Pourquoi choisir SalonHub ?","description_details":"SalonHub red\\u00e9finit la gestion des salons et des spas en combinant commodit\\u00e9 et fonctionnalit\\u00e9s avanc\\u00e9es. Avec un cryptage de pointe et une navigation transparente, notre plateforme garantit la s\\u00e9curit\\u00e9 de vos donn\\u00e9es tout en offrant une exp\\u00e9rience sans tracas. Qu\'il s\'agisse d\'une accessibilit\\u00e9 24h\\/24 et 7j\\/7, d\'une r\\u00e9servation simplifi\\u00e9e ou d\'une gestion transparente du personnel et des services, SalonHub vous fournit les outils n\\u00e9cessaires pour g\\u00e9rer vos besoins beaut\\u00e9 sans effort.","description_button":"Apprendre encore plus"},"es":{"section_title":"Nuestras caracter\\u00edsticas clave","heading":"Experimente nuestras caracter\\u00edsticas excepcionales","sub_heading":"Gestionar la belleza nunca ha sido tan f\\u00e1cil. Cuatro funciones sencillas y potentes para optimizar su experiencia.","description_title":"\\u00bfPor qu\\u00e9 elegir SalonHub?","description_details":"SalonHub redefine la gesti\\u00f3n de salones y spas combinando comodidad con funcionalidad avanzada. Con cifrado de \\u00faltima generaci\\u00f3n y navegaci\\u00f3n fluida, nuestra plataforma garantiza que sus datos est\\u00e9n seguros y, al mismo tiempo, ofrece una experiencia sin complicaciones. Ya sea accesibilidad 24 horas al d\\u00eda, 7 d\\u00edas a la semana, reservas simplificadas o gesti\\u00f3n perfecta del personal y los servicios, SalonHub te equipa con las herramientas para gestionar tus necesidades de belleza sin esfuerzo.","description_button":"M\\u00e1s informaci\\u00f3n"},"ar":{"section_title":"\\u0627\\u0644\\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0644\\u0631\\u0626\\u064a\\u0633\\u064a\\u0629 \\u0644\\u062f\\u064a\\u0646\\u0627","heading":"\\u062c\\u0631\\u0651\\u0628 \\u0645\\u064a\\u0632\\u0627\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0631\\u0627\\u0626\\u0639\\u0629","sub_heading":"\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u0644\\u0645 \\u062a\\u0643\\u0646 \\u0628\\u0647\\u0630\\u0647 \\u0627\\u0644\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u0642\\u0628\\u0644. \\u0623\\u0631\\u0628\\u0639 \\u0645\\u064a\\u0632\\u0627\\u062a \\u0628\\u0633\\u064a\\u0637\\u0629 \\u0648\\u0642\\u0648\\u064a\\u0629 \\u0644\\u062a\\u0628\\u0633\\u064a\\u0637 \\u062a\\u062c\\u0631\\u0628\\u062a\\u0643.","description_title":"\\u0644\\u0645\\u0627\\u0630\\u0627 \\u062a\\u062e\\u062a\\u0627\\u0631 SalonHub\\u061f","description_details":"\\u064a\\u0639\\u064a\\u062f SalonHub \\u062a\\u0639\\u0631\\u064a\\u0641 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639\\u0627\\u062a \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062c\\u0645\\u0639 \\u0628\\u064a\\u0646 \\u0627\\u0644\\u0631\\u0627\\u062d\\u0629 \\u0648\\u0627\\u0644\\u0648\\u0638\\u0627\\u0626\\u0641 \\u0627\\u0644\\u0645\\u062a\\u0642\\u062f\\u0645\\u0629. \\u0628\\u0641\\u0636\\u0644 \\u0627\\u0644\\u062a\\u0634\\u0641\\u064a\\u0631 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631 \\u0648\\u0627\\u0644\\u062a\\u0646\\u0642\\u0644 \\u0627\\u0644\\u0633\\u0644\\u0633\\u060c \\u062a\\u0636\\u0645\\u0646 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0623\\u0645\\u0627\\u0646 \\u0628\\u064a\\u0627\\u0646\\u0627\\u062a\\u0643 \\u0645\\u0639 \\u062a\\u0642\\u062f\\u064a\\u0645 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0627\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0631 \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0625\\u0645\\u0643\\u0627\\u0646\\u064a\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0645\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0633\\u0627\\u0639\\u0629 \\u0637\\u0648\\u0627\\u0644 \\u0623\\u064a\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0628\\u0648\\u0639\\u060c \\u0623\\u0648 \\u0627\\u0644\\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0628\\u0633\\u0637\\u060c \\u0623\\u0648 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0633\\u0644\\u0633\\u0629 \\u0644\\u0644\\u0645\\u0648\\u0638\\u0641\\u064a\\u0646 \\u0648\\u0627\\u0644\\u062e\\u062f\\u0645\\u0629\\u060c \\u0641\\u0625\\u0646 SalonHub \\u064a\\u0632\\u0648\\u062f\\u0643 \\u0628\\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0644\\u0627\\u0632\\u0645\\u0629 \\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u062c\\u0645\\u0627\\u0644\\u0643 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621.","description_button":"\\u064a\\u062a\\u0639\\u0644\\u0645 \\u0623\\u0643\\u062b\\u0631"}},"items":{"672cb7f0014c3":{"language":{"en":{"title":"Effortless Booking"},"fr":{"title":"R\\u00e9servation sans effort"},"es":{"title":"Reserva sin esfuerzo"},"ar":{"title":"\\u062d\\u062c\\u0632 \\u0633\\u0647\\u0644"}},"id":"672cb7f0014c3"},"672cb7fb64906":{"language":{"en":{"title":"User-Friendly"},"fr":{"title":"Convivial"},"es":{"title":"F\\u00e1cil de usar"},"ar":{"title":"\\u0633\\u0647\\u0644 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645"}},"id":"672cb7fb64906"},"677ba07ec4149":{"language":{"en":{"title":"Robust Security"},"fr":{"title":"S\\u00e9curit\\u00e9 robuste"},"es":{"title":"Seguridad s\\u00f3lida"},"ar":{"title":"\\u0623\\u0645\\u0627\\u0646 \\u0642\\u0648\\u064a"}},"id":"677ba07ec4149"},"677ba0c03c29d":{"language":{"en":{"title":"Multi-Panel Flexibility"},"fr":{"title":"Flexibilit\\u00e9 multi-panneaux"},"es":{"title":"Flexibilidad de paneles m\\u00faltiples"},"ar":{"title":"\\u0645\\u0631\\u0648\\u0646\\u0629 \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629 \\u0627\\u0644\\u0644\\u0648\\u062d\\u0627\\u062a"}},"id":"677ba0c03c29d"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-07 12:51:44','updated_at' => '2025-01-06 15:22:08'),
            array('id' => '5','key' => 'how-its-work-section','value' => '{"language":{"en":{"title":"How It Works","heading":"Effortlessly Manage Your Beauty Journey in 4 Steps","sub_heading":"Simple, quick, and seamless! Just follow these 4 straightforward steps."},"fr":{"title":"Comment \\u00e7a marche","heading":"G\\u00e9rez sans effort votre parcours beaut\\u00e9 en 4 \\u00e9tapes","sub_heading":"Simple, rapide et transparent ! Suivez simplement ces 4 \\u00e9tapes simples."},"es":{"title":"C\\u00f3mo funciona","heading":"Administre sin esfuerzo su viaje de belleza en 4 pasos","sub_heading":"\\u00a1Simple, r\\u00e1pido y sin problemas! Simplemente siga estos 4 sencillos pasos."},"ar":{"title":"\\u0643\\u064a\\u0641 \\u064a\\u0639\\u0645\\u0644","heading":"\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0631\\u062d\\u0644\\u0629 \\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621 \\u0641\\u064a 4 \\u062e\\u0637\\u0648\\u0627\\u062a","sub_heading":"\\u0628\\u0633\\u064a\\u0637\\u0629 \\u0648\\u0633\\u0631\\u064a\\u0639\\u0629\\u060c \\u0648\\u0633\\u0644\\u0633! \\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u0627\\u062a\\u0628\\u0627\\u0639 \\u0647\\u0630\\u0647 \\u0627\\u0644\\u062e\\u0637\\u0648\\u0627\\u062a \\u0627\\u0644\\u0623\\u0631\\u0628\\u0639 \\u0627\\u0644\\u0645\\u0628\\u0627\\u0634\\u0631\\u0629."}},"items":{"672cb8859d123":{"language":{"en":{"item_title":"Explore Our Services"},"fr":{"item_title":"D\\u00e9couvrez nos services"},"es":{"item_title":"Explora nuestros servicios"},"ar":{"item_title":"\\u0627\\u0633\\u062a\\u0643\\u0634\\u0641 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627"}},"id":"672cb8859d123","icon":"far fa-user"},"672cb895c750e":{"language":{"en":{"item_title":"Choose Your Preferred salon"},"fr":{"item_title":"Choisissez votre salon pr\\u00e9f\\u00e9r\\u00e9"},"es":{"item_title":"Elige tu sal\\u00f3n preferido"},"ar":{"item_title":"\\u0627\\u062e\\u062a\\u0631 \\u0635\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0644\\u062f\\u064a\\u0643"}},"id":"672cb895c750e","icon":"fas fa-search-location"},"677ba2338cbea":{"language":{"en":{"item_title":"Book Your Appointment"},"fr":{"item_title":"Prenez votre rendez-vous"},"es":{"item_title":"Reserve su cita"},"ar":{"item_title":"\\u0627\\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f\\u0643"}},"id":"677ba2338cbea","icon":"fas fa-calendar-check"},"677ba2725769c":{"language":{"en":{"item_title":"Relax & Enjoy"},"fr":{"item_title":"D\\u00e9tendez-vous et profitez"},"es":{"item_title":"Rel\\u00e1jate y disfruta"},"ar":{"item_title":"\\u0627\\u0633\\u062a\\u0631\\u062e \\u0648\\u0627\\u0633\\u062a\\u0645\\u062a\\u0639"}},"id":"677ba2725769c","icon":"fas fa-child"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-07 12:53:58','updated_at' => '2025-01-06 15:29:22'),
            array('id' => '6','key' => 'why-choice-us-section','value' => '{"language":{"en":{"title":"Why Choice Us","heading":"Discover Why SalonHub is Your Ultimate Beauty Solution!","sub_heading":"Experience SalonHub\\u2019s attention to detail and innovative features, revolutionizing salon and spa management. We are committed to delivering unmatched excellence for both vendors and customers alike."},"fr":{"title":"Pourquoi nous choisir","heading":"D\\u00e9couvrez pourquoi SalonHub est votre solution beaut\\u00e9 ultime\\u00a0!","sub_heading":"D\\u00e9couvrez l\\u2019attention port\\u00e9e aux d\\u00e9tails et aux fonctionnalit\\u00e9s innovantes de SalonHub, qui r\\u00e9volutionne la gestion des salons et des spas. Nous nous engageons \\u00e0 offrir une excellence in\\u00e9gal\\u00e9e tant aux fournisseurs qu\\u2019aux clients."},"es":{"title":"\\u00bfPor qu\\u00e9 elegirnos?","heading":"\\u00a1Descubra por qu\\u00e9 SalonHub es su soluci\\u00f3n de belleza definitiva!","sub_heading":"Experimente la atenci\\u00f3n al detalle y las funciones innovadoras de SalonHub, que revolucionan la gesti\\u00f3n de salones y spas. Estamos comprometidos a ofrecer una excelencia inigualable tanto para proveedores como para clientes."},"ar":{"title":"\\u0644\\u0645\\u0627\\u0630\\u0627 \\u062a\\u062e\\u062a\\u0627\\u0631\\u0646\\u0627\\u061f","heading":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0644\\u0645\\u0627\\u0630\\u0627 \\u064a\\u0639\\u062a\\u0628\\u0631 SalonHub \\u0647\\u0648 \\u0627\\u0644\\u062d\\u0644 \\u0627\\u0644\\u0645\\u062b\\u0627\\u0644\\u064a \\u0644\\u0644\\u062c\\u0645\\u0627\\u0644!","sub_heading":"\\u062c\\u0631\\u0628 \\u0627\\u0647\\u062a\\u0645\\u0627\\u0645 SalonHub \\u0628\\u0627\\u0644\\u062a\\u0641\\u0627\\u0635\\u064a\\u0644 \\u0648\\u0627\\u0644\\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u062a\\u0643\\u0631\\u0629\\u060c \\u0645\\u0645\\u0627 \\u0623\\u062d\\u062f\\u062b \\u062b\\u0648\\u0631\\u0629 \\u0641\\u064a \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639\\u0627\\u062a \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629. \\u0646\\u062d\\u0646 \\u0645\\u0644\\u062a\\u0632\\u0645\\u0648\\u0646 \\u0628\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0627\\u0644\\u062a\\u0645\\u064a\\u0632 \\u0627\\u0644\\u0630\\u064a \\u0644\\u0627 \\u0645\\u062b\\u064a\\u0644 \\u0644\\u0647 \\u0644\\u0643\\u0644 \\u0645\\u0646 \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0639\\u0644\\u0649 \\u062d\\u062f \\u0633\\u0648\\u0627\\u0621."}},"items":{"672cb8dce8ef3":{"language":{"en":{"item_title":"Extensive Variety","item_description":"Find top-rated salons offering diverse services and unmatched expertise in one place"},"fr":{"item_title":"Grande vari\\u00e9t\\u00e9","item_description":"Trouvez des salons de premier ordre offrant des services diversifi\\u00e9s et une expertise in\\u00e9gal\\u00e9e en un"},"es":{"item_title":"Amplia Variedad","item_description":"Encuentre salones de primer nivel que ofrecen diversos servicios y experiencia inigualable en un"},"ar":{"item_title":"\\u062a\\u0634\\u0643\\u064a\\u0644\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629","item_description":"\\u0627\\u0628\\u062d\\u062b \\u0639\\u0646 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a \\u0630\\u0627\\u062a \\u0627\\u0644\\u062a\\u0635\\u0646\\u064a\\u0641 \\u0627\\u0644\\u0639\\u0627\\u0644\\u064a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0642\\u062f\\u0645 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0648\\u062e\\u0628\\u0631\\u0629 \\u0644\\u0627 \\u0645\\u062b\\u064a\\u0644 \\u0644\\u0647\\u0627 \\u0641\\u064a \\u0645\\u0643\\u0627\\u0646 \\u0648\\u0627\\u062d\\u062f"}},"id":"672cb8dce8ef3","icon":"fab fa-accessible-icon"},"672cb8efa8eb4":{"language":{"en":{"item_title":"Effortless Booking","item_description":"Seamlessly book appointments with our user-friendly, hassle-free interface"},"fr":{"item_title":"R\\u00e9servation sans effort","item_description":"Prenez rendez-vous en toute transparence gr\\u00e2ce \\u00e0 notre interface conviviale et sans tracas"},"es":{"item_title":"Reserva sin esfuerzo","item_description":"Reserve citas sin problemas con nuestra interfaz f\\u00e1cil de usar y sin complicaciones"},"ar":{"item_title":"\\u062d\\u062c\\u0632 \\u0633\\u0647\\u0644","item_description":"\\u0642\\u0645 \\u0628\\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0648\\u0627\\u062c\\u0647\\u062a\\u0646\\u0627 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0648\\u0627\\u0644\\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628"}},"id":"672cb8efa8eb4","icon":"fas fa-address-card"},"677c025e58647":{"language":{"en":{"item_title":"Secure and Reliable","item_description":"Advanced security and 24\\/7 reliable operations for your peace of mind"},"fr":{"item_title":"S\\u00e9curis\\u00e9 et fiable","item_description":"S\\u00e9curit\\u00e9 avanc\\u00e9e et op\\u00e9rations fiables 24h\\/24 et 7j\\/7 pour votre tranquillit\\u00e9 d\'esprit"},"es":{"item_title":"Seguro y confiable","item_description":"Seguridad avanzada y operaciones confiables 24 horas al d\\u00eda, 7 d\\u00edas a la semana para su tranquilidad"},"ar":{"item_title":"\\u0622\\u0645\\u0646\\u0629 \\u0648\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629","item_description":"\\u0623\\u0645\\u0627\\u0646 \\u0645\\u062a\\u0642\\u062f\\u0645 \\u0648\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0645\\u0648\\u062b\\u0648\\u0642\\u0629 \\u0639\\u0644\\u0649 \\u0645\\u062f\\u0627\\u0631 \\u0627\\u0644\\u0633\\u0627\\u0639\\u0629 \\u0637\\u0648\\u0627\\u0644 \\u0623\\u064a\\u0627\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0628\\u0648\\u0639 \\u0644\\u0631\\u0627\\u062d\\u0629 \\u0628\\u0627\\u0644\\u0643"}},"id":"677c025e58647","icon":"fas fa-lock"},"677c02e041e78":{"language":{"en":{"item_title":"Multi-Panel Management","item_description":"Tailored dashboards for Users, Vendors, Managers, and Admins to simplify management"},"fr":{"item_title":"Gestion multi-panneaux","item_description":"Tableaux de bord sur mesure pour les utilisateurs, les fournisseurs, les gestionnaires et les administrateurs afin de simplifier la gestion"},"es":{"item_title":"Gesti\\u00f3n de paneles m\\u00faltiples","item_description":"Paneles de control personalizados para usuarios, proveedores, gerentes y administradores para simplificar la administraci\\u00f3n"},"ar":{"item_title":"\\u0622\\u0645\\u0646\\u0629 \\u0648\\u0645\\u0648\\u062b\\u0648\\u0642\\u0629","item_description":"\\u0644\\u0648\\u062d\\u0627\\u062a \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0645\\u062e\\u0635\\u0635\\u0629 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0631\\u062f\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u062f\\u064a\\u0631\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0646 \\u0644\\u062a\\u0628\\u0633\\u064a\\u0637 \\u0627\\u0644\\u0625\\u062f\\u0627\\u0631\\u0629"}},"id":"677c02e041e78","icon":"fas fa-solar-panel"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-07 12:55:34','updated_at' => '2025-01-06 22:20:48'),
            array('id' => '7','key' => 'statistics','value' => '{"language":{"en":{"title":"SalonHub Overview","heading":"Discover Our Extensive Network and Superior Services","sub_heading":"Explore the breadth of SalonHub\\u2014an unparalleled platform that connects users, vendors, and beauty experts to redefine the beauty experience."},"fr":{"title":"Pr\\u00e9sentation de SalonHub","heading":"D\\u00e9couvrez notre vaste r\\u00e9seau et nos services sup\\u00e9rieurs","sub_heading":"Explorez l\'\\u00e9tendue de SalonHub, une plateforme sans pr\\u00e9c\\u00e9dent qui connecte les utilisateurs, les fournisseurs et les experts en beaut\\u00e9 pour red\\u00e9finir l\'exp\\u00e9rience beaut\\u00e9."},"es":{"title":"Descripci\\u00f3n general de SalonHub","heading":"Descubra nuestra amplia red y servicios superiores","sub_heading":"Explore la amplitud de SalonHub, una plataforma incomparable que conecta a usuarios, proveedores y expertos en belleza para redefinir la experiencia de belleza."},"ar":{"title":"\\u0646\\u0638\\u0631\\u0629 \\u0639\\u0627\\u0645\\u0629 \\u0639\\u0644\\u0649 \\u0635\\u0627\\u0644\\u0648\\u0646 \\u0647\\u0627\\u0628","heading":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0634\\u0628\\u0643\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0648\\u0627\\u0633\\u0639\\u0629 \\u0648\\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0645\\u062a\\u0645\\u064a\\u0632\\u0629","sub_heading":"\\u0627\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0627\\u062a\\u0633\\u0627\\u0639 SalonHub - \\u0648\\u0647\\u064a \\u0645\\u0646\\u0635\\u0629 \\u0644\\u0627 \\u0645\\u062b\\u064a\\u0644 \\u0644\\u0647\\u0627 \\u062a\\u0631\\u0628\\u0637 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0628\\u0627\\u0626\\u0639\\u064a\\u0646 \\u0648\\u062e\\u0628\\u0631\\u0627\\u0621 \\u0627\\u0644\\u062a\\u062c\\u0645\\u064a\\u0644 \\u0644\\u0625\\u0639\\u0627\\u062f\\u0629 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0627\\u0644\\u062c\\u0645\\u0627\\u0644."}},"items":{"672cb9783a30e":{"language":{"en":{"item_counter_value":"3000.00","item_title":"Total salon","item_description":"Be part of a thriving community. Register your salon for expanded opportunities and growth."},"fr":{"item_counter_value":"3.0000","item_title":"D\\u00e9couvrez nos services","item_description":"Acc\\u00e9dez sans effort \\u00e0 un salon de premier plan offrant des services diversifi\\u00e9s et une"},"es":{"item_counter_value":"3.0000","item_title":"Explora nuestros servicios","item_description":"Acceda sin esfuerzo a salon de primer nivel que ofrece diversos servicios y"},"ar":{"item_counter_value":"3.0000","item_title":"\\u0627\\u0633\\u062a\\u0643\\u0634\\u0641 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627","item_description":"\\u064a\\u0645\\u0643\\u0646\\u0643 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0635\\u0627\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u0631\\u0641\\u064a\\u0639\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062a\\u064a \\u062a\\u0642\\u062f\\u0645 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629 \\u0648\\u062e\\u0628\\u0631\\u0629 \\u0644\\u0627 \\u0645\\u062b\\u064a\\u0644 \\u0644\\u0647\\u0627 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621."}},"id":"672cb9783a30e"},"672cb9a86d7e6":{"language":{"en":{"item_counter_value":"90000.0000","item_title":"Total User","item_description":"Join thousands of users enjoying our services. Discover part of our thriving platform today!"},"fr":{"item_counter_value":"90.0000","item_title":"Utilisateur total","item_description":"Acc\\u00e9dez sans effort \\u00e0 un salon de premier plan offrant des services diversifi\\u00e9s et une"},"es":{"item_counter_value":"90.0000","item_title":"Usuario total","item_description":"\\u00danete a miles de usuarios disfrutando de nuestros servicios. \\u00a1Descubra parte"},"ar":{"item_counter_value":"90.0000","item_title":"\\u0625\\u062c\\u0645\\u0627\\u0644\\u064a \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645","item_description":"\\u0627\\u0646\\u0636\\u0645 \\u0625\\u0644\\u0649 \\u0622\\u0644\\u0627\\u0641 \\u0627\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u0627\\u0644\\u0630\\u064a\\u0646 \\u064a\\u0633\\u062a\\u0645\\u062a\\u0639\\u0648\\u0646 \\u0628\\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627. \\u0627\\u0643\\u062a\\u0634\\u0641 \\u062c\\u0632\\u0621\\u064b\\u0627 \\u0645\\u0646 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0645\\u0632\\u062f\\u0647\\u0631\\u0629 \\u0627\\u0644\\u064a\\u0648\\u0645!"}},"id":"672cb9a86d7e6"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-07 12:58:06','updated_at' => '2025-01-06 22:27:41'),
            array('id' => '8','key' => 'download-app','value' => '{"image":"a268aeb4-4a45-46a5-9083-f9f2ae535f3a.webp","language":{"en":{"heading":"App Download","sub_heading":"Our app offers hassle-free salon bookings, exclusive deals, personalized recommendations, and seamless access to diverse services. Elevate your experience with ease\\u2014browse, book, and indulge in premium Parlor treatments at your convenience. Unlock special offers, track appointments, and discover trending styles effortlessly. With a user-friendly interface, the app ensures a tailored experience, catering to your preferences while delivering unparalleled convenience."},"fr":{"heading":"Application Dawonload","sub_heading":"Notre application propose des r\\u00e9servations de salons sans tracas, des offres exclusives, des recommandations personnalis\\u00e9es et un acc\\u00e8s transparent \\u00e0 divers services. Am\\u00e9liorez facilement votre exp\\u00e9rience\\u00a0: parcourez, r\\u00e9servez et profitez de soins de salon haut de gamme \\u00e0 votre convenance. D\\u00e9bloquez des offres sp\\u00e9ciales, suivez les rendez-vous et d\\u00e9couvrez les styles tendance sans effort. Avec une interface conviviale, l\'application garantit une exp\\u00e9rience sur mesure, r\\u00e9pondant \\u00e0 vos pr\\u00e9f\\u00e9rences tout en offrant une commodit\\u00e9 in\\u00e9gal\\u00e9e."},"es":{"heading":"Aplicaci\\u00f3n Dawonload","sub_heading":"Nuestra aplicaci\\u00f3n ofrece reservas de salones sin complicaciones, ofertas exclusivas, recomendaciones personalizadas y acceso perfecto a diversos servicios. Mejore su experiencia con facilidad: navegue, reserve y disfrute de tratamientos de sal\\u00f3n premium a su conveniencia. Desbloquee ofertas especiales, realice un seguimiento de citas y descubra estilos de moda sin esfuerzo. Con una interfaz f\\u00e1cil de usar, la aplicaci\\u00f3n garantiza una experiencia personalizada, que se adapta a sus preferencias y ofrece una comodidad incomparable."},"ar":{"heading":"\\u062a\\u062d\\u0645\\u064a\\u0644 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642","sub_heading":"\\u064a\\u0642\\u062f\\u0645 \\u062a\\u0637\\u0628\\u064a\\u0642\\u0646\\u0627 \\u062d\\u062c\\u0648\\u0632\\u0627\\u062a \\u0635\\u0627\\u0644\\u0629 \\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628\\u060c \\u0648\\u0639\\u0631\\u0648\\u0636\\u064b\\u0627 \\u062d\\u0635\\u0631\\u064a\\u0629\\u060c \\u0648\\u062a\\u0648\\u0635\\u064a\\u0627\\u062a \\u0634\\u062e\\u0635\\u064a\\u0629\\u060c \\u0648\\u0648\\u0635\\u0648\\u0644\\u0627\\u064b \\u0633\\u0644\\u0633\\u064b\\u0627 \\u0625\\u0644\\u0649 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u062a\\u0646\\u0648\\u0639\\u0629. \\u0627\\u0631\\u0641\\u0639 \\u0645\\u0633\\u062a\\u0648\\u0649 \\u062a\\u062c\\u0631\\u0628\\u062a\\u0643 \\u0628\\u0643\\u0644 \\u0633\\u0647\\u0648\\u0644\\u0629 - \\u062a\\u0635\\u0641\\u062d \\u0648\\u0627\\u062d\\u062c\\u0632 \\u0648\\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0639\\u0644\\u0627\\u062c\\u0627\\u062a Parlor \\u0627\\u0644\\u0645\\u062a\\u0645\\u064a\\u0632\\u0629 \\u0641\\u064a \\u0627\\u0644\\u0648\\u0642\\u062a \\u0627\\u0644\\u0630\\u064a \\u064a\\u0646\\u0627\\u0633\\u0628\\u0643. \\u0627\\u0641\\u062a\\u062d \\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0648\\u062a\\u062a\\u0628\\u0639 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0648\\u0627\\u0643\\u062a\\u0634\\u0641 \\u0627\\u0644\\u0623\\u0646\\u0645\\u0627\\u0637 \\u0627\\u0644\\u0634\\u0627\\u0626\\u0639\\u0629 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621. \\u0628\\u0641\\u0636\\u0644 \\u0648\\u0627\\u062c\\u0647\\u0629 \\u0633\\u0647\\u0644\\u0629 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645\\u060c \\u064a\\u0636\\u0645\\u0646 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u0645\\u062e\\u0635\\u0635\\u0629 \\u062a\\u0644\\u0628\\u064a \\u062a\\u0641\\u0636\\u064a\\u0644\\u0627\\u062a\\u0643 \\u0645\\u0639 \\u062a\\u0648\\u0641\\u064a\\u0631 \\u0631\\u0627\\u062d\\u0629 \\u0644\\u0627 \\u0645\\u062b\\u064a\\u0644 \\u0644\\u0647\\u0627."}},"items":{"672d85ee7e1c0":{"language":{"en":{"item_title":"Android","item_heading":"Google Play"},"fr":{"item_title":"Andro\\u00efde","item_heading":"GooglePlay"},"es":{"item_title":"Androide","item_heading":"Google\\u00a0Play"},"ar":{"item_title":"\\u0623\\u0646\\u062f\\u0631\\u0648\\u064a\\u062f","item_heading":"\\u062c\\u0648\\u062c\\u0644 \\u0628\\u0644\\u0627\\u064a"}},"id":"672d85ee7e1c0","image":"b7d22a84-1994-4875-af9a-1f70180df6f0.webp","link":"https:\\/\\/www.google.com\\/","icon":"fab fa-google-play","created_at":"2024-11-08T03:30:54.531316Z"},"677bab50aa7a7":{"language":{"en":{"item_title":"iOS","item_heading":"App Store"},"fr":{"item_title":"iOS","item_heading":"Magasin d\'applications"},"es":{"item_title":"iOS","item_heading":"Tienda de aplicaciones"},"ar":{"item_title":"\\u062f\\u0627\\u0626\\u0631\\u0629 \\u0627\\u0644\\u0631\\u0642\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0627\\u062e\\u0644\\u064a\\u0629","item_heading":"\\u0645\\u062a\\u062c\\u0631 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642\\u0627\\u062a"}},"id":"677bab50aa7a7","image":"e30099c5-a00e-4872-a269-fc1ed182d623.webp","link":"https:\\/\\/www.apple.com\\/app-store","icon":"fab fa-apple","created_at":"2025-01-06T10:07:12.708511Z"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 03:29:02','updated_at' => '2025-01-06 22:25:53'),
            array('id' => '9','key' => 'vendor-banner-section','value' => '{"image":"f07435b9-6c06-4078-bc83-7c96cdf6cd6e.webp","language":{"en":{"heading":"Promote Your Services - Partner with SalonHub Now!","sub_heading":"Showcase your salon, spa, or beauty services on our platform to reach a wider audience and grow your business. Join us today to boost your visibility, attract new customers, and unlock exciting opportunities","button":"Join as a Vendor"},"fr":{"heading":"Faites la promotion de vos services - Devenez partenaire de SalonHub d\\u00e8s maintenant\\u00a0!","sub_heading":"Annoncez votre salon, spa ou produits de beaut\\u00e9 sur notre plateforme pour vous connecter avec notre client\\u00e8le et d\\u00e9velopper votre entreprise. Rejoignez-nous aujourd\'hui pour une visibilit\\u00e9 accrue et de nouvelles opportunit\\u00e9s.","button":"S\'inscrire \\u00e0 Barbar"},"es":{"heading":"Promocione sus servicios: \\u00a1as\\u00f3ciese con SalonHub ahora!","sub_heading":"Muestre su sal\\u00f3n, spa o servicios de belleza en nuestra plataforma para llegar a una audiencia m\\u00e1s amplia y hacer crecer su negocio. \\u00danase a nosotros hoy para aumentar su visibilidad, atraer nuevos clientes y desbloquear oportunidades interesantes.","button":"\\u00danase como vendedor"},"ar":{"heading":"\\u0631\\u0648\\u0651\\u062c \\u0644\\u062e\\u062f\\u0645\\u0627\\u062a\\u0643 - \\u0627\\u0634\\u062a\\u0631\\u0643 \\u0645\\u0639 SalonHub \\u0627\\u0644\\u0622\\u0646!","sub_heading":"\\u0627\\u0639\\u0631\\u0636 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639 \\u0627\\u0644\\u0635\\u062d\\u064a \\u0623\\u0648 \\u0627\\u0644\\u062a\\u062c\\u0645\\u064a\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u0639\\u0644\\u0649 \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0644\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u062c\\u0645\\u0647\\u0648\\u0631 \\u0623\\u0648\\u0633\\u0639 \\u0648\\u062a\\u0646\\u0645\\u064a\\u0629 \\u0623\\u0639\\u0645\\u0627\\u0644\\u0643. \\u0627\\u0646\\u0636\\u0645 \\u0625\\u0644\\u064a\\u0646\\u0627 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0644\\u062a\\u0639\\u0632\\u064a\\u0632 \\u0638\\u0647\\u0648\\u0631\\u0643 \\u0648\\u062c\\u0630\\u0628 \\u0639\\u0645\\u0644\\u0627\\u0621 \\u062c\\u062f\\u062f \\u0648\\u0641\\u062a\\u062d \\u0627\\u0644\\u0641\\u0631\\u0635 \\u0627\\u0644\\u0645\\u062b\\u064a\\u0631\\u0629","button":"\\u0627\\u0646\\u0636\\u0645 \\u0643\\u0628\\u0627\\u0626\\u0639"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 04:50:21','updated_at' => '2025-01-06 17:21:45'),
            array('id' => '10','key' => 'vendor-features-section','value' => '{"language":{"en":{"section_title":"Vendor Features","heading":"Empowering Your Business with Exceptional Features","sub_heading":"At SalonHub, we equip you with everything needed to grow your salon or spa business. Simplify operations, attract customers, and manage your services effortlessly with innovative tools designed with you in mind."},"fr":{"section_title":"Caract\\u00e9ristiques du fournisseur","heading":"Renforcez votre entreprise avec des fonctionnalit\\u00e9s exceptionnelles","sub_heading":"Chez SalonHub, nous vous fournissons tout ce dont vous avez besoin pour d\\u00e9velopper votre entreprise de salon ou de spa. Simplifiez vos op\\u00e9rations, attirez des clients et g\\u00e9rez vos services sans effort gr\\u00e2ce \\u00e0 des outils innovants con\\u00e7us pour vous."},"es":{"section_title":"Caracter\\u00edsticas del proveedor","heading":"Potenciando su negocio con caracter\\u00edsticas excepcionales","sub_heading":"En SalonHub, te equipamos con todo lo necesario para hacer crecer tu negocio de sal\\u00f3n o spa. Simplifique las operaciones, atraiga clientes y administre sus servicios sin esfuerzo con herramientas innovadoras dise\\u00f1adas pensando en usted."},"ar":{"section_title":"\\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639","heading":"\\u062a\\u0645\\u0643\\u064a\\u0646 \\u0639\\u0645\\u0644\\u0643 \\u0628\\u0645\\u064a\\u0632\\u0627\\u062a \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u0626\\u064a\\u0629","sub_heading":"\\u0641\\u064a SalonHub\\u060c \\u0646\\u0642\\u0648\\u0645 \\u0628\\u062a\\u062c\\u0647\\u064a\\u0632\\u0643 \\u0628\\u0643\\u0644 \\u0645\\u0627 \\u062a\\u062d\\u062a\\u0627\\u062c\\u0647 \\u0644\\u062a\\u0646\\u0645\\u064a\\u0629 \\u0623\\u0639\\u0645\\u0627\\u0644\\u0643 \\u0641\\u064a \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0623\\u0648 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639 \\u0627\\u0644\\u0635\\u062d\\u064a. \\u0642\\u0645 \\u0628\\u062a\\u0628\\u0633\\u064a\\u0637 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0627\\u062a\\u060c \\u0648\\u062c\\u0630\\u0628 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621\\u060c \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0643 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0627\\u0644\\u0623\\u062f\\u0648\\u0627\\u062a \\u0627\\u0644\\u0645\\u0628\\u062a\\u0643\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u062e\\u0635\\u064a\\u0635\\u064b\\u0627 \\u0644\\u0643."}},"items":{"672d99cf7ee4b":{"language":{"en":{"title":"Set your own hours","description":"Take full control of your schedule and manage your working hours effortlessly to align with your preferences and clients\' needs."},"fr":{"title":"D\\u00e9finissez vos propres horaires","description":"Prenez le contr\\u00f4le total de votre emploi du temps et g\\u00e9rez vos heures de travail sans effort pour vous aligner sur vos pr\\u00e9f\\u00e9rences et les besoins de vos clients."},"es":{"title":"Establece tu propio horario","description":"Tome el control total de su agenda y administre sus horas de trabajo sin esfuerzo para alinearlas con sus preferencias y necesidades de los clientes."},"ar":{"title":"\\u062d\\u062f\\u062f \\u0633\\u0627\\u0639\\u0627\\u062a\\u0643 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629","description":"\\u062a\\u062d\\u0643\\u0645 \\u0628\\u0634\\u0643\\u0644 \\u0643\\u0627\\u0645\\u0644 \\u0641\\u064a \\u062c\\u062f\\u0648\\u0644\\u0643 \\u0627\\u0644\\u0632\\u0645\\u0646\\u064a \\u0648\\u0642\\u0645 \\u0628\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0633\\u0627\\u0639\\u0627\\u062a \\u0627\\u0644\\u0639\\u0645\\u0644 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643 \\u062f\\u0648\\u0646 \\u0639\\u0646\\u0627\\u0621 \\u0644\\u062a\\u062a\\u0648\\u0627\\u0641\\u0642 \\u0645\\u0639 \\u062a\\u0641\\u0636\\u064a\\u0644\\u0627\\u062a\\u0643 \\u0648\\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a \\u0639\\u0645\\u0644\\u0627\\u0626\\u0643."}},"id":"672d99cf7ee4b"},"672d99e026c1e":{"language":{"en":{"title":"Get paid fast","description":"Enjoy fast and secure payments with multiple payment gateway options, ensuring hassle-free transactions every time."},"fr":{"title":"Soyez pay\\u00e9 rapidement","description":"Profitez de paiements rapides et s\\u00e9curis\\u00e9s avec plusieurs options de passerelle de paiement, garantissant des transactions sans tracas \\u00e0 chaque fois."},"es":{"title":"Recibe tu pago r\\u00e1pido","description":"Disfrute de pagos r\\u00e1pidos y seguros con m\\u00faltiples opciones de pasarela de pago, lo que garantiza transacciones sin complicaciones en todo momento."},"ar":{"title":"\\u0627\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u0623\\u0645\\u0648\\u0627\\u0644 \\u0628\\u0633\\u0631\\u0639\\u0629","description":"\\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0633\\u0631\\u064a\\u0639\\u0629 \\u0648\\u0622\\u0645\\u0646\\u0629 \\u0645\\u0639 \\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0628\\u0648\\u0627\\u0628\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0645\\u062a\\u0639\\u062f\\u062f\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0636\\u0645\\u0646 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0645\\u0639\\u0627\\u0645\\u0644\\u0627\\u062a \\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0645\\u062a\\u0627\\u0639\\u0628 \\u0641\\u064a \\u0643\\u0644 \\u0645\\u0631\\u0629."}},"id":"672d99e026c1e"},"677bbefb19a15":{"language":{"en":{"title":"Showcase Your Services","description":"Highlight your salon\\u2019s unique offerings with tailored service listings, attracting more customers and expanding your reach."},"fr":{"title":"Pr\\u00e9sentez vos services","description":"Mettez en valeur les offres uniques de votre salon avec des listes de services sur mesure, attirant plus de clients et \\u00e9largissant votre port\\u00e9e."},"es":{"title":"Muestre sus servicios","description":"Resalte las ofertas \\u00fanicas de su sal\\u00f3n con listados de servicios personalizados, atrayendo m\\u00e1s clientes y ampliando su alcance."},"ar":{"title":"\\u0627\\u0639\\u0631\\u0636 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0643","description":"\\u0642\\u0645 \\u0628\\u062a\\u0633\\u0644\\u064a\\u0637 \\u0627\\u0644\\u0636\\u0648\\u0621 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u0639\\u0631\\u0648\\u0636 \\u0627\\u0644\\u0641\\u0631\\u064a\\u062f\\u0629 \\u0627\\u0644\\u062a\\u064a \\u064a\\u0642\\u062f\\u0645\\u0647\\u0627 \\u0635\\u0627\\u0644\\u0648\\u0646\\u0643 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0642\\u0648\\u0627\\u0626\\u0645 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u062e\\u0635\\u0635\\u0629\\u060c \\u0645\\u0645\\u0627 \\u064a\\u0624\\u062f\\u064a \\u0625\\u0644\\u0649 \\u062c\\u0630\\u0628 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0648\\u062a\\u0648\\u0633\\u064a\\u0639 \\u0646\\u0637\\u0627\\u0642 \\u0648\\u0635\\u0648\\u0644\\u0643."}},"id":"677bbefb19a15"},"677bbf3067599":{"language":{"en":{"title":"Dedicated Dashboard","description":"Access a powerful vendor dashboard to manage bookings, staff, and customer requests seamlessly from one place."},"fr":{"title":"Tableau de bord d\\u00e9di\\u00e9","description":"Acc\\u00e9dez \\u00e0 un puissant tableau de bord des fournisseurs pour g\\u00e9rer les r\\u00e9servations, le personnel et les demandes des clients de mani\\u00e8re transparente \\u00e0 partir d\'un seul endroit."},"es":{"title":"Panel de control dedicado","description":"Acceda a un potente panel de proveedores para gestionar reservas, personal y solicitudes de clientes sin problemas desde un solo lugar."},"ar":{"title":"\\u0644\\u0648\\u062d\\u0629 \\u062a\\u062d\\u0643\\u0645 \\u0645\\u062e\\u0635\\u0635\\u0629","description":"\\u0642\\u0645 \\u0628\\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0644\\u0648\\u062d\\u0629 \\u0645\\u0639\\u0644\\u0648\\u0645\\u0627\\u062a \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639 \\u0627\\u0644\\u0642\\u0648\\u064a\\u0629 \\u0644\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u062d\\u062c\\u0648\\u0632\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0648\\u0638\\u0641\\u064a\\u0646 \\u0648\\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629 \\u0645\\u0646 \\u0645\\u0643\\u0627\\u0646 \\u0648\\u0627\\u062d\\u062f."}},"id":"677bbf3067599"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 04:55:28','updated_at' => '2025-01-06 17:32:00'),
            array('id' => '11','key' => 'about-us-section','value' => '{"image":"37f7fb2a-f670-46b7-b054-9f90247dac8c.webp","language":{"en":{"title":"About Our SalonHub","heading":"Unveiling the Essence of Beauty with SalonHub.","sub_heading":"Welcome to SalonHub, where beauty meets innovation. Our cutting-edge platform is dedicated to revolutionizing salon and spa experiences. Whether you\'re a user looking for exceptional beauty services, a vendor managing multiple parlors, or a manager organizing staff and requests, SalonHub simplifies and enhances your journey. With a focus on personalization and convenience, SalonHub provides seamless booking, secure payments, and expert-managed beauty services\\u2014all in one place. Transform your beauty experience today and enjoy the luxury of top-tier services tailored just for you."},"fr":{"title":"\\u00c0 propos de notre SalonHub","heading":"D\\u00e9voiler l\'essence de la beaut\\u00e9 avec SalonHub.","sub_heading":"Bienvenido a SalonHub, donde la belleza se encuentra con la innovaci\\u00f3n. Nuestra plataforma de vanguardia est\\u00e1 dedicada a revolucionar las experiencias de sal\\u00f3n y spa. Ya sea que sea un usuario que busca servicios de belleza excepcionales, un proveedor que administra varios salones o un gerente que organiza el personal y las solicitudes, SalonHub simplifica y mejora su viaje. Centr\\u00e1ndose en la personalizaci\\u00f3n y la conveniencia, SalonHub ofrece reservas fluidas, pagos seguros y servicios de belleza administrados por expertos, todo en un solo lugar. Transforme su experiencia de belleza hoy y disfrute del lujo de servicios de primer nivel dise\\u00f1ados solo para usted."},"es":{"title":"Acerca de nuestro sal\\u00f3nHub","heading":"Revelando la esencia de la belleza con SalonHub.","sub_heading":"Bienvenido a SalonHub, donde la belleza se encuentra con la innovaci\\u00f3n. Nuestra revolucionaria plataforma ofrece una nueva era de cuidado del cabello personalizado. A trav\\u00e9s de consultas virtuales, nuestros estilistas expertos elaboran f\\u00f3rmulas y reg\\u00edmenes de color personalizados, adaptados precisamente a sus preferencias y necesidades. Experimente el lujo de transformaciones con calidad de sal\\u00f3n en la comodidad de su propio espacio. Lorem ipsum dolor sit amet consectetur adipisicing elit. Ipsam expedita delectus enim sint laboriosam facere voluptatum impedit temporibus illum sed!"},"ar":{"title":"\\u062d\\u0648\\u0644 \\u0635\\u0627\\u0644\\u0648\\u0646\\u0646\\u0627 Hub","heading":"\\u0627\\u0644\\u0643\\u0634\\u0641 \\u0639\\u0646 \\u062c\\u0648\\u0647\\u0631 \\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u0645\\u0639 SalonHub.","sub_heading":"\\u0645\\u0631\\u062d\\u0628\\u064b\\u0627 \\u0628\\u0643 \\u0641\\u064a SalonHub\\u060c \\u062d\\u064a\\u062b \\u064a\\u0644\\u062a\\u0642\\u064a \\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u0628\\u0627\\u0644\\u0627\\u0628\\u062a\\u0643\\u0627\\u0631. \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0645\\u062a\\u0637\\u0648\\u0631\\u0629 \\u0645\\u062e\\u0635\\u0635\\u0629 \\u0644\\u0625\\u062d\\u062f\\u0627\\u062b \\u062b\\u0648\\u0631\\u0629 \\u0641\\u064a \\u062a\\u062c\\u0627\\u0631\\u0628 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639\\u0627\\u062a \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064b\\u0627 \\u064a\\u0628\\u062d\\u062b \\u0639\\u0646 \\u062e\\u062f\\u0645\\u0627\\u062a \\u062a\\u062c\\u0645\\u064a\\u0644 \\u0627\\u0633\\u062a\\u062b\\u0646\\u0627\\u0626\\u064a\\u0629\\u060c \\u0623\\u0648 \\u0628\\u0627\\u0626\\u0639\\u064b\\u0627 \\u064a\\u062f\\u064a\\u0631 \\u0635\\u0627\\u0644\\u0627\\u062a \\u0645\\u062a\\u0639\\u062f\\u062f\\u0629\\u060c \\u0623\\u0648 \\u0645\\u062f\\u064a\\u0631\\u064b\\u0627 \\u064a\\u0646\\u0638\\u0645 \\u0627\\u0644\\u0645\\u0648\\u0638\\u0641\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0637\\u0644\\u0628\\u0627\\u062a\\u060c \\u0641\\u0625\\u0646 SalonHub \\u064a\\u0628\\u0633\\u0637 \\u0631\\u062d\\u0644\\u062a\\u0643 \\u0648\\u064a\\u0639\\u0632\\u0632\\u0647\\u0627. \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0631\\u0643\\u064a\\u0632 \\u0639\\u0644\\u0649 \\u0627\\u0644\\u062a\\u062e\\u0635\\u064a\\u0635 \\u0648\\u0627\\u0644\\u0631\\u0627\\u062d\\u0629\\u060c \\u064a\\u0648\\u0641\\u0631 SalonHub \\u0627\\u0644\\u062d\\u062c\\u0632 \\u0627\\u0644\\u0633\\u0644\\u0633 \\u0648\\u0627\\u0644\\u0645\\u062f\\u0641\\u0648\\u0639\\u0627\\u062a \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0648\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0645\\u064a\\u0644 \\u0627\\u0644\\u062a\\u064a \\u064a\\u062f\\u064a\\u0631\\u0647\\u0627 \\u0627\\u0644\\u062e\\u0628\\u0631\\u0627\\u0621 - \\u0643\\u0644 \\u0630\\u0644\\u0643 \\u0641\\u064a \\u0645\\u0643\\u0627\\u0646 \\u0648\\u0627\\u062d\\u062f. \\u063a\\u064a\\u0651\\u0631 \\u062a\\u062c\\u0631\\u0628\\u0629 \\u062c\\u0645\\u0627\\u0644\\u0643 \\u0627\\u0644\\u064a\\u0648\\u0645 \\u0648\\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0631\\u0641\\u0627\\u0647\\u064a\\u0629 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u062e\\u0635\\u064a\\u0635\\u064b\\u0627 \\u0644\\u0643."}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 05:04:22','updated_at' => '2025-01-06 16:09:15'),
            array('id' => '12','key' => 'faq','value' => '{"language":{"en":{"title":"FAQ Section","heading":"If you got questions we have answer."},"fr":{"title":"Section FAQ","heading":"Si vous avez des questions, nous avons la r\\u00e9ponse."},"es":{"title":"Secci\\u00f3n de preguntas frecuentes","heading":"Si tiene preguntas, tenemos respuesta."},"ar":{"title":"\\u0642\\u0633\\u0645 \\u0627\\u0644\\u0623\\u0633\\u0626\\u0644\\u0629 \\u0627\\u0644\\u0634\\u0627\\u0626\\u0639\\u0629","heading":"\\u0625\\u0630\\u0627 \\u0643\\u0627\\u0646 \\u0644\\u062f\\u064a\\u0643 \\u0623\\u0633\\u0626\\u0644\\u0629 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0627\\u0644\\u0625\\u062c\\u0627\\u0628\\u0629."}},"items":{"672d9c2ac0af1":{"language":{"en":{"question":"How do I book a salon appointment on SalonHub?","answer":"Booking a service is easy! Simply browse through the salons and spas available on SalonHub, choose the services you prefer, select your preferred salon, and schedule an appointment. You can complete the process effortlessly with just a few clicks!"},"fr":{"question":"Comment prendre rendez-vous au salon sur SalonHub\\u00a0?","answer":"R\\u00e9server un service, c\'est simple ! Parcourez simplement les salons et spas disponibles sur SalonHub, choisissez les services que vous pr\\u00e9f\\u00e9rez, s\\u00e9lectionnez votre salon pr\\u00e9f\\u00e9r\\u00e9 et prenez rendez-vous. Vous pouvez terminer le processus sans effort en quelques clics\\u00a0!"},"es":{"question":"\\u00bfC\\u00f3mo reservo una cita en el sal\\u00f3n en SalonHub?","answer":"\\u00a1Reservar un servicio es f\\u00e1cil! Simplemente navegue por los salones y spas disponibles en SalonHub, elija los servicios que prefiera, seleccione su sal\\u00f3n preferido y programe una cita. \\u00a1Puedes completar el proceso sin esfuerzo con solo unos pocos clics!"},"ar":{"question":"\\u0643\\u064a\\u0641 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u062d\\u062c\\u0632 \\u0645\\u0648\\u0639\\u062f \\u0641\\u064a \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0639\\u0644\\u0649 SalonHub\\u061f","answer":"\\u062d\\u062c\\u0632 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0633\\u0647\\u0644! \\u0645\\u0627 \\u0639\\u0644\\u064a\\u0643 \\u0633\\u0648\\u0649 \\u062a\\u0635\\u0641\\u062d \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a \\u0648\\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0639\\u0627\\u062a \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0627\\u0644\\u0645\\u062a\\u0648\\u0641\\u0631\\u0629 \\u0639\\u0644\\u0649 SalonHub\\u060c \\u0648\\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u062a\\u0641\\u0636\\u0644\\u0647\\u0627\\u060c \\u0648\\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644 \\u0644\\u062f\\u064a\\u0643\\u060c \\u0648\\u062a\\u062d\\u062f\\u064a\\u062f \\u0645\\u0648\\u0639\\u062f. \\u064a\\u0645\\u0643\\u0646\\u0643 \\u0625\\u0643\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0639\\u0645\\u0644\\u064a\\u0629 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0628\\u0628\\u0636\\u0639 \\u0646\\u0642\\u0631\\u0627\\u062a \\u0641\\u0642\\u0637!"}},"status":1,"id":"672d9c2ac0af1"},"672d9c3868dda":{"language":{"en":{"question":"Can I join SalonHub as a Vendor?","answer":"Yes! Vendors can register and manage their salons or spas on SalonHub. You\'ll be able to add your parlors, assign managers, and offer a wide range of beauty services to users. Get started by creating a Vendor account today."},"fr":{"question":"Puis-je rejoindre SalonHub en tant que vendeur\\u00a0?","answer":"Oui! Les vendeurs peuvent enregistrer et g\\u00e9rer leurs salons ou spas sur SalonHub. Vous pourrez ajouter vos salons, affecter des gestionnaires et proposer une large gamme de services de beaut\\u00e9 aux utilisateurs. Commencez d\\u00e8s aujourd\\u2019hui en cr\\u00e9ant un compte fournisseur."},"es":{"question":"\\u00bfPuedo unirme a SalonHub como proveedor?","answer":"\\u00a1S\\u00ed! Los proveedores pueden registrarse y administrar sus salones o spas en SalonHub. Podr\\u00e1s agregar tus salones, asignar gerentes y ofrecer una amplia gama de servicios de belleza a los usuarios. Comience creando una cuenta de proveedor hoy."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u0644\\u0627\\u0646\\u0636\\u0645\\u0627\\u0645 \\u0625\\u0644\\u0649 SalonHub \\u0643\\u0628\\u0627\\u0626\\u0639\\u061f","answer":"\\u0646\\u0639\\u0645! \\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0628\\u0627\\u0626\\u0639\\u064a\\u0646 \\u062a\\u0633\\u062c\\u064a\\u0644 \\u0648\\u0625\\u062f\\u0627\\u0631\\u0629 \\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a\\u0647\\u0645 \\u0623\\u0648 \\u0645\\u0646\\u062a\\u062c\\u0639\\u0627\\u062a\\u0647\\u0645 \\u0627\\u0644\\u0635\\u062d\\u064a\\u0629 \\u0639\\u0644\\u0649 SalonHub. \\u0633\\u062a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0625\\u0636\\u0627\\u0641\\u0629 \\u0635\\u0627\\u0644\\u0627\\u062a\\u0643 \\u0648\\u062a\\u0639\\u064a\\u064a\\u0646 \\u0645\\u062f\\u064a\\u0631\\u064a\\u0646 \\u0648\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0648\\u0627\\u0633\\u0639\\u0629 \\u0645\\u0646 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u062c\\u0645\\u064a\\u0644 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646. \\u0627\\u0628\\u062f\\u0623 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628 \\u0628\\u0627\\u0626\\u0639 \\u0627\\u0644\\u064a\\u0648\\u0645."}},"status":1,"id":"672d9c3868dda"},"677badb3ba94a":{"language":{"en":{"question":"Do I need an account to book a service?","answer":"Users can book a service with a guest account. However, creating an account allows you to track appointments, receive personalized recommendations, and unlock exclusive deals."},"fr":{"question":"Ai-je besoin d\\u2019un compte pour r\\u00e9server un service ?","answer":"Les utilisateurs peuvent r\\u00e9server un service avec un compte invit\\u00e9. Cependant, la cr\\u00e9ation d\'un compte vous permet de suivre les rendez-vous, de recevoir des recommandations personnalis\\u00e9es et de d\\u00e9bloquer des offres exclusives."},"es":{"question":"\\u00bfNecesito una cuenta para reservar un servicio?","answer":"Los usuarios pueden reservar un servicio con una cuenta de invitado. Sin embargo, crear una cuenta le permite realizar un seguimiento de las citas, recibir recomendaciones personalizadas y desbloquear ofertas exclusivas."},"ar":{"question":"\\u0647\\u0644 \\u0623\\u062d\\u062a\\u0627\\u062c \\u0625\\u0644\\u0649 \\u062d\\u0633\\u0627\\u0628 \\u0644\\u062d\\u062c\\u0632 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629\\u061f","answer":"\\u064a\\u0645\\u0643\\u0646 \\u0644\\u0644\\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064a\\u0646 \\u062d\\u062c\\u0632 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0628\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u062d\\u0633\\u0627\\u0628 \\u0627\\u0644\\u0636\\u064a\\u0641. \\u0648\\u0645\\u0639 \\u0630\\u0644\\u0643\\u060c \\u0641\\u0625\\u0646 \\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628 \\u064a\\u0633\\u0645\\u062d \\u0644\\u0643 \\u0628\\u062a\\u062a\\u0628\\u0639 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0648\\u062a\\u0644\\u0642\\u064a \\u062a\\u0648\\u0635\\u064a\\u0627\\u062a \\u0645\\u062e\\u0635\\u0635\\u0629 \\u0648\\u0641\\u062a\\u062d \\u0627\\u0644\\u0635\\u0641\\u0642\\u0627\\u062a \\u0627\\u0644\\u062d\\u0635\\u0631\\u064a\\u0629."}},"status":1,"id":"677badb3ba94a"},"677badff0b93f":{"language":{"en":{"question":"How do payments work on SalonHub?","answer":"Payments on SalonHub can be made either through online payment gateways like PayPal, Stripe, and others, or in cash when you visit the salon. Choose the most convenient payment method for you at checkout."},"fr":{"question":"Comment fonctionnent les paiements sur SalonHub ?","answer":"\\"Les paiements sur SalonHub peuvent \\u00eatre effectu\\u00e9s soit via des passerelles de paiement en ligne comme PayPal, Stripe et autres, soit en esp\\u00e8ces lorsque vous visitez le salon. Choisissez le mode de paiement le plus pratique pour vous lors du paiement.\\r\\n\\""},"es":{"question":"\\u00bfC\\u00f3mo funcionan los pagos en SalonHub?","answer":"\\"Los pagos en SalonHub se pueden realizar a trav\\u00e9s de pasarelas de pago en l\\u00ednea como PayPal, Stripe y otras, o en efectivo cuando visita el sal\\u00f3n. Elija el m\\u00e9todo de pago que m\\u00e1s le convenga al finalizar la compra.\\r\\n\\""},"ar":{"question":"\\u0643\\u064a\\u0641 \\u062a\\u0639\\u0645\\u0644 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0639\\u0644\\u0649 SalonHub\\u061f","answer":"\\"\\u064a\\u0645\\u0643\\u0646 \\u0625\\u062c\\u0631\\u0627\\u0621 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0639\\u0644\\u0649 SalonHub \\u0625\\u0645\\u0627 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0628\\u0648\\u0627\\u0628\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0639\\u0628\\u0631 \\u0627\\u0644\\u0625\\u0646\\u062a\\u0631\\u0646\\u062a \\u0645\\u062b\\u0644 PayPal \\u0648Stripe \\u0648\\u063a\\u064a\\u0631\\u0647\\u0627\\u060c \\u0623\\u0648 \\u0646\\u0642\\u062f\\u064b\\u0627 \\u0639\\u0646\\u062f \\u0632\\u064a\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646. \\u0627\\u062e\\u062a\\u0631 \\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0623\\u0643\\u062b\\u0631 \\u0645\\u0644\\u0627\\u0621\\u0645\\u0629 \\u0644\\u0643 \\u0639\\u0646\\u062f \\u0627\\u0644\\u062e\\u0631\\u0648\\u062c.\\r\\n\\""}},"status":1,"id":"677badff0b93f"},"677bae4a41d69":{"language":{"en":{"question":"Can I choose my preferred stylist for a service?","answer":"Yes! Once a service request is accepted by a manager, you may be able to request a specific staff member for your service, provided the salon allows this option. You can confirm the assignment with the salon when booking."},"fr":{"question":"Puis-je choisir mon styliste pr\\u00e9f\\u00e9r\\u00e9 pour un service ?","answer":"Oui! Une fois qu\'une demande de service est accept\\u00e9e par un responsable, vous pourrez peut-\\u00eatre demander \\u00e0 un membre du personnel sp\\u00e9cifique pour votre service, \\u00e0 condition que le salon autorise cette option. Vous pouvez confirmer la mission aupr\\u00e8s du salon lors de la r\\u00e9servation."},"es":{"question":"\\u00bfPuedo elegir mi estilista preferido para un servicio?","answer":"\\u00a1S\\u00ed! Una vez que un gerente acepta una solicitud de servicio, es posible que pueda solicitar un miembro del personal espec\\u00edfico para su servicio, siempre que el sal\\u00f3n permita esta opci\\u00f3n. Puedes confirmar la asignaci\\u00f3n con el sal\\u00f3n al realizar la reserva."},"ar":{"question":"\\u0647\\u0644 \\u064a\\u0645\\u0643\\u0646\\u0646\\u064a \\u0627\\u062e\\u062a\\u064a\\u0627\\u0631 \\u0645\\u0635\\u0641\\u0641 \\u0627\\u0644\\u0634\\u0639\\u0631 \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644 \\u0644\\u062f\\u064a \\u0644\\u0644\\u062d\\u0635\\u0648\\u0644 \\u0639\\u0644\\u0649 \\u062e\\u062f\\u0645\\u0629 \\u0645\\u0627\\u061f","answer":"\\u0646\\u0639\\u0645! \\u0628\\u0645\\u062c\\u0631\\u062f \\u0642\\u0628\\u0648\\u0644 \\u0637\\u0644\\u0628 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0645\\u062f\\u064a\\u0631\\u060c \\u0642\\u062f \\u062a\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0637\\u0644\\u0628 \\u0645\\u0648\\u0638\\u0641 \\u0645\\u0639\\u064a\\u0646 \\u0644\\u062e\\u062f\\u0645\\u062a\\u0643\\u060c \\u0628\\u0634\\u0631\\u0637 \\u0623\\u0646 \\u064a\\u0633\\u0645\\u062d \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0628\\u0647\\u0630\\u0627 \\u0627\\u0644\\u062e\\u064a\\u0627\\u0631. \\u0628\\u0625\\u0645\\u0643\\u0627\\u0646\\u0643 \\u062a\\u0623\\u0643\\u064a\\u062f \\u0627\\u0644\\u0645\\u0647\\u0645\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0635\\u0627\\u0644\\u0648\\u0646 \\u0639\\u0646\\u062f \\u0627\\u0644\\u062d\\u062c\\u0632."}},"status":1,"id":"677bae4a41d69"},"677bae8f158cd":{"language":{"en":{"question":"How do I become a manager or staff on SalonHub?","answer":"Managers and staff can only be assigned by vendors. If you\'re interested in joining a salon as a manager or staff, please reach out to a registered vendor who can add you through their dashboard."},"fr":{"question":"Comment puis-je devenir manager ou employ\\u00e9 sur SalonHub\\u00a0?","answer":"Les gestionnaires et le personnel ne peuvent \\u00eatre affect\\u00e9s que par les fournisseurs. Si vous souhaitez rejoindre un salon en tant que responsable ou employ\\u00e9, veuillez contacter un fournisseur enregistr\\u00e9 qui pourra vous ajouter via son tableau de bord."},"es":{"question":"\\u00bfC\\u00f3mo me convierto en gerente o miembro del personal de SalonHub?","answer":"Los gerentes y el personal s\\u00f3lo pueden ser asignados por proveedores. Si est\\u00e1 interesado en unirse a un sal\\u00f3n como gerente o personal, comun\\u00edquese con un proveedor registrado que pueda agregarlo a trav\\u00e9s de su panel."},"ar":{"question":"\\u0643\\u064a\\u0641 \\u0623\\u0635\\u0628\\u062d \\u0645\\u062f\\u064a\\u0631\\u064b\\u0627 \\u0623\\u0648 \\u0645\\u0648\\u0638\\u0641\\u064b\\u0627 \\u0641\\u064a SalonHub\\u061f","answer":"\\u0644\\u0627 \\u064a\\u0645\\u0643\\u0646 \\u062a\\u0639\\u064a\\u064a\\u0646 \\u0627\\u0644\\u0645\\u062f\\u064a\\u0631\\u064a\\u0646 \\u0648\\u0627\\u0644\\u0645\\u0648\\u0638\\u0641\\u064a\\u0646 \\u0625\\u0644\\u0627 \\u0645\\u0646 \\u0642\\u0628\\u0644 \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639\\u064a\\u0646. \\u0625\\u0630\\u0627 \\u0643\\u0646\\u062a \\u0645\\u0647\\u062a\\u0645\\u064b\\u0627 \\u0628\\u0627\\u0644\\u0627\\u0646\\u0636\\u0645\\u0627\\u0645 \\u0625\\u0644\\u0649 \\u0635\\u0627\\u0644\\u0648\\u0646 \\u0643\\u0645\\u062f\\u064a\\u0631 \\u0623\\u0648 \\u0645\\u0648\\u0638\\u0641\\u060c \\u0641\\u064a\\u0631\\u062c\\u0649 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0635\\u0644 \\u0645\\u0639 \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639 \\u0627\\u0644\\u0645\\u0633\\u062c\\u0644 \\u0627\\u0644\\u0630\\u064a \\u064a\\u0645\\u0643\\u0646\\u0647 \\u0625\\u0636\\u0627\\u0641\\u062a\\u0643 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0644\\u0648\\u062d\\u0629 \\u0627\\u0644\\u062a\\u062d\\u0643\\u0645 \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0647."}},"status":1,"id":"677bae8f158cd"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 05:05:22','updated_at' => '2025-01-06 16:21:03'),
            array('id' => '13','key' => 'client-feedback-section','value' => '{"language":{"en":{"title":"Testimonial","heading":"Our Customers Love What We Do","sub_heading":"We\'re excited to introduce our new website, designed to elevate your SalonHub experience! Our fresh platform, SalonHub, is now live, offering you a secure, user-friendly hub for all your financial needs."},"fr":{"title":"T\\u00e9moignage","heading":"Nos clients aiment ce que nous faisons","sub_heading":"Nous sommes ravis de vous pr\\u00e9senter notre nouveau site Web, con\\u00e7u pour am\\u00e9liorer votre exp\\u00e9rience SalonHub\\u00a0! Notre nouvelle plateforme, SalonHub, est d\\u00e9sormais en ligne et vous offre un hub s\\u00e9curis\\u00e9 et convivial pour tous vos besoins financiers."},"es":{"title":"Testimonial","heading":"Nuestros clientes aman lo que hacemos","sub_heading":"\\u00a1Estamos emocionados de presentar nuestro nuevo sitio web, dise\\u00f1ado para mejorar su experiencia SalonHub! Nuestra nueva plataforma, SalonHub, ya est\\u00e1 disponible y le ofrece un centro seguro y f\\u00e1cil de usar para todas sus necesidades financieras."},"ar":{"title":"\\u0634\\u0647\\u0627\\u062f\\u0629","heading":"\\u0639\\u0645\\u0644\\u0627\\u0624\\u0646\\u0627 \\u064a\\u062d\\u0628\\u0648\\u0646 \\u0645\\u0627 \\u0646\\u0642\\u0648\\u0645 \\u0628\\u0647","sub_heading":"\\u0646\\u062d\\u0646 \\u0645\\u062a\\u062d\\u0645\\u0633\\u0648\\u0646 \\u0644\\u062a\\u0642\\u062f\\u064a\\u0645 \\u0645\\u0648\\u0642\\u0639\\u0646\\u0627 \\u0627\\u0644\\u062c\\u062f\\u064a\\u062f\\u060c \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645 \\u0644\\u0644\\u0627\\u0631\\u062a\\u0642\\u0627\\u0621 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 SalonHub \\u0627\\u0644\\u062e\\u0627\\u0635\\u0629 \\u0628\\u0643! \\u0623\\u0635\\u0628\\u062d\\u062a \\u0645\\u0646\\u0635\\u062a\\u0646\\u0627 \\u0627\\u0644\\u062c\\u062f\\u064a\\u062f\\u0629\\u060c SalonHub\\u060c \\u0645\\u062a\\u0627\\u062d\\u0629 \\u0627\\u0644\\u0622\\u0646\\u060c \\u0648\\u062a\\u0648\\u0641\\u0631 \\u0644\\u0643 \\u0645\\u0631\\u0643\\u0632\\u064b\\u0627 \\u0622\\u0645\\u0646\\u064b\\u0627 \\u0648\\u0633\\u0647\\u0644 \\u0627\\u0644\\u0627\\u0633\\u062a\\u062e\\u062f\\u0627\\u0645 \\u0644\\u062c\\u0645\\u064a\\u0639 \\u0627\\u062d\\u062a\\u064a\\u0627\\u062c\\u0627\\u062a\\u0643 \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629."}},"items":{"672d9c9fa5926":{"language":{"en":{"comment":"SalonHub has completely transformed how we manage our business. The platform is intuitive, and the staff management tools are a lifesaver. I love that I can oversee everything from one place, and my team enjoys how easy it is to schedule appointments and track client preferences. A fantastic solution for any modern salon!"},"fr":{"comment":"SalonHub a compl\\u00e8tement transform\\u00e9 la fa\\u00e7on dont nous g\\u00e9rons notre entreprise. La plateforme est intuitive et les outils de gestion du personnel sont une bou\\u00e9e de sauvetage. J\'aime pouvoir tout superviser \\u00e0 partir d\'un seul endroit, et mon \\u00e9quipe appr\\u00e9cie la facilit\\u00e9 avec laquelle il est possible de planifier des rendez-vous et de suivre les pr\\u00e9f\\u00e9rences des clients. Une solution fantastique pour tout salon moderne !"},"es":{"comment":"SalonHub ha transformado completamente la forma en que gestionamos nuestro negocio. La plataforma es intuitiva y las herramientas de gesti\\u00f3n de personal son un salvavidas. Me encanta poder supervisar todo desde un solo lugar y mi equipo disfruta de lo f\\u00e1cil que es programar citas y realizar un seguimiento de las preferencias de los clientes. \\u00a1Una soluci\\u00f3n fant\\u00e1stica para cualquier sal\\u00f3n moderno!"},"ar":{"comment":"\\u0644\\u0642\\u062f \\u063a\\u064a\\u0651\\u0631 SalonHub \\u062a\\u0645\\u0627\\u0645\\u064b\\u0627 \\u0627\\u0644\\u0637\\u0631\\u064a\\u0642\\u0629 \\u0627\\u0644\\u062a\\u064a \\u0646\\u062f\\u064a\\u0631 \\u0628\\u0647\\u0627 \\u0623\\u0639\\u0645\\u0627\\u0644\\u0646\\u0627. \\u0627\\u0644\\u0645\\u0646\\u0635\\u0629 \\u0628\\u062f\\u064a\\u0647\\u064a\\u0629\\u060c \\u0648\\u0623\\u062f\\u0648\\u0627\\u062a \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0627\\u0644\\u0645\\u0648\\u0638\\u0641\\u064a\\u0646 \\u0647\\u064a \\u0627\\u0644\\u0645\\u0646\\u0642\\u0630. \\u0623\\u062d\\u0628 \\u0623\\u0646 \\u0623\\u062a\\u0645\\u0643\\u0646 \\u0645\\u0646 \\u0627\\u0644\\u0625\\u0634\\u0631\\u0627\\u0641 \\u0639\\u0644\\u0649 \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0646 \\u0645\\u0643\\u0627\\u0646 \\u0648\\u0627\\u062d\\u062f\\u060c \\u0648\\u064a\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0641\\u0631\\u064a\\u0642\\u064a \\u0628\\u0645\\u062f\\u0649 \\u0633\\u0647\\u0648\\u0644\\u0629 \\u062c\\u062f\\u0648\\u0644\\u0629 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0648\\u062a\\u062a\\u0628\\u0639 \\u062a\\u0641\\u0636\\u064a\\u0644\\u0627\\u062a \\u0627\\u0644\\u0639\\u0645\\u064a\\u0644. \\u062d\\u0644 \\u0631\\u0627\\u0626\\u0639 \\u0644\\u0623\\u064a \\u0635\\u0627\\u0644\\u0648\\u0646 \\u062d\\u062f\\u064a\\u062b!"}},"id":"672d9c9fa5926","image":"1b02613f-6513-45ee-8703-1618cd659148.webp","name":"Sarah Turner","designation":"Salon Owner","star":"4"},"677bb9e2d23a1":{"language":{"en":{"comment":"As a manager, SalonHub makes my day-to-day tasks so much easier. From managing service requests to assigning staff to the right tasks, everything is streamlined and efficient. Plus, the secure payment options are great for both us and our clients. I couldn\'t ask for a better tool to help me keep things running smoothly"},"fr":{"comment":"En tant que manager, SalonHub facilite grandement mes t\\u00e2ches quotidiennes. De la gestion des demandes de service \\u00e0 l\\u2019affectation du personnel aux bonnes t\\u00e2ches, tout est rationalis\\u00e9 et efficace. De plus, les options de paiement s\\u00e9curis\\u00e9es sont id\\u00e9ales pour nous et nos clients. Je ne pouvais pas r\\u00eaver d\'un meilleur outil pour m\'aider \\u00e0 assurer le bon d\\u00e9roulement des choses."},"es":{"comment":"Como gerente, SalonHub facilita mucho mis tareas diarias. Desde la gesti\\u00f3n de solicitudes de servicio hasta la asignaci\\u00f3n de personal a las tareas adecuadas, todo es \\u00e1gil y eficiente. Adem\\u00e1s, las opciones de pago seguro son excelentes tanto para nosotros como para nuestros clientes. No podr\\u00eda pedir una mejor herramienta para ayudarme a mantener todo funcionando sin problemas"},"ar":{"comment":"\\u0643\\u0645\\u062f\\u064a\\u0631\\u060c \\u064a\\u062c\\u0639\\u0644 SalonHub \\u0645\\u0647\\u0627\\u0645\\u064a \\u0627\\u0644\\u064a\\u0648\\u0645\\u064a\\u0629 \\u0623\\u0633\\u0647\\u0644 \\u0628\\u0643\\u062b\\u064a\\u0631. \\u0628\\u062f\\u0621\\u064b\\u0627 \\u0645\\u0646 \\u0625\\u062f\\u0627\\u0631\\u0629 \\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629 \\u0648\\u062d\\u062a\\u0649 \\u062a\\u0639\\u064a\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0648\\u0638\\u0641\\u064a\\u0646 \\u0644\\u0644\\u0645\\u0647\\u0627\\u0645 \\u0627\\u0644\\u0645\\u0646\\u0627\\u0633\\u0628\\u0629\\u060c \\u0623\\u0635\\u0628\\u062d \\u0643\\u0644 \\u0634\\u064a\\u0621 \\u0645\\u0628\\u0633\\u0637\\u064b\\u0627 \\u0648\\u0641\\u0639\\u0627\\u0644\\u0627\\u064b. \\u0628\\u0627\\u0644\\u0625\\u0636\\u0627\\u0641\\u0629 \\u0625\\u0644\\u0649 \\u0630\\u0644\\u0643\\u060c \\u062a\\u0639\\u062f \\u062e\\u064a\\u0627\\u0631\\u0627\\u062a \\u0627\\u0644\\u062f\\u0641\\u0639 \\u0627\\u0644\\u0622\\u0645\\u0646\\u0629 \\u0631\\u0627\\u0626\\u0639\\u0629 \\u0628\\u0627\\u0644\\u0646\\u0633\\u0628\\u0629 \\u0644\\u0646\\u0627 \\u0648\\u0644\\u0639\\u0645\\u0644\\u0627\\u0626\\u0646\\u0627. \\u0644\\u0645 \\u0623\\u0633\\u062a\\u0637\\u0639 \\u0623\\u0646 \\u0623\\u0637\\u0644\\u0628 \\u0623\\u062f\\u0627\\u0629 \\u0623\\u0641\\u0636\\u0644 \\u0644\\u0645\\u0633\\u0627\\u0639\\u062f\\u062a\\u064a \\u0641\\u064a \\u0627\\u0644\\u062d\\u0641\\u0627\\u0638 \\u0639\\u0644\\u0649 \\u0633\\u064a\\u0631 \\u0627\\u0644\\u0623\\u0645\\u0648\\u0631 \\u0628\\u0633\\u0644\\u0627\\u0633\\u0629"}},"id":"677bb9e2d23a1","image":"0b818bfb-301c-4c75-9aac-638d5caeb944.webp","name":"James Patel","designation":"Salon Manager","star":"5"},"677bba3e5faf6":{"language":{"en":{"comment":"I\\u2019ve been using SalonHub for a few months now, and it\\u2019s been such a game-changer. Booking appointments is a breeze, and I love how easy it is to find my favorite salons and book services directly through the app. The whole experience is seamless, and I can\\u2019t imagine going back to anything else!"},"fr":{"comment":"J\\u2019utilise SalonHub depuis quelques mois maintenant, et cela a vraiment chang\\u00e9 la donne. La prise de rendez-vous est un jeu d\'enfant et j\'aime la facilit\\u00e9 avec laquelle il est de trouver mes salons pr\\u00e9f\\u00e9r\\u00e9s et de r\\u00e9server des services directement via l\'application. L\\u2019ensemble de l\\u2019exp\\u00e9rience est fluide et je ne peux pas imaginer revenir \\u00e0 autre chose\\u00a0!"},"es":{"comment":"He estado usando SalonHub durante algunos meses y ha cambiado las reglas del juego. Reservar citas es muy sencillo y me encanta lo f\\u00e1cil que es encontrar mis salones favoritos y reservar servicios directamente a trav\\u00e9s de la aplicaci\\u00f3n. \\u00a1Toda la experiencia es perfecta y no puedo imaginarme volver a nada m\\u00e1s!"},"ar":{"comment":"\\u0644\\u0642\\u062f \\u0643\\u0646\\u062a \\u0623\\u0633\\u062a\\u062e\\u062f\\u0645 SalonHub \\u0645\\u0646\\u0630 \\u0628\\u0636\\u0639\\u0629 \\u0623\\u0634\\u0647\\u0631\\u060c \\u0648\\u0642\\u062f \\u0623\\u062d\\u062f\\u062b \\u062a\\u063a\\u064a\\u064a\\u0631\\u064b\\u0627 \\u062c\\u0630\\u0631\\u064a\\u064b\\u0627 \\u0641\\u064a \\u0642\\u0648\\u0627\\u0639\\u062f \\u0627\\u0644\\u0644\\u0639\\u0628\\u0629. \\u0623\\u0635\\u0628\\u062d \\u062d\\u062c\\u0632 \\u0627\\u0644\\u0645\\u0648\\u0627\\u0639\\u064a\\u062f \\u0623\\u0645\\u0631\\u064b\\u0627 \\u0641\\u064a \\u063a\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0633\\u0647\\u0648\\u0644\\u0629\\u060c \\u0648\\u0623\\u0646\\u0627 \\u0623\\u062d\\u0628 \\u0645\\u062f\\u0649 \\u0633\\u0647\\u0648\\u0644\\u0629 \\u0627\\u0644\\u0639\\u062b\\u0648\\u0631 \\u0639\\u0644\\u0649 \\u0635\\u0627\\u0644\\u0648\\u0646\\u0627\\u062a\\u064a \\u0627\\u0644\\u0645\\u0641\\u0636\\u0644\\u0629 \\u0648\\u062d\\u062c\\u0632 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0645\\u0628\\u0627\\u0634\\u0631\\u0629 \\u0645\\u0646 \\u062e\\u0644\\u0627\\u0644 \\u0627\\u0644\\u062a\\u0637\\u0628\\u064a\\u0642. \\u0627\\u0644\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0628\\u0631\\u0645\\u062a\\u0647\\u0627 \\u0633\\u0644\\u0633\\u0629\\u060c \\u0648\\u0644\\u0627 \\u0623\\u0633\\u062a\\u0637\\u064a\\u0639 \\u0623\\u0646 \\u0623\\u062a\\u062e\\u064a\\u0644 \\u0627\\u0644\\u0639\\u0648\\u062f\\u0629 \\u0625\\u0644\\u0649 \\u0623\\u064a \\u0634\\u064a\\u0621 \\u0622\\u062e\\u0631!"}},"id":"677bba3e5faf6","image":"5b1b6e82-2d3b-4fba-acb4-986a9b6b5d62.webp","name":"Lisa Moreno","designation":"Frequent User","star":"4"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 05:06:57','updated_at' => '2025-01-06 22:50:08'),
            array('id' => '14','key' => 'services-section','value' => '{"language":{"en":{"title":"Service Items","sub_heading":"Explore an array of premium services designed to elevate your beauty and well-being. From hairstyling to relaxation treatments, SalonHub brings the best to you.","heading":"What Type of Services Do We Provide?"},"fr":{"title":"Articles de service","sub_heading":"D\\u00e9couvrez une gamme de services haut de gamme con\\u00e7us pour rehausser votre beaut\\u00e9 et votre bien-\\u00eatre. De la coiffure aux soins de relaxation, SalonHub vous apporte le meilleur.","heading":"Quel type de services fournissons-nous ?"},"es":{"title":"Art\\u00edculos de servicio","sub_heading":"Explore una variedad de servicios premium dise\\u00f1ados para elevar su belleza y bienestar. Desde peluquer\\u00eda hasta tratamientos de relajaci\\u00f3n, SalonHub te ofrece lo mejor.","heading":"\\u00bfQu\\u00e9 tipo de servicios brindamos?"},"ar":{"title":"\\u0639\\u0646\\u0627\\u0635\\u0631 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0629","sub_heading":"\\u0627\\u0633\\u062a\\u0643\\u0634\\u0641 \\u0645\\u062c\\u0645\\u0648\\u0639\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0645\\u064a\\u0632\\u0629 \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u0644\\u0644\\u0627\\u0631\\u062a\\u0642\\u0627\\u0621 \\u0628\\u062c\\u0645\\u0627\\u0644\\u0643 \\u0648\\u0631\\u0641\\u0627\\u0647\\u064a\\u062a\\u0643. \\u0645\\u0646 \\u062a\\u0635\\u0641\\u064a\\u0641 \\u0627\\u0644\\u0634\\u0639\\u0631 \\u0625\\u0644\\u0649 \\u0639\\u0644\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u0627\\u0633\\u062a\\u0631\\u062e\\u0627\\u0621\\u060c \\u064a\\u0642\\u062f\\u0645 SalonHub \\u0627\\u0644\\u0623\\u0641\\u0636\\u0644 \\u0644\\u0643.","heading":"\\u0645\\u0627 \\u0646\\u0648\\u0639 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u062a\\u064a \\u0646\\u0642\\u062f\\u0645\\u0647\\u0627\\u061f"}},"items":{"672d9d9be43c1":{"language":{"en":{"title":"Hairstyles","description":"Discover our expertly crafted hairstyles, tailored to showcase your individuality and redefine your hair\'s beauty. Whether it\\u2019s a new cut, a stunning color, or a complete hair transformation, our experienced stylists will help you achieve your desired look."},"fr":{"title":"Coiffures","description":"D\\u00e9couvrez nos coiffures con\\u00e7ues par des experts, con\\u00e7ues pour mettre en valeur votre individualit\\u00e9 et red\\u00e9finir la beaut\\u00e9 de vos cheveux. Qu\'il s\'agisse d\'une nouvelle coupe, d\'une couleur \\u00e9poustouflante ou d\'une transformation compl\\u00e8te de vos cheveux, nos stylistes exp\\u00e9riment\\u00e9s vous aideront \\u00e0 obtenir le look souhait\\u00e9."},"es":{"title":"Peinados","description":"Descubra nuestros peinados elaborados por expertos, dise\\u00f1ados para mostrar su individualidad y redefinir la belleza de su cabello. Ya sea un nuevo corte, un color deslumbrante o una transformaci\\u00f3n completa del cabello, nuestros estilistas experimentados lo ayudar\\u00e1n a lograr el aspecto deseado."},"ar":{"title":"\\u062a\\u0633\\u0631\\u064a\\u062d\\u0627\\u062a \\u0627\\u0644\\u0634\\u0639\\u0631","description":"\\u0627\\u0643\\u062a\\u0634\\u0641 \\u062a\\u0633\\u0631\\u064a\\u062d\\u0627\\u062a \\u0627\\u0644\\u0634\\u0639\\u0631 \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u0628\\u062e\\u0628\\u0631\\u0629 \\u0648\\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u062e\\u0635\\u064a\\u0635\\u064b\\u0627 \\u0644\\u0625\\u0638\\u0647\\u0627\\u0631 \\u0634\\u062e\\u0635\\u064a\\u062a\\u0643 \\u0648\\u0625\\u0639\\u0627\\u062f\\u0629 \\u062a\\u0639\\u0631\\u064a\\u0641 \\u062c\\u0645\\u0627\\u0644 \\u0634\\u0639\\u0631\\u0643. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0627\\u0646 \\u0627\\u0644\\u0623\\u0645\\u0631 \\u064a\\u062a\\u0639\\u0644\\u0642 \\u0628\\u0642\\u0635\\u0629 \\u062c\\u062f\\u064a\\u062f\\u0629\\u060c \\u0623\\u0648 \\u0644\\u0648\\u0646 \\u0645\\u0630\\u0647\\u0644\\u060c \\u0623\\u0648 \\u062a\\u063a\\u064a\\u064a\\u0631 \\u0643\\u0627\\u0645\\u0644 \\u0644\\u0644\\u0634\\u0639\\u0631\\u060c \\u0633\\u064a\\u0633\\u0627\\u0639\\u062f\\u0643 \\u0645\\u0635\\u0641\\u0641\\u0648 \\u0627\\u0644\\u0634\\u0639\\u0631 \\u0630\\u0648\\u064a \\u0627\\u0644\\u062e\\u0628\\u0631\\u0629 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0639\\u0644\\u0649 \\u062a\\u062d\\u0642\\u064a\\u0642 \\u0627\\u0644\\u0645\\u0638\\u0647\\u0631 \\u0627\\u0644\\u0630\\u064a \\u062a\\u0631\\u064a\\u062f\\u0647."}},"id":"672d9d9be43c1","image":"423830ec-9907-451b-aebd-39fe6ba8e6a6.webp","icon":null},"672d9db3e04a6":{"language":{"en":{"title":"Massage Therapy","description":"Relax and rejuvenate with our premium massage therapy services. Our skilled therapists provide various techniques to soothe your body, reduce stress, and restore balance, leaving you feeling refreshed and revitalized."},"fr":{"title":"Massoth\\u00e9rapie","description":"D\\u00e9tendez-vous et ressourcez-vous gr\\u00e2ce \\u00e0 nos services de massoth\\u00e9rapie haut de gamme. Nos th\\u00e9rapeutes qualifi\\u00e9s proposent diverses techniques pour apaiser votre corps, r\\u00e9duire le stress et r\\u00e9tablir l\'\\u00e9quilibre, vous laissant une sensation de fra\\u00eecheur et de revitalisation."},"es":{"title":"Terapia de masaje","description":"Rel\\u00e1jese y rejuvenezca con nuestros servicios premium de terapia de masajes. Nuestros terapeutas calificados brindan diversas t\\u00e9cnicas para calmar su cuerpo, reducir el estr\\u00e9s y restablecer el equilibrio, dej\\u00e1ndolo sinti\\u00e9ndose renovado y revitalizado."},"ar":{"title":"\\u0627\\u0644\\u0639\\u0644\\u0627\\u062c \\u0628\\u0627\\u0644\\u062a\\u062f\\u0644\\u064a\\u0643","description":"\\u0627\\u0633\\u062a\\u0631\\u062e\\u0650 \\u0648\\u062c\\u062f\\u062f \\u0646\\u0634\\u0627\\u0637\\u0643 \\u0645\\u0639 \\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0639\\u0644\\u0627\\u062c \\u0628\\u0627\\u0644\\u062a\\u062f\\u0644\\u064a\\u0643 \\u0627\\u0644\\u0645\\u062a\\u0645\\u064a\\u0632\\u0629 \\u0644\\u062f\\u064a\\u0646\\u0627. \\u064a\\u0642\\u062f\\u0645 \\u0627\\u0644\\u0645\\u0639\\u0627\\u0644\\u062c\\u0648\\u0646 \\u0627\\u0644\\u0645\\u0647\\u0631\\u0629 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u062a\\u0642\\u0646\\u064a\\u0627\\u062a \\u0645\\u062e\\u062a\\u0644\\u0641\\u0629 \\u0644\\u062a\\u0647\\u062f\\u0626\\u0629 \\u062c\\u0633\\u0645\\u0643 \\u0648\\u062a\\u0642\\u0644\\u064a\\u0644 \\u0627\\u0644\\u062a\\u0648\\u062a\\u0631 \\u0648\\u0627\\u0633\\u062a\\u0639\\u0627\\u062f\\u0629 \\u0627\\u0644\\u062a\\u0648\\u0627\\u0632\\u0646\\u060c \\u0645\\u0645\\u0627 \\u064a\\u062c\\u0639\\u0644\\u0643 \\u062a\\u0634\\u0639\\u0631 \\u0628\\u0627\\u0644\\u0627\\u0646\\u062a\\u0639\\u0627\\u0634 \\u0648\\u0627\\u0644\\u0646\\u0634\\u0627\\u0637."}},"id":"672d9db3e04a6","image":"52f3b428-3945-400a-b374-10cd3b8f6747.webp","icon":null},"677bb0f3ab9ae":{"language":{"en":{"title":"Nail Care","description":"Pamper your hands and feet with our extensive nail care services. From manicures and pedicures to nail art, enjoy a luxurious experience with premium products, designed to leave your nails looking flawless and feeling healthy."},"fr":{"title":"Soins des ongles","description":"\\"Prenez soin de vos mains et de vos pieds gr\\u00e2ce \\u00e0 nos nombreux services de soins des ongles. Des manucures et p\\u00e9dicures au nail art, profitez d\'une exp\\u00e9rience luxueuse avec des produits haut de gamme, con\\u00e7us pour laisser vos ongles impeccables et en bonne sant\\u00e9.\\r\\n\\""},"es":{"title":"cuidado de u\\u00f1as","description":"Mima tus manos y pies con nuestros amplios servicios de cuidado de u\\u00f1as. Desde manicuras y pedicuras hasta decoraci\\u00f3n de u\\u00f1as, disfrute de una experiencia de lujo con productos premium, dise\\u00f1ados para dejar sus u\\u00f1as con un aspecto impecable y una sensaci\\u00f3n saludable."},"ar":{"title":"\\u0627\\u0644\\u0639\\u0646\\u0627\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0623\\u0638\\u0627\\u0641\\u0631","description":"\\u062f\\u0644\\u0644 \\u064a\\u062f\\u064a\\u0643 \\u0648\\u0642\\u062f\\u0645\\u064a\\u0643 \\u0645\\u0639 \\u062e\\u062f\\u0645\\u0627\\u062a\\u0646\\u0627 \\u0627\\u0644\\u0634\\u0627\\u0645\\u0644\\u0629 \\u0644\\u0644\\u0639\\u0646\\u0627\\u064a\\u0629 \\u0628\\u0627\\u0644\\u0623\\u0638\\u0627\\u0641\\u0631. \\u0645\\u0646 \\u0639\\u0645\\u0644\\u064a\\u0627\\u062a \\u062a\\u062c\\u0645\\u064a\\u0644 \\u0627\\u0644\\u0623\\u0638\\u0627\\u0641\\u0631 \\u0648\\u0627\\u0644\\u0628\\u0627\\u062f\\u064a\\u0643\\u064a\\u0631 \\u0625\\u0644\\u0649 \\u0641\\u0646 \\u0627\\u0644\\u0623\\u0638\\u0627\\u0641\\u0631\\u060c \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639\\u064a \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u0641\\u0627\\u062e\\u0631\\u0629 \\u0645\\u0639 \\u0627\\u0644\\u0645\\u0646\\u062a\\u062c\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0645\\u064a\\u0632\\u0629\\u060c \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u0644\\u062a\\u062a\\u0631\\u0643 \\u0623\\u0638\\u0627\\u0641\\u0631\\u0643 \\u062a\\u0628\\u062f\\u0648 \\u062e\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0646 \\u0627\\u0644\\u0639\\u064a\\u0648\\u0628 \\u0648\\u062a\\u0634\\u0639\\u0631 \\u0628\\u0627\\u0644\\u0635\\u062d\\u0629."}},"id":"677bb0f3ab9ae","image":"23f3c0da-ef40-4f59-9add-4e25d2bbb460.webp","icon":null},"677bb1775bc1a":{"language":{"en":{"title":"Facial Treatments","description":"Achieve glowing, youthful skin with our facials, customized to your skin type. Whether you need a deep cleanse, anti-aging treatment, or hydration boost, our professionals will tailor a facial to give your skin a healthy, radiant glow."},"fr":{"title":"Soins du visage","description":"Obtenez une peau \\u00e9clatante et jeune avec nos soins du visage, adapt\\u00e9s \\u00e0 votre type de peau. Que vous ayez besoin d\'un nettoyage en profondeur, d\'un traitement anti-\\u00e2ge ou d\'un regain d\'hydratation, nos professionnels adapteront un soin du visage pour donner \\u00e0 votre peau un \\u00e9clat sain et radieux."},"es":{"title":"Tratamientos Faciales","description":"Logre una piel joven y radiante con nuestros tratamientos faciales, personalizados para su tipo de piel. Ya sea que necesite una limpieza profunda, un tratamiento antienvejecimiento o un refuerzo de hidrataci\\u00f3n, nuestros profesionales dise\\u00f1ar\\u00e1n un tratamiento facial para darle a su piel un brillo saludable y radiante."},"ar":{"title":"\\u0639\\u0644\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0647","description":"\\u0627\\u062d\\u0635\\u0644\\u064a \\u0639\\u0644\\u0649 \\u0628\\u0634\\u0631\\u0629 \\u0645\\u062a\\u0648\\u0647\\u062c\\u0629 \\u0648\\u0634\\u0627\\u0628\\u0629 \\u0645\\u0639 \\u0639\\u0644\\u0627\\u062c\\u0627\\u062a \\u0627\\u0644\\u0648\\u062c\\u0647 \\u0627\\u0644\\u0645\\u062e\\u0635\\u0635\\u0629 \\u0644\\u0646\\u0648\\u0639 \\u0628\\u0634\\u0631\\u062a\\u0643. \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u0628\\u062d\\u0627\\u062c\\u0629 \\u0625\\u0644\\u0649 \\u062a\\u0646\\u0638\\u064a\\u0641 \\u0639\\u0645\\u064a\\u0642\\u060c \\u0623\\u0648 \\u0639\\u0644\\u0627\\u062c \\u0645\\u0636\\u0627\\u062f \\u0644\\u0644\\u0634\\u064a\\u062e\\u0648\\u062e\\u0629\\u060c \\u0623\\u0648 \\u062a\\u0639\\u0632\\u064a\\u0632 \\u0627\\u0644\\u062a\\u0631\\u0637\\u064a\\u0628\\u060c \\u0633\\u064a\\u0642\\u0648\\u0645 \\u0627\\u0644\\u0645\\u062a\\u062e\\u0635\\u0635\\u0648\\u0646 \\u0644\\u062f\\u064a\\u0646\\u0627 \\u0628\\u062a\\u0635\\u0645\\u064a\\u0645 \\u0639\\u0644\\u0627\\u062c \\u0644\\u0644\\u0648\\u062c\\u0647 \\u0644\\u064a\\u0645\\u0646\\u062d \\u0628\\u0634\\u0631\\u062a\\u0643 \\u062a\\u0648\\u0647\\u062c\\u064b\\u0627 \\u0635\\u062d\\u064a\\u064b\\u0627 \\u0648\\u0645\\u0634\\u0631\\u0642\\u064b\\u0627."}},"id":"677bb1775bc1a","image":"527b9446-4562-423f-a9d1-375b26f368da.webp"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 05:10:18','updated_at' => '2025-01-06 22:30:05'),
            array('id' => '15','key' => 'blog','value' => '{"language":{"en":{"title":"Web Journal","heading":"Meet Some of Our Latest Web Journal Entries","sub_heading":"At SalonHub, consumer loyalty is key to us. Check out our most recent blogs and see what our clients are saying about us!"},"fr":{"title":"Journal Web","heading":"D\\u00e9couvrez certaines de nos derni\\u00e8res entr\\u00e9es de journaux Web","sub_heading":"Chez SalonHub, la fid\\u00e9lit\\u00e9 des consommateurs est essentielle pour nous. Consultez nos blogs les plus r\\u00e9cents et voyez ce que nos clients disent de nous\\u00a0!"},"es":{"title":"Diario Web","heading":"Conozca algunas de nuestras \\u00faltimas entradas de diarios web","sub_heading":"En SalonHub, la lealtad del consumidor es clave para nosotros. \\u00a1Consulte nuestros blogs m\\u00e1s recientes y vea lo que nuestros clientes dicen sobre nosotros!"},"ar":{"title":"\\u0645\\u062c\\u0644\\u0629 \\u0627\\u0644\\u0648\\u064a\\u0628","heading":"\\u062a\\u0639\\u0631\\u0641 \\u0639\\u0644\\u0649 \\u0628\\u0639\\u0636 \\u0623\\u062d\\u062f\\u062b \\u0625\\u062f\\u062e\\u0627\\u0644\\u0627\\u062a \\u064a\\u0648\\u0645\\u064a\\u0627\\u062a \\u0627\\u0644\\u0648\\u064a\\u0628 \\u0644\\u062f\\u064a\\u0646\\u0627","sub_heading":"\\u0641\\u064a SalonHub\\u060c \\u0648\\u0644\\u0627\\u0621 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0647\\u0644\\u0643 \\u0647\\u0648 \\u0627\\u0644\\u0645\\u0641\\u062a\\u0627\\u062d \\u0628\\u0627\\u0644\\u0646\\u0633\\u0628\\u0629 \\u0644\\u0646\\u0627. \\u062a\\u062d\\u0642\\u0642 \\u0645\\u0646 \\u0623\\u062d\\u062f\\u062b \\u0645\\u062f\\u0648\\u0646\\u0627\\u062a\\u0646\\u0627 \\u0648\\u0634\\u0627\\u0647\\u062f \\u0645\\u0627 \\u064a\\u0642\\u0648\\u0644\\u0647 \\u0639\\u0645\\u0644\\u0627\\u0624\\u0646\\u0627 \\u0639\\u0646\\u0627!"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 05:34:33','updated_at' => '2025-01-06 16:43:21'),
            array('id' => '16','key' => 'contact','value' => '{"schedules":[{"schedule":"Monday\\u2013Friday, 9am - 9pm"}],"language":{"en":{"title":"Request a Contact us","description":"Feel Free To Get In Touch With Us"},"fr":{"title":"Demander un Contactez-nous","description":"N\'h\\u00e9sitez pas \\u00e0 nous contacter ! Nous sommes l\\u00e0 pour vous aider avec toute demande de renseignements ou toute assistance dont vous pourriez avoir besoin."},"es":{"title":"Solicitar un Cont\\u00e1ctenos","description":"\\u00a1No dudes en ponerte en contacto con nosotros! Estamos aqu\\u00ed para ayudarle con cualquier consulta o soporte que pueda necesitar."},"ar":{"title":"\\u0637\\u0644\\u0628 \\u0627\\u062a\\u0635\\u0644 \\u0628\\u0646\\u0627","description":"\\u0644\\u0627 \\u062a\\u062a\\u0631\\u062f\\u062f \\u0641\\u064a \\u0627\\u0644\\u0627\\u062a\\u0635\\u0627\\u0644 \\u0628\\u0646\\u0627! \\u0646\\u062d\\u0646 \\u0647\\u0646\\u0627 \\u0644\\u0645\\u0633\\u0627\\u0639\\u062f\\u062a\\u0643 \\u0641\\u064a \\u0623\\u064a \\u0627\\u0633\\u062a\\u0641\\u0633\\u0627\\u0631\\u0627\\u062a \\u0623\\u0648 \\u062f\\u0639\\u0645 \\u0642\\u062f \\u062a\\u062d\\u062a\\u0627\\u062c\\u0647."}},"phone":"+03601 885399","address":"20-22 Wenlock Road, England, N1 7GU","email":"support@salonhub.com"}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 05:47:29','updated_at' => '2025-01-06 16:36:01'),
            array('id' => '17','key' => 'vendor-requirements-section','value' => '{"language":{"en":{"title":"Vendor Requirements","heading":"Here\\u2019s What You Need to Get Started with SalonHub"},"fr":{"title":"Exigences du fournisseur","heading":"Voici ce dont vous avez besoin pour d\\u00e9marrer avec SalonHub"},"es":{"title":"Requisitos del proveedor","heading":"Esto es lo que necesita para comenzar con SalonHub"},"ar":{"title":"\\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u0628\\u0627\\u0626\\u0639","heading":"\\u0625\\u0644\\u064a\\u0643 \\u0645\\u0627 \\u062a\\u062d\\u062a\\u0627\\u062c\\u0647 \\u0644\\u0644\\u0628\\u062f\\u0621 \\u0645\\u0639 SalonHub"}},"items":{"672da81cef737":{"language":{"en":{"title":"Requirements"},"fr":{"title":"documents"},"es":{"title":"documentos"},"ar":{"title":"\\u0645\\u062a\\u0637\\u0644\\u0628\\u0627\\u062a"}},"id":"672da81cef737","icon":"fas fa-book-dead","detailsItem":{"677bfe5b9a9f7":{"language":{"en":{"details":"Obtain a business license and any permits necessary for operating a salon or spa in your area."},"fr":{"details":"Obtenez une licence commerciale et tous les permis n\\u00e9cessaires pour exploiter un salon ou un spa"},"es":{"details":"Obtenga una licencia comercial y los permisos necesarios para operar un sal\\u00f3n o spa en su \\u00e1rea"},"ar":{"details":"\\"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0631\\u062e\\u0635\\u0629 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0648\\u0623\\u064a \\u062a\\u0635\\u0627\\u0631\\u064a\\u062d \\u0636\\u0631\\u0648\\u0631\\u064a\\u0629 \\u0644\\u062a\\u0634\\u063a\\u064a\\u0644 \\u0635\\u0627\\u0644\\u0648\\u0646 \\u0623\\u0648 \\u0645\\u0646\\u062a\\u062c\\u0639 \\u0635\\u062d\\u064a \\u0641\\u064a \\u0645\\u0646\\u0637\\u0642\\u062a\\u0643"}},"id":"677bfe5b9a9f7"},"677bfe6dc6229":{"language":{"en":{"details":"Obtain a business license and any permits necessary for operating a salon or spa in your area."},"fr":{"details":"Obtenez une licence commerciale et tous les permis n\\u00e9cessaires pour exploiter"},"es":{"details":"Obtenga una licencia comercial y los permisos necesarios para operar un"},"ar":{"details":"\\"\\u0627\\u062d\\u0635\\u0644 \\u0639\\u0644\\u0649 \\u0631\\u062e\\u0635\\u0629 \\u062a\\u062c\\u0627\\u0631\\u064a\\u0629 \\u0648\\u0623\\u064a \\u062a\\u0635\\u0627\\u0631\\u064a\\u062d \\u0636\\u0631\\u0648\\u0631\\u064a\\u0629 \\u0644\\u062a\\u0634\\u063a\\u064a\\u0644 \\u0635\\u0627\\u0644\\u0648\\u0646 \\u0623\\u0648 \\u0645\\u0646\\u062a\\u062c\\u0639 \\u0635\\u062d\\u064a \\u0641\\u064a \\u0645\\u0646\\u0637\\u0642\\u062a\\u0643"}},"id":"677bfe6dc6229"}}},"672da832c1896":{"language":{"en":{"title":"documents"},"fr":{"title":"documents"},"es":{"title":"documentos"},"ar":{"title":"\\u0648\\u062b\\u0627\\u0626\\u0642"}},"id":"672da832c1896","icon":"fas fa-copy","detailsItem":{"672da954eafbe":{"language":{"en":{"details":"General liability insurance to protect against claims related to property damage or personal injury."},"fr":{"details":"Assurance responsabilit\\u00e9 civile g\\u00e9n\\u00e9rale pour vous prot\\u00e9ger contre les r\\u00e9clamations li\\u00e9es aux"},"es":{"details":"Seguro de responsabilidad general para proteger contra reclamaciones relacionadas con da\\u00f1os a la"},"ar":{"details":"\\u062a\\u0623\\u0645\\u064a\\u0646 \\u0627\\u0644\\u0645\\u0633\\u0624\\u0648\\u0644\\u064a\\u0629 \\u0627\\u0644\\u0639\\u0627\\u0645\\u0629 \\u0644\\u0644\\u062d\\u0645\\u0627\\u064a\\u0629 \\u0636\\u062f \\u0627\\u0644\\u0645\\u0637\\u0627\\u0644\\u0628\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0639\\u0644\\u0642\\u0629 \\u0628\\u0623\\u0636\\u0631\\u0627\\u0631 \\u0641\\u064a \\u0627\\u0644\\u0645\\u0645\\u062a\\u0644\\u0643\\u0627\\u062a \\u0623\\u0648 \\u0627\\u0644\\u0625\\u0635\\u0627\\u0628\\u0629 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a\\u0629."}},"id":"672da954eafbe"},"672da9a4ed3e9":{"language":{"en":{"details":"Prepare financial projections and estimates for startup costs to ensure a strong business foundation"},"fr":{"details":"Pr\\u00e9parer des projections financi\\u00e8res et des estimations des co\\u00fbts de d\\u00e9marrage pour"},"es":{"details":"Prepare proyecciones financieras y estimaciones de los costos iniciales para"},"ar":{"details":"\\u0642\\u0645 \\u0628\\u0625\\u0639\\u062f\\u0627\\u062f \\u0627\\u0644\\u062a\\u0648\\u0642\\u0639\\u0627\\u062a \\u0627\\u0644\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0648\\u0627\\u0644\\u062a\\u0642\\u062f\\u064a\\u0631\\u0627\\u062a \\u0644\\u062a\\u0643\\u0627\\u0644\\u064a\\u0641 \\u0628\\u062f\\u0621 \\u0627\\u0644\\u062a\\u0634\\u063a\\u064a\\u0644 \\u0644\\u0636\\u0645\\u0627\\u0646 \\u0623\\u0633\\u0627\\u0633 \\u062a\\u062c\\u0627\\u0631\\u064a \\u0642\\u0648\\u064a"}},"id":"672da9a4ed3e9"}}},"677bc4f6381ae":{"language":{"en":{"title":"Digital Presence"},"fr":{"title":"Pr\\u00e9sence num\\u00e9rique"},"es":{"title":"Presencia Digital"},"ar":{"title":"\\u0627\\u0644\\u062a\\u0648\\u0627\\u062c\\u062f \\u0627\\u0644\\u0631\\u0642\\u0645\\u064a"}},"id":"677bc4f6381ae","icon":"fas fa-digital-tachograph","detailsItem":{"677bc6eaa17dc":{"language":{"en":{"details":"Set up a professional email and upload high-quality salon images for your SalonHub profile"},"fr":{"details":"Configurez une messagerie professionnelle et t\\u00e9l\\u00e9chargez des images de salon\\/spa de haute"},"es":{"details":"Configure un correo electr\\u00f3nico profesional y cargue im\\u00e1genes de sal\\u00f3n\\/spa de alta calidad para su"},"ar":{"details":"\\u0642\\u0645 \\u0628\\u0625\\u0639\\u062f\\u0627\\u062f \\u0628\\u0631\\u064a\\u062f \\u0625\\u0644\\u0643\\u062a\\u0631\\u0648\\u0646\\u064a \\u0627\\u062d\\u062a\\u0631\\u0627\\u0641\\u064a \\u0648\\u0642\\u0645 \\u0628\\u062a\\u062d\\u0645\\u064a\\u0644 \\u0635\\u0648\\u0631 \\u0635\\u0627\\u0644\\u0648\\u0646\\/\\u0645\\u0646\\u062a\\u062c\\u0639 \\u0635\\u062d\\u064a \\u0639\\u0627\\u0644\\u064a\\u0629 \\u0627\\u0644\\u062c\\u0648\\u062f\\u0629 \\u0644\\u0645\\u0644\\u0641\\u0643 \\u0627\\u0644\\u0634\\u062e\\u0635\\u064a \\u0641\\u064a SalonHub"}},"id":"677bc6eaa17dc"},"677bc73147bd1":{"language":{"en":{"details":"List your services with detailed descriptions and competitive pricing to attract more customers."},"fr":{"details":"R\\u00e9pertoriez vos services avec des descriptions d\\u00e9taill\\u00e9es et des prix comp\\u00e9titifs pour attirer"},"es":{"details":"Enumere sus servicios con descripciones detalladas y precios competitivos para atraer m\\u00e1s clientes."},"ar":{"details":"\\u0642\\u0645 \\u0628\\u0625\\u062f\\u0631\\u0627\\u062c \\u062e\\u062f\\u0645\\u0627\\u062a\\u0643 \\u0645\\u0639 \\u0648\\u0635\\u0641 \\u062a\\u0641\\u0635\\u064a\\u0644\\u064a \\u0648\\u0623\\u0633\\u0639\\u0627\\u0631 \\u062a\\u0646\\u0627\\u0641\\u0633\\u064a\\u0629 \\u0644\\u062c\\u0630\\u0628 \\u0627\\u0644\\u0645\\u0632\\u064a\\u062f \\u0645\\u0646 \\u0627\\u0644\\u0639\\u0645\\u0644\\u0627\\u0621."}},"id":"677bc73147bd1"}}}}}','status' => '1','serialize' => NULL,'created_at' => '2024-11-08 05:56:06','updated_at' => '2025-01-06 22:01:56'),
            array('id' => '18','key' => 'auth-section','value' => '{"language":{"en":{"title":"Create an Account or Log In Now","heading":"Ready to take your beauty experience to the next level? Whether you\'re a new user or returning, logging in or signing up for SalonHub is a breeze. Enjoy effortless access to features and benefits that are tailored just for you. Start your beauty journey with us today!"},"fr":{"title":"Cr\\u00e9ez un compte ou connectez-vous maintenant","heading":"Pr\\u00eat \\u00e0 faire passer votre exp\\u00e9rience beaut\\u00e9 au niveau sup\\u00e9rieur ? Que vous soyez un nouvel utilisateur ou que vous soyez ancien, la connexion ou l\'inscription \\u00e0 SalonHub est un jeu d\'enfant. Profitez d\'un acc\\u00e8s sans effort \\u00e0 des fonctionnalit\\u00e9s et des avantages sp\\u00e9cialement con\\u00e7us pour vous. Commencez votre voyage beaut\\u00e9 avec nous d\\u00e8s aujourd\\u2019hui\\u00a0!"},"es":{"title":"Crea una cuenta o inicia sesi\\u00f3n ahora","heading":"\\u00bfListo para llevar tu experiencia de belleza al siguiente nivel? Ya sea que sea un usuario nuevo o que regrese, iniciar sesi\\u00f3n o registrarse en SalonHub es muy sencillo. Disfrute de un acceso sencillo a funciones y beneficios dise\\u00f1ados exclusivamente para usted. \\u00a1Comience su viaje de belleza con nosotros hoy!"},"ar":{"title":"\\u0642\\u0645 \\u0628\\u0625\\u0646\\u0634\\u0627\\u0621 \\u062d\\u0633\\u0627\\u0628 \\u0623\\u0648 \\u0642\\u0645 \\u0628\\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0627\\u0644\\u0622\\u0646","heading":"\\u0647\\u0644 \\u0623\\u0646\\u062a \\u0639\\u0644\\u0649 \\u0627\\u0633\\u062a\\u0639\\u062f\\u0627\\u062f \\u0644\\u0644\\u0627\\u0631\\u062a\\u0642\\u0627\\u0621 \\u0628\\u062a\\u062c\\u0631\\u0628\\u0629 \\u062c\\u0645\\u0627\\u0644\\u0643 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u0633\\u062a\\u0648\\u0649 \\u0627\\u0644\\u062a\\u0627\\u0644\\u064a\\u061f \\u0633\\u0648\\u0627\\u0621 \\u0643\\u0646\\u062a \\u0645\\u0633\\u062a\\u062e\\u062f\\u0645\\u064b\\u0627 \\u062c\\u062f\\u064a\\u062f\\u064b\\u0627 \\u0623\\u0648 \\u0639\\u0627\\u0626\\u062f\\u064b\\u0627\\u060c \\u0641\\u0625\\u0646 \\u062a\\u0633\\u062c\\u064a\\u0644 \\u0627\\u0644\\u062f\\u062e\\u0648\\u0644 \\u0623\\u0648 \\u0627\\u0644\\u0627\\u0634\\u062a\\u0631\\u0627\\u0643 \\u0641\\u064a SalonHub \\u0623\\u0645\\u0631 \\u0641\\u064a \\u063a\\u0627\\u064a\\u0629 \\u0627\\u0644\\u0633\\u0647\\u0648\\u0644\\u0629. \\u0627\\u0633\\u062a\\u0645\\u062a\\u0639 \\u0628\\u0633\\u0647\\u0648\\u0644\\u0629 \\u0627\\u0644\\u0648\\u0635\\u0648\\u0644 \\u0625\\u0644\\u0649 \\u0627\\u0644\\u0645\\u064a\\u0632\\u0627\\u062a \\u0648\\u0627\\u0644\\u0641\\u0648\\u0627\\u0626\\u062f \\u0627\\u0644\\u0645\\u0635\\u0645\\u0645\\u0629 \\u062e\\u0635\\u064a\\u0635\\u064b\\u0627 \\u0644\\u0643. \\u0627\\u0628\\u062f\\u0623 \\u0631\\u062d\\u0644\\u062a\\u0643 \\u0627\\u0644\\u062c\\u0645\\u0627\\u0644\\u064a\\u0629 \\u0645\\u0639\\u0646\\u0627 \\u0627\\u0644\\u064a\\u0648\\u0645!"}}}','status' => '1','serialize' => NULL,'created_at' => '2024-12-09 15:34:19','updated_at' => '2025-01-06 17:18:38'),
            array('id' => '19','key' => 'footer-section','value' => '{"contact":{"language":{"en":{"contact_desc":"Captivating beauty unfolds at salon \\u2013 Explore premium services, seamless bookings, and elevate your experience. Your beauty journey starts here!"},"fr":{"contact_desc":"Une beaut\\u00e9 captivante se d\\u00e9voile au salon \\u2013 Explorez des services haut de gamme, des r\\u00e9servations fluides et am\\u00e9liorez votre exp\\u00e9rience. Votre voyage beaut\\u00e9 commence ici\\u00a0!"},"es":{"contact_desc":"Una belleza cautivadora se despliega en Parlor: explore servicios premium, reservas perfectas y mejore su experiencia. \\u00a1Tu viaje de belleza comienza aqu\\u00ed!"},"ar":{"contact_desc":"\\u064a\\u062a\\u062c\\u0644\\u0649 \\u0627\\u0644\\u062c\\u0645\\u0627\\u0644 \\u0627\\u0644\\u0622\\u0633\\u0631 \\u0641\\u064a \\u0628\\u0627\\u0631\\u0644\\u0648\\u0631 - \\u0627\\u0643\\u062a\\u0634\\u0641 \\u0627\\u0644\\u062e\\u062f\\u0645\\u0627\\u062a \\u0627\\u0644\\u0645\\u062a\\u0645\\u064a\\u0632\\u0629 \\u0648\\u0627\\u0644\\u062d\\u062c\\u0648\\u0632\\u0627\\u062a \\u0627\\u0644\\u0633\\u0644\\u0633\\u0629 \\u0648\\u0627\\u0631\\u0641\\u0639 \\u0645\\u0633\\u062a\\u0648\\u0649 \\u062a\\u062c\\u0631\\u0628\\u062a\\u0643. \\u0631\\u062d\\u0644\\u0629 \\u062c\\u0645\\u0627\\u0644\\u0643 \\u062a\\u0628\\u062f\\u0623 \\u0647\\u0646\\u0627!"}},"social_links":[{"icon":"fab fa-linkedin","link":"https:\\/\\/www.linkedin.com\\/"},{"icon":"fab fa-twitter","link":"https:\\/\\/x.com\\/"},{"icon":"fab fa-instagram","link":"https:\\/\\/www.instagram.com\\/"},{"icon":"fab fa-facebook-f","link":"https:\\/\\/www.facebook.com\\/"}]}}','status' => '1','serialize' => NULL,'created_at' => '2024-12-09 16:03:59','updated_at' => '2024-12-09 16:07:12')
        ];

        SiteSections::insert($data);
    }
}
