<?php

namespace Database\Seeders\Admin;

use App\Constants\PaymentGatewayConst;
use App\Models\Admin\PaymentGateway;
use App\Models\Admin\PaymentGatewayCurrency;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PaymentGatewaySeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // Update Seeder Files
        $payment_gateways = array(
            array('id' => '1','slug' => 'payment-method','code' => '105','type' => 'AUTOMATIC','name' => 'Paypal','title' => 'Paypal Gateway','alias' => 'paypal','image' => '0bb65be8-a0cf-4d63-b9d7-5f5d7d76ce35.webp','credentials' => '[{"label":"Client ID","placeholder":"Enter Client ID","name":"client-id","value":"ASuAkb_xKKu00hA1Pk32UMJvBqE7-GizN2xxBH2nlQgkvGSpgl_h_fmvYiRw__lSwYnw6Bu0G9qtjEY6"},{"label":"Secret ID","placeholder":"Enter Secret ID","name":"secret-id","value":"EHtZKs6f0h6wDSKykJA4lJMU6GVGTc5GARto_EKQS1R5iGA2Z8n_F8sBQPTmcMWHav1GWNl8iJj169u0"}]','supported_currencies' => '["USD","GBP","PHP","NZD","MYR","EUR","CNY","CAD","AUD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-05-29 11:09:41','updated_at' => '2023-08-07 10:26:48'),
            array('id' => '5','slug' => 'payment-method','code' => '120','type' => 'AUTOMATIC','name' => 'CoinGate','title' => 'Crypto Payment gateway','alias' => 'coingate','image' => '5f5ceacd-bd60-40ba-a8f2-438a90a47388.webp','credentials' => '[{"label":"Sandbox URL","placeholder":"Enter Sandbox URL","name":"sandbox-url","value":"https:\\/\\/api-sandbox.coingate.com\\/v2"},{"label":"Sandbox App Token","placeholder":"Enter Sandbox App Token","name":"sandbox-app-token","value":"XJW4RyhT8F-xssX2PvaHMWJjYe5nsbsrbb2Uqy4m"},{"label":"Production URL","placeholder":"Enter Production URL","name":"production-url","value":"https:\\/\\/api.coingate.com\\/v2"},{"label":"Production App Token","placeholder":"Enter Production App Token","name":"production-app-token","value":null}]','supported_currencies' => '["USD","BTC","LTC","ETH","BCH","TRX","ETC","DOGE","BTG","BNB","TUSD","USDT","BSV","MATIC","BUSD","SOL","WBTC","RVN","BCD","ATOM","BTTC","EURT"]','crypto' => '1','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-08-07 10:36:30','updated_at' => '2023-08-07 12:06:12'),
            array('id' => '6','slug' => 'payment-method','code' => '125','type' => 'AUTOMATIC','name' => 'QRPay','title' => 'QRPay Gateway','alias' => 'qrpay','image' => 'b2d6bb69-b410-4582-8af3-1bf20dbadd5e.webp','credentials' => '[{"label":"Sandbox URL","placeholder":"Enter Sandbox URL","name":"sandbox-url","value":"https:\\/\\/qrpay.appdevs.net\\/pay\\/sandbox\\/api\\/v1"},{"label":"Production URL","placeholder":"Enter Production URL","name":"production-url","value":"https:\\/\\/qrpay.appdevs.net\\/pay\\/api\\/v1"},{"label":"Client ID","placeholder":"Enter Client ID","name":"client-id","value":"tRCDXCuztQzRYThPwlh1KXAYm4bG3rwWjbxM2R63kTefrGD2B9jNn6JnarDf7ycxdzfnaroxcyr5cnduY6AqpulRSebwHwRmGerA"},{"label":"Secret ID","placeholder":"Enter Secret ID","name":"secret-id","value":"oZouVmqHCbyg6ad7iMnrwq3d8wy9Kr4bo6VpQnsX6zAOoEs4oxHPjttpun36JhGxDl7AUMz3ShUqVyPmxh4oPk3TQmDF7YvHN5M3"}]','supported_currencies' => '["USD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-08-14 14:57:29','updated_at' => '2025-03-05 09:25:54'),
            array('id' => '7','slug' => 'add-money','code' => '130','type' => 'MANUAL','name' => 'WISE','title' => 'WISE Gateway','alias' => 'wise','image' => NULL,'credentials' => NULL,'supported_currencies' => '["USD"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"0","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2023-08-14 18:13:18'),
            array('id' => '8','slug' => 'add-money','code' => '135','type' => 'MANUAL','name' => 'UPI','title' => 'UPI Gateway','alias' => 'upi','image' => NULL,'credentials' => NULL,'supported_currencies' => '["INR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"0","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2023-08-14 18:13:36'),
            array('id' => '9','slug' => 'add-money','code' => '140','type' => 'MANUAL','name' => 'PayTM','title' => 'PayTM Gateway','alias' => 'paytm','image' => NULL,'credentials' => NULL,'supported_currencies' => '["INR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"0","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2023-08-14 18:13:51'),
            array('id' => '10','slug' => 'add-money','code' => '145','type' => 'MANUAL','name' => 'PhonePe','title' => 'PhonePe Gateway','alias' => 'phonepe','image' => NULL,'credentials' => NULL,'supported_currencies' => '["INR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2023-08-14 18:15:51'),
            array('id' => '11','slug' => 'add-money','code' => '150','type' => 'MANUAL','name' => 'Khalti','title' => 'Khalti Gateway','alias' => 'khalti','image' => NULL,'credentials' => NULL,'supported_currencies' => '["NPR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2023-08-14 18:16:01'),
            array('id' => '12','slug' => 'add-money','code' => '155','type' => 'MANUAL','name' => 'PayStack','title' => 'PayStack Gateway','alias' => 'paystack','image' => NULL,'credentials' => NULL,'supported_currencies' => '["NGN"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => '2023-08-14 18:16:12'),
            array('id' => '13','slug' => 'add-money','code' => '160','type' => 'MANUAL','name' => 'JazzCash','title' => 'JazzCash Gateway','alias' => 'jazzcash','image' => NULL,'credentials' => NULL,'supported_currencies' => '["PKR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '14','slug' => 'add-money','code' => '165','type' => 'MANUAL','name' => 'EasyPaisa','title' => 'EasyPaisa Gateway','alias' => 'easypaisa','image' => NULL,'credentials' => NULL,'supported_currencies' => '["PKR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '15','slug' => 'money-out','code' => '170','type' => 'MANUAL','name' => 'PayPal','title' => 'PayPal Gateway','alias' => 'paypal','image' => NULL,'credentials' => NULL,'supported_currencies' => '["USD"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '16','slug' => 'money-out','code' => '175','type' => 'MANUAL','name' => 'WISE','title' => 'WISE Gateway','alias' => 'wise','image' => NULL,'credentials' => NULL,'supported_currencies' => '["USD"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '17','slug' => 'money-out','code' => '180','type' => 'MANUAL','name' => 'UPI','title' => 'UPI Gateway','alias' => 'upi','image' => NULL,'credentials' => NULL,'supported_currencies' => '["INR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '18','slug' => 'money-out','code' => '185','type' => 'MANUAL','name' => 'PayTM','title' => 'PayTM Gateway','alias' => 'paytm','image' => NULL,'credentials' => NULL,'supported_currencies' => '["INR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '19','slug' => 'money-out','code' => '190','type' => 'MANUAL','name' => 'PhonePe','title' => 'PhonePe Gateway','alias' => 'phonepe','image' => NULL,'credentials' => NULL,'supported_currencies' => '["INR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '20','slug' => 'money-out','code' => '195','type' => 'MANUAL','name' => 'Khalti','title' => 'Khalti Gateway','alias' => 'khalti','image' => NULL,'credentials' => NULL,'supported_currencies' => '["NPR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '21','slug' => 'money-out','code' => '200','type' => 'MANUAL','name' => 'PayStack','title' => 'PayStack Gateway','alias' => 'paystack','image' => NULL,'credentials' => NULL,'supported_currencies' => '["NGN"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '22','slug' => 'money-out','code' => '205','type' => 'MANUAL','name' => 'JazzCash','title' => 'JazzCash Gateway','alias' => 'jazzcash','image' => NULL,'credentials' => NULL,'supported_currencies' => '["PKR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '23','slug' => 'money-out','code' => '210','type' => 'MANUAL','name' => 'EasyPaisa','title' => 'EasyPaisa Gateway','alias' => 'easypaisa','image' => NULL,'credentials' => NULL,'supported_currencies' => '["PKR"]','crypto' => '0','desc' => '<p>To initiate a payment using our manual payment gateway, please follow the instructions provided below. We offer two convenient methods for you to choose from:<br><strong>Option 1: PayPal Payment</strong></p><ol style="list-style-type:none;"><li>Log in to your PayPal account or access the PayPal website.</li><li>Choose the option to send money or make a payment.</li><li>Enter the recipient’s email address: <a href="mailto:business@paypal.com">business@paypal.com</a></li><li>Specify the payment amount in the currency you wish to use.</li><li>Make sure to select “Business” as the account type.</li><li>Review the payment details and confirm the transaction.</li><li>Keep the payment confirmation or receipt as proof of the transaction.</li></ol><p><strong>Option 2: Bank Transfer</strong></p><ol style="list-style-type:none;"><li>Visit your local bank or access your online banking platform.</li><li>Initiate a new fund transfer or payment.</li><li>Enter the recipient’s bank account details:</li></ol><ul style="list-style-type:none;"><li>Bank Name: Bank of America</li><li>IBAN (International Bank Account Number): 01234567890</li></ul><ol style="list-style-type:none;"><li>Specify the payment amount in the currency you intend to use.</li><li>Double-check all details, including the recipient’s account information.</li><li>Confirm and authorize the transfer.</li><li>Retain the payment receipt or confirmation for future reference.</li></ol><p>Please ensure that you keep a record of your payment as proof of the transaction. In case of any discrepancies or verification requirements, you may be asked to provide this documentation.Your payment will be manually verified by our team, and once confirmed, your order will be processed promptly. We appreciate your cooperation and look forward to serving you!</p>','input_fields' => '[{"type":"file","label":"Screenshot","name":"screenshot","required":false,"validation":{"max":"10","mimes":["jpg","png","webp","svg"],"min":"0","options":[],"required":false}},{"type":"text","label":"Transaction ID","name":"transaction_id","required":true,"validation":{"max":"60","mimes":[],"min":"1","options":[],"required":true}}]','env' => NULL,'status' => '1','last_edit_by' => '1','created_at' => NULL,'updated_at' => NULL),
            array('id' => '5001','slug' => 'payment-method','code' => '10010','type' => 'AUTOMATIC','name' => 'Stripe','title' => 'Stripe Gateway','alias' => 'stripe','image' => '357e631f-ee53-47cb-b603-71ee46b038c9.webp','credentials' => '[{"label":"Test Publishable Key","placeholder":"Enter Test Publishable Key","name":"test-publishable-key","value":"pk_test_51NECrlJXLo7QTdMco2E4YxHSeoBnDvKmmi0CZl3hxjGgH1JwgcLVUF3ZR0yFraoRgT7hf0LtOReFADhShAZqTNuB003PnBSlGP"},{"label":"Test Secret Key","placeholder":"Enter Test Secret Key","name":"test-secret-key","value":"sk_test_51NECrlJXLo7QTdMc2x7K5LaDuiS0MGNYHkO9dzzV0Y9XuWNZsXjECFsusjZEnqtxMIjCh3qtogc5sHHwL2oQ083900aFy1k7DE"},{"label":"Live Publishable Key","placeholder":"Enter Live Publishable Key","name":"live-publishable-key","value":null},{"label":"Live Secret Key","placeholder":"Enter Live Secret Key","name":"live-secret-key","value":null}]','supported_currencies' => '["USD","AUD","AED","BDT","BGN","CAD","EGP","EUR","GBP","INR","PKR","MYR","NGN"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-07 18:31:10','updated_at' => '2023-11-07 18:35:45'),
            array('id' => '5002','slug' => 'payment-method','code' => '10015','type' => 'AUTOMATIC','name' => 'Flutterwave','title' => 'Flutterwave Gateway','alias' => 'flutterwave','image' => '56069c39-b494-48e4-a938-98dc00561580.webp','credentials' => '[{"label":"Public Key","placeholder":"Enter Public Key","name":"public-key","value":"FLWPUBK_TEST-e0bc02a00395b938a4a2bed65e1bc94f-X"},{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"FLWSECK_TEST-da35e3dbd28be1e7dc5d5f3519e2ebef-X"},{"label":"Encryption key","placeholder":"Enter Encryption key","name":"encryption-key","value":"FLWSECK_TEST27bee2235efd"}]','supported_currencies' => '["AED", "ARS", "AUD", "CAD", "CHF", "CZK", "ETB", "EUR", "GBP", "GHS", "ILS", "INR", "JPY", "KES", "MAD", "MUR", "MYR", "NGN", "NOK", "NZD", "PEN", "PLN", "RUB", "RWF", "SAR", "SEK", "SGD", "SLL", "TZS", "UGX", "USD", "XAF", "XOF", "ZAR", "ZMK", "ZMW", "MWK"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-08 12:40:33','updated_at' => '2023-11-08 13:01:40'),
            array('id' => '5003','slug' => 'payment-method','code' => '10020','type' => 'AUTOMATIC','name' => 'SSLCOMMERZ','title' => 'SSLCOMMERZ Gateway','alias' => 'sslcommerz','image' => '9ce51bcf-a572-4c23-b433-a1f03ca5e99f.webp','credentials' => '[{"label":"Store ID","placeholder":"Enter Store ID","name":"store-id","value":"appde654c6741c4609"},{"label":"Store Password (API\\/Secret Key)","placeholder":"Enter Store Password (API\\/Secret Key)","name":"secret-key","value":"appde654c6741c4609@ssl"}]','supported_currencies' => '["BDT","USD","EUR","SGD","INR","MYR","GBP","AUD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-09 12:58:17','updated_at' => '2023-11-09 13:01:12'),
            array('id' => '5004','slug' => 'payment-method','code' => '10025','type' => 'AUTOMATIC','name' => 'Razorpay','title' => 'Razorpay Gateway','alias' => 'razorpay','image' => '147f7e97-d293-4f1d-8563-73630f2ce42c.webp','credentials' => '[{"label":"Key ID","placeholder":"Enter Key ID","name":"key-id","value":"rzp_test_voV4gKUbSxoQez"},{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"cJltc1jy6evA4Vvh9lTO7SWr"}]','supported_currencies' => '["USD","EUR","GBP","SGD","AED","AUD","CAD","CNY","SEK","NZD","MXN","BDT","EGP","HKD","INR","LBP","LKR","MAD","MYR","NGN","NPR","PHP","PKR","QAR","SAR","UZS","GHS"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-11-09 17:26:21','updated_at' => '2023-11-09 17:36:05'),
            array('id' => '10000','slug' => 'payment-method','code' => '20000','type' => 'AUTOMATIC','name' => 'Perfect Money','title' => 'Perfect Money Gateway','alias' => 'perfect-money','image' => '93e9d983-ccdf-4549-8a73-99b4233e0e07.webp','credentials' => '[{"label":"USD Account","placeholder":"Enter USD Account","name":"usd-account","value":"U39903302"},{"label":"EUR Account","placeholder":"Enter EUR Account","name":"eur-account","value":"E39620511"},{"label":"Alternate Passphrase","placeholder":"Enter Alternate Passphrase","name":"alternate_passphrase","value":"t0d2nbK2ZA92fRTnIFsMTWsHT"}]','supported_currencies' => '["USD","EUR"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2023-12-30 16:05:59','updated_at' => '2025-03-05 09:27:07'),
            array('id' => '10001','slug' => 'payment-method','code' => '20005','type' => 'AUTOMATIC','name' => 'Paystack','title' => 'Paystack Gateway','alias' => 'paystack','image' => '8cda00a8-c5e9-45f6-b857-4a9d17983f51.webp','credentials' => '[{"label":"Secret Key","placeholder":"Enter Secret Key","name":"secret-key","value":"sk_test_877d3ad96e1ee36a20d6736a8d358a999dad42c0"},{"label":"Email","placeholder":"Enter Email","name":"email","value":"adoctor@appdevs.team"}]','supported_currencies' => '["USD","GBP","PHP","NZD","MYR","EUR","CNY","CAD","AUD","NGN","GHS"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'env' => 'SANDBOX','status' => '1','last_edit_by' => '1','created_at' => '2024-08-08 04:26:27','updated_at' => '2025-03-05 11:46:25'),
      
            array('id' => '10005','slug' => 'payment-method','code' => '10030','type' => 'AUTOMATIC','name' => 'Authorize','title' => 'Authorize Payment Gateway','alias' => 'authorize','image' => '0e5e0ed0-edc2-4322-b887-e1c1d1dc3dc9.webp','credentials' => '[{"label":"App Login ID","placeholder":"Enter App Login ID","name":"app-login-id","value":"5wEnX48K4W85"},{"label":"Transaction Key","placeholder":"Enter Transaction Key","name":"transaction-key","value":"8Gf4uq9Nb55y7Yzg"},{"label":"Signature Key","placeholder":"Enter Signature Key","name":"signature-key","value":"B17BB1A22564FD12838A05884B51BE09EA7A98AD61E81BF6BD8BBD69414CE047D30FCBACE679AD76807670D3D261F920D80527332879790B7B4432642EA390D6"}]','supported_currencies' => '["USD"]','crypto' => '0','desc' => NULL,'input_fields' => NULL,'status' => '1','last_edit_by' => '1','created_at' => '2025-03-23 23:40:36','updated_at' => '2025-03-23 23:41:45','env' => 'SANDBOX'),
            
        );
        PaymentGateway::upsert($payment_gateways,['code'],[]);

        // Insert Payment Gateway Currencies
        $payment_gateway_currencies = array(

             array('payment_gateway_id' => '7','name' => 'WISE USD','alias' => 'add-money-wise-usd-manual','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-08-14 17:59:35','updated_at' => '2023-08-14 18:13:18'),
            array('payment_gateway_id' => '8','name' => 'UPI INR','alias' => 'add-money-upi-inr-manual','currency_code' => 'INR','currency_symbol' => '₹','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '82.96000000','created_at' => '2023-08-14 18:02:02','updated_at' => '2023-08-14 18:13:36'),
            array('payment_gateway_id' => '9','name' => 'PayTM INR','alias' => 'add-money-paytm-inr-manual','currency_code' => 'INR','currency_symbol' => '₹','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '82.96000000','created_at' => '2023-08-14 18:04:43','updated_at' => '2023-08-14 18:13:51'),
            array('payment_gateway_id' => '10','name' => 'PhonePe INR','alias' => 'add-money-phonepe-inr-manual','currency_code' => 'INR','currency_symbol' => '₹','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '82.96000000','created_at' => '2023-08-14 18:06:04','updated_at' => '2023-08-14 18:15:51'),
            array('payment_gateway_id' => '11','name' => 'Khalti NPR','alias' => 'add-money-khalti-npr-manual','currency_code' => 'NPR','currency_symbol' => 'रु‎','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '132.80000000','created_at' => '2023-08-14 18:07:42','updated_at' => '2023-08-14 18:16:01'),
            array('payment_gateway_id' => '12','name' => 'PayStack NGN','alias' => 'add-money-paystack-ngn-manual','currency_code' => 'NGN','currency_symbol' => '₦','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '770.86000000','created_at' => '2023-08-14 18:09:32','updated_at' => '2023-08-14 18:16:12'),
            array('payment_gateway_id' => '13','name' => 'JazzCash PKR','alias' => 'add-money-jazzcash-pkr-manual','currency_code' => 'PKR','currency_symbol' => 'Rs','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '289.38000000','created_at' => '2023-08-14 18:13:11','updated_at' => '2023-08-14 18:13:11'),
            array('payment_gateway_id' => '14','name' => 'EasyPaisa PKR','alias' => 'add-money-easypaisa-pkr-manual','currency_code' => 'PKR','currency_symbol' => 'Rs','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '289.38000000','created_at' => '2023-08-14 18:17:13','updated_at' => '2023-08-14 18:17:13'),
            array('payment_gateway_id' => '15','name' => 'PayPal USD','alias' => 'money-out-paypal-usd-manual','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-08-14 18:19:29','updated_at' => '2023-08-14 18:19:29'),
            array('payment_gateway_id' => '16','name' => 'WISE USD','alias' => 'money-out-wise-usd-manual','currency_code' => 'USD','currency_symbol' => '$','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-08-14 18:20:23','updated_at' => '2023-08-14 18:20:23'),
            array('payment_gateway_id' => '17','name' => 'UPI INR','alias' => 'money-out-upi-inr-manual','currency_code' => 'INR','currency_symbol' => '₹','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '82.96000000','created_at' => '2023-08-14 18:21:15','updated_at' => '2023-08-14 18:21:15'),
            array('payment_gateway_id' => '18','name' => 'PayTM INR','alias' => 'money-out-paytm-inr-manual','currency_code' => 'INR','currency_symbol' => '₹','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '82.96000000','created_at' => '2023-08-14 18:22:02','updated_at' => '2023-08-14 18:22:02'),
            array('payment_gateway_id' => '19','name' => 'PhonePe INR','alias' => 'money-out-phonepe-inr-manual','currency_code' => 'INR','currency_symbol' => '₹','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '82.96000000','created_at' => '2023-08-14 18:22:46','updated_at' => '2023-08-14 18:22:46'),
            array('payment_gateway_id' => '20','name' => 'Khalti NPR','alias' => 'money-out-khalti-npr-manual','currency_code' => 'NPR','currency_symbol' => 'रु‎','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '132.88000000','created_at' => '2023-08-14 18:24:32','updated_at' => '2023-08-14 18:24:32'),
            array('payment_gateway_id' => '21','name' => 'PayStack NGN','alias' => 'money-out-paystack-ngn-manual','currency_code' => 'NGN','currency_symbol' => '₦','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '770.86000000','created_at' => '2023-08-14 18:25:31','updated_at' => '2023-08-14 18:25:31'),
            array('payment_gateway_id' => '22','name' => 'JazzCash PKR','alias' => 'money-out-jazzcash-pkr-manual','currency_code' => 'PKR','currency_symbol' => 'Rs','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '289.38000000','created_at' => '2023-08-14 18:26:24','updated_at' => '2023-08-14 18:26:24'),
            array('payment_gateway_id' => '23','name' => 'EasyPaisa PKR','alias' => 'money-out-easypaisa-pkr-manual','currency_code' => 'PKR','currency_symbol' => 'Rs','image' => NULL,'min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '289.38000000','created_at' => '2023-08-14 18:27:12','updated_at' => '2023-08-14 18:27:12'),


            array('payment_gateway_id' => '1','name' => 'Paypal USD','alias' => 'payment-method-paypal-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => '0bb65be8-a0cf-4d63-b9d7-5f5d7d76ce35.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-05-29 11:15:57','updated_at' => '2023-08-07 10:26:48'),
            array('payment_gateway_id' => '5','name' => 'CoinGate USD','alias' => 'payment-method-coingate-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => '5f5ceacd-bd60-40ba-a8f2-438a90a47388.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-08-07 12:06:12','updated_at' => '2023-08-07 12:36:10'),
            array('payment_gateway_id' => '6','name' => 'QRPay USD','alias' => 'payment-method-qrpay-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'cd57993a-397b-49cd-bb66-5a630ea787af.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-08-14 14:58:04','updated_at' => '2023-08-14 14:58:26'),
            array('payment_gateway_id' => '5001','name' => 'Stripe USD','alias' => 'payment-method-stripe-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => '357e631f-ee53-47cb-b603-71ee46b038c9.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-11-07 18:35:45','updated_at' => '2023-11-07 18:35:45'),
            array('payment_gateway_id' => '5002','name' => 'Flutterwave USD','alias' => 'payment-method-flutterwave-usd-automatic','currency_code' => 'USD','currency_symbol' => NULL,'image' => '56069c39-b494-48e4-a938-98dc00561580.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-11-08 13:01:40','updated_at' => '2023-11-08 13:01:40'),
            array('payment_gateway_id' => '5003','name' => 'SSLCOMMERZ USD','alias' => 'payment-method-sslcommerz-usd-automatic','currency_code' => 'USD','currency_symbol' => NULL,'image' => '9ce51bcf-a572-4c23-b433-a1f03ca5e99f.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-11-09 13:01:12','updated_at' => '2023-11-09 13:01:12'),
            array('payment_gateway_id' => '5004','name' => 'Razorpay USD','alias' => 'payment-method-razorpay-usd-automatic','currency_code' => 'USD','currency_symbol' => NULL,'image' => '147f7e97-d293-4f1d-8563-73630f2ce42c.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-11-09 17:36:05','updated_at' => '2023-11-09 17:36:05'),
            array('payment_gateway_id' => '10000','name' => 'Perfect Money USD','alias' => 'payment-method-perfect-money-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => '38e0dfa8-cc70-410a-a4ae-2e303b66b93d.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1.00000000','created_at' => '2023-12-30 16:44:49','updated_at' => '2024-01-01 06:27:26'),

            array('payment_gateway_id' => '10001','name' => 'Paystack NGN','alias' => 'payment-method-paystack-ngn-automatic','currency_code' => 'NGN','currency_symbol' => '₦','image' => 'seeder/paystack.webp','min_limit' => '1.00000000','max_limit' => '10000.00000000','percent_charge' => '3.00000000','fixed_charge' => '1.00000000','rate' => '1581.46000000','created_at' => '2024-08-08 04:27:36','updated_at' => '2024-08-08 05:05:31'),
             array('payment_gateway_id' => '10005','name' => 'Authorize USD','alias' => 'payment-method-authorize-usd-automatic','currency_code' => 'USD','currency_symbol' => '$','image' => 'seeder/authorize.net.png','min_limit' => '1.00000000','max_limit' => '50.00000000','percent_charge' => '1.00000000','fixed_charge' => '0.00000000','rate' => '1.00000000','created_at' => '2025-08-12 13:27:39','updated_at' => '2025-08-12 13:27:39')
       
        );
        PaymentGatewayCurrency::upsert($payment_gateway_currencies,['alias'],[]);

    }
}
