<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('parlour_images', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('parlour_lists_id');
            $table->string('image_path');
            $table->timestamps();

            $table->foreign('parlour_lists_id')
                ->references('id')
                ->on('parlour_lists')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('parlour_images');
    }
};
