<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('parlour_bookings', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("parlour_id");
            $table->unsignedBigInteger("schedule_id");
            $table->unsignedBigInteger("user_id")->nullable();
            $table->unsignedBigInteger("vendor_id")->nullable();
            $table->unsignedBigInteger("stuff_id")->nullable();
            $table->unsignedBigInteger("payment_gateway_currency_id")->nullable();
            $table->string('trx_id')->comment('Transaction ID')->nullable();
            $table->integer('booking_exp_seconds')->default(600)->nullable();
            $table->integer('serial_number');
            $table->string('date')->comment("Booking Date");
            $table->string('payment_method')->nullable();
            $table->string('slug');
            $table->decimal('total_charge',28,8)->default(0);
            $table->decimal('price',28,8)->default(0);
            $table->decimal('payable_price',28,8)->default(0);
            $table->decimal('gateway_payable_price',28,8)->nullable();
            $table->string('service')->comment('Service Type');
            $table->text('message')->nullable();
            $table->string('type');
            $table->string('payment_currency')->nullable()->comment('user payment currency (wallet/gateway)');
            $table->string('remark')->nullable();
            //  $table->string('reminders')->nullable();
            //   $table->string('notes')->nullable();
            $table->text('details')->nullable();
            // $table->integer('review')->nullable();
            // $table->string('comment')->nullable();
            $table->tinyInteger('status')->comment(' STATUSSUCCESS= 1,STATUSPENDING= 2, STATUSREJECTED= 3')->nullable();
            $table->tinyInteger('stuff_assign_status')->comment(' stuff_assign= 1,stuff_free= 2')->nullable();
            $table->text('reject_reason')->nullable();
            $table->text('callback_ref')->nullable();
            $table->timestamps();

            $table->foreign("parlour_id")->references("id")->on("parlour_lists")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("user_id")->references("id")->on("users")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("schedule_id")->references("id")->on("parlour_list_has_schedules")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("payment_gateway_currency_id")->references("id")->on("payment_gateway_currencies")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("stuff_id")->references("id")->on("parlour_has_stuffs")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("vendor_id")->references("id")->on("vendors")->onDelete("cascade")->onUpdate("cascade");
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('parlour_bookings');
    }
};
