<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('parlour_has_stuffs', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger("parlour_list_id")->nullable();
            $table->unsignedBigInteger("vendor_id")->nullable();
            $table->string("stuff_name");
            $table->string("address");
            $table->string("mobile");
            $table->string('image');
            $table->boolean("status")->comment('free = 1,assign = 2')->default(true);
            $table->timestamps();
            $table->foreign("parlour_list_id")->references("id")->on("parlour_lists")->onDelete("cascade")->onUpdate("cascade");
            $table->foreign("vendor_id")->references("id")->on("vendors")->onDelete("cascade")->onUpdate("cascade");

        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('parlour_has_stuffs');
    }
};
