<?php

namespace App\Models\Vendor;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class VendorAuthorization extends Model
{
    use HasFactory;
    protected $guarded = ['id'];

    public function vendor() {
        return $this->belongsTo(Vendor::class, 'vendor_id');
    }

    protected $casts = [
        'id'        => "integer",
        'vendor_id' => "integer",
        'code'      => "integer",
        'token'     => "string",
    ];

}
